/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;

public class StringFixedLength
extends AbstractString {
    public StringFixedLength(String identifier, AbstractTagFrameBody frameBody, int size) {
        super(identifier, frameBody);
        if (size < 0) {
            throw new IllegalArgumentException("size is less than zero: " + size);
        }
        this.setSize(size);
    }

    public StringFixedLength(StringFixedLength copyObject) {
        super(copyObject);
        this.size = copyObject.size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StringFixedLength)) {
            return false;
        }
        StringFixedLength object = (StringFixedLength)obj;
        if (this.size != object.size) {
            return false;
        }
        return super.equals(obj);
    }

    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        logger.info("Reading from array from offset:" + offset);
        try {
            String charSetName = this.getTextEncodingCharSet();
            CharsetDecoder decoder = Charset.forName(charSetName).newDecoder();
            logger.finest("Array length is:" + arr.length + "offset is:" + offset + "Size is:" + this.size);
            if (arr.length - offset < this.size) {
                throw new InvalidDataTypeException("byte array is to small to retrieve string of declared length:" + this.size);
            }
            String str = decoder.decode(ByteBuffer.wrap(arr, offset, this.size)).toString();
            if (str == null) {
                throw new NullPointerException("String is null");
            }
            this.value = str;
        }
        catch (CharacterCodingException ce) {
            logger.severe(ce.getMessage());
            this.value = "";
        }
        logger.info("Read StringFixedLength:" + this.value);
    }

    public byte[] writeByteArray() {
        ByteBuffer dataBuffer = null;
        if (this.value == null) {
            logger.warning("Value of StringFixedlength Field is null using default value instead");
            byte[] data = new byte[this.size];
            for (int i = 0; i < this.size; ++i) {
                data[i] = 32;
            }
            return data;
        }
        try {
            String charSetName = this.getTextEncodingCharSet();
            CharsetEncoder encoder = Charset.forName(charSetName).newEncoder();
            dataBuffer = encoder.encode(CharBuffer.wrap((String)this.value));
        }
        catch (CharacterCodingException ce) {
            logger.warning("There was a problem writing the following StringFixedlength Field:" + this.value + ":" + ce.getMessage() + "using default value instead");
            byte[] data = new byte[this.size];
            for (int i = 0; i < this.size; ++i) {
                data[i] = 32;
            }
            return data;
        }
        if (dataBuffer != null) {
            if (dataBuffer.limit() == this.size) {
                byte[] data = new byte[dataBuffer.limit()];
                dataBuffer.get(data, 0, dataBuffer.limit());
                return data;
            }
            if (dataBuffer.limit() > this.size) {
                logger.warning("There was a problem writing the following StringFixedlength Field:" + this.value + " when converted to bytes has length of:" + dataBuffer.limit() + " but field was defined with length of:" + this.size + " too long so stripping extra length");
                byte[] data = new byte[this.size];
                dataBuffer.get(data, 0, this.size);
                return data;
            }
            logger.warning("There was a problem writing the following StringFixedlength Field:" + this.value + " when converted to bytes has length of:" + dataBuffer.limit() + " but field was defined with length of:" + this.size + " too short so padding with spaces to make up extra length");
            byte[] data = new byte[this.size];
            dataBuffer.get(data, 0, dataBuffer.limit());
            for (int i = dataBuffer.limit(); i < this.size; ++i) {
                data[i] = 32;
            }
            return data;
        }
        logger.warning("There was a serious problem writing the following StringFixedlength Field:" + this.value + ":" + "using default value instead");
        byte[] data = new byte[this.size];
        for (int i = 0; i < this.size; ++i) {
            data[i] = 32;
        }
        return data;
    }

    protected String getTextEncodingCharSet() {
        byte textEncoding = this.getBody().getTextEncoding();
        String charSetName = TextEncoding.getInstanceOf().getValueForId(textEncoding);
        logger.finest("text encoding:" + textEncoding + " charset:" + charSetName);
        return charSetName;
    }
}

