/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.mp3;

import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.sequencer.mp3.Mp3Metadata;

public class Mp3MetadataTest {
    private Mp3Metadata metadata;
    private InputStream imageStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.imageStream != null) {
            try {
                this.imageStream.close();
            }
            finally {
                this.imageStream = null;
            }
        }
    }

    protected InputStream getTestMp3(String resourcePath) {
        return this.getClass().getResourceAsStream("/" + resourcePath);
    }

    @Test
    public void shouldBeAbleToCreateMetadataForSample1() {
        this.metadata = Mp3Metadata.instance((InputStream)this.getTestMp3("sample1.mp3"));
        Assert.assertThat((Object)this.metadata.getAlbum(), (Matcher)Is.is((Object)"Badwater Slim Performs Live"));
        Assert.assertThat((Object)this.metadata.getAuthor(), (Matcher)Is.is((Object)"Badwater Slim"));
        Assert.assertThat((Object)this.metadata.getComment(), (Matcher)Is.is((Object)"This is a test audio file."));
        Assert.assertThat((Object)this.metadata.getTitle(), (Matcher)Is.is((Object)"Sample MP3"));
        Assert.assertThat((Object)this.metadata.getYear(), (Matcher)Is.is((Object)"2008"));
    }
}

