/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.logging.Level;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.EmptyFrameException;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidFrameIdentifierException;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagFieldKey;
import org.jaudiotagger.tag.TagNotFoundException;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.ID3Frames;
import org.jaudiotagger.tag.id3.ID3SyncSafeInteger;
import org.jaudiotagger.tag.id3.ID3v11Tag;
import org.jaudiotagger.tag.id3.ID3v1Tag;
import org.jaudiotagger.tag.id3.ID3v24FieldKey;
import org.jaudiotagger.tag.id3.ID3v24Frame;
import org.jaudiotagger.tag.id3.ID3v24Frames;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCOMM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTALB;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTCON;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDRC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIT2;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPE1;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRCK;
import org.jaudiotagger.tag.id3.valuepair.GenreTypes;
import org.jaudiotagger.tag.lyrics3.AbstractLyrics3;
import org.jaudiotagger.tag.lyrics3.Lyrics3v2;
import org.jaudiotagger.tag.lyrics3.Lyrics3v2Field;

public class ID3v24Tag
extends AbstractID3v2Tag {
    protected static final String TYPE_FOOTER = "footer";
    protected static final String TYPE_IMAGEENCODINGRESTRICTION = "imageEncodingRestriction";
    protected static final String TYPE_IMAGESIZERESTRICTION = "imageSizeRestriction";
    protected static final String TYPE_TAGRESTRICTION = "tagRestriction";
    protected static final String TYPE_TAGSIZERESTRICTION = "tagSizeRestriction";
    protected static final String TYPE_TEXTENCODINGRESTRICTION = "textEncodingRestriction";
    protected static final String TYPE_TEXTFIELDSIZERESTRICTION = "textFieldSizeRestriction";
    protected static final String TYPE_UPDATETAG = "updateTag";
    protected static final String TYPE_CRCDATA = "crcdata";
    protected static final String TYPE_EXPERIMENTAL = "experimental";
    protected static final String TYPE_EXTENDED = "extended";
    protected static final String TYPE_PADDINGSIZE = "paddingsize";
    protected static final String TYPE_UNSYNCHRONISATION = "unsyncronisation";
    protected static int TAG_EXT_HEADER_LENGTH = 6;
    protected static int TAG_EXT_HEADER_UPDATE_LENGTH = 1;
    protected static int TAG_EXT_HEADER_CRC_LENGTH = 6;
    protected static int TAG_EXT_HEADER_RESTRICTION_LENGTH = 2;
    protected static int TAG_EXT_HEADER_CRC_DATA_LENGTH = 5;
    protected static int TAG_EXT_HEADER_RESTRICTION_DATA_LENGTH = 1;
    protected static int TAG_EXT_NUMBER_BYTES_DATA_LENGTH = 1;
    public static final int MASK_V24_UNSYNCHRONIZATION = 128;
    public static final int MASK_V24_EXTENDED_HEADER = 64;
    public static final int MASK_V24_EXPERIMENTAL = 32;
    public static final int MASK_V24_FOOTER_PRESENT = 16;
    public static final int MASK_V24_TAG_UPDATE = 64;
    public static final int MASK_V24_CRC_DATA_PRESENT = 32;
    public static final int MASK_V24_TAG_RESTRICTIONS = 16;
    public static final int MASK_V24_TAG_SIZE_RESTRICTIONS = -64;
    public static final int MASK_V24_TEXT_ENCODING_RESTRICTIONS = 32;
    public static final int MASK_V24_TEXT_FIELD_SIZE_RESTRICTIONS = 24;
    public static final int MASK_V24_IMAGE_ENCODING = 4;
    public static final int MASK_V24_IMAGE_SIZE_RESTRICTIONS = 6;
    public static final int MASK_V24_TAG_ALTER_PRESERVATION = 64;
    public static final int MASK_V24_FILE_ALTER_PRESERVATION = 32;
    public static final int MASK_V24_READ_ONLY = 16;
    public static final int MASK_V24_GROUPING_IDENTITY = 64;
    public static final int MASK_V24_COMPRESSION = 16;
    public static final int MASK_V24_ENCRYPTION = 8;
    public static final int MASK_V24_FRAME_UNSYNCHRONIZATION = 4;
    public static final int MASK_V24_DATA_LENGTH_INDICATOR = 2;
    protected boolean crcDataFlag;
    protected boolean experimental;
    protected boolean extended;
    protected boolean unsynchronization;
    protected int crcData;
    protected boolean footer;
    protected boolean updateTag;
    protected boolean tagRestriction;
    protected byte imageEncodingRestriction;
    protected byte imageSizeRestriction;
    protected byte tagSizeRestriction;
    protected byte textEncodingRestriction;
    protected int paddingSize;
    protected byte textFieldSizeRestriction;
    public static final byte RELEASE = 2;
    public static final byte MAJOR_VERSION = 4;
    public static final byte REVISION = 0;

    public byte getRelease() {
        return 2;
    }

    public byte getMajorVersion() {
        return 4;
    }

    public byte getRevision() {
        return 0;
    }

    public ID3v24Tag() {
        this.crcDataFlag = false;
        this.experimental = false;
        this.extended = false;
        this.unsynchronization = false;
        this.crcData = 0;
        this.footer = false;
        this.updateTag = false;
        this.tagRestriction = false;
        this.imageEncodingRestriction = 0;
        this.imageSizeRestriction = 0;
        this.tagSizeRestriction = 0;
        this.textEncodingRestriction = 0;
        this.paddingSize = 0;
        this.textFieldSizeRestriction = 0;
        this.frameMap = new LinkedHashMap();
    }

    protected void copyPrimitives(AbstractID3v2Tag copyObj) {
        logger.info("Copying primitives");
        super.copyPrimitives(copyObj);
        if (copyObj instanceof ID3v24Tag) {
            ID3v24Tag copyObject = (ID3v24Tag)copyObj;
            this.footer = copyObject.footer;
            this.tagRestriction = copyObject.tagRestriction;
            this.updateTag = copyObject.updateTag;
            this.imageEncodingRestriction = copyObject.imageEncodingRestriction;
            this.imageSizeRestriction = copyObject.imageSizeRestriction;
            this.tagSizeRestriction = copyObject.tagSizeRestriction;
            this.textEncodingRestriction = copyObject.textEncodingRestriction;
            this.textFieldSizeRestriction = copyObject.textFieldSizeRestriction;
        }
    }

    protected void copyFrames(AbstractID3v2Tag copyObject) {
        logger.info("Copying Frames,there are:" + copyObject.frameMap.keySet().size() + " different types");
        this.frameMap = new LinkedHashMap();
        Iterator iterator = copyObject.frameMap.keySet().iterator();
        ID3v24Frame newFrame = null;
        while (iterator.hasNext()) {
            AbstractID3v2Frame frame;
            String id = (String)iterator.next();
            Object o = copyObject.frameMap.get(id);
            if (o instanceof AbstractID3v2Frame) {
                frame = (AbstractID3v2Frame)o;
                try {
                    newFrame = new ID3v24Frame(frame);
                    logger.info("Adding Frame:" + newFrame.getIdentifier());
                    this.copyFrameIntoMap(newFrame.getIdentifier(), newFrame);
                }
                catch (InvalidFrameException ife) {
                    logger.log(Level.SEVERE, "Unable to convert frame:" + frame.getIdentifier(), ife);
                }
                continue;
            }
            if (!(o instanceof ArrayList)) continue;
            ArrayList<ID3v24Frame> multiFrame = new ArrayList<ID3v24Frame>();
            ListIterator li = ((ArrayList)o).listIterator();
            while (li.hasNext()) {
                frame = (AbstractID3v2Frame)li.next();
                try {
                    newFrame = new ID3v24Frame(frame);
                    multiFrame.add(newFrame);
                }
                catch (InvalidFrameException ife) {
                    logger.log(Level.SEVERE, "Unable to convert frame:" + frame.getIdentifier());
                }
            }
            if (newFrame == null) continue;
            logger.finest("Adding multi frame list to map:" + newFrame.getIdentifier());
            this.frameMap.put(newFrame.getIdentifier(), multiFrame);
        }
    }

    public ID3v24Tag(ID3v24Tag copyObject) {
        this.crcDataFlag = false;
        this.experimental = false;
        this.extended = false;
        this.unsynchronization = false;
        this.crcData = 0;
        this.footer = false;
        this.updateTag = false;
        this.tagRestriction = false;
        this.imageEncodingRestriction = 0;
        this.imageSizeRestriction = 0;
        this.tagSizeRestriction = 0;
        this.textEncodingRestriction = 0;
        this.paddingSize = 0;
        this.textFieldSizeRestriction = 0;
        logger.info("Creating tag from another tag of same type");
        this.copyPrimitives(copyObject);
        this.copyFrames(copyObject);
    }

    public ID3v24Tag(AbstractTag mp3tag) {
        block11: {
            block13: {
                ID3v24Frame newFrame;
                AbstractID3v2FrameBody newBody;
                block12: {
                    this.crcDataFlag = false;
                    this.experimental = false;
                    this.extended = false;
                    this.unsynchronization = false;
                    this.crcData = 0;
                    this.footer = false;
                    this.updateTag = false;
                    this.tagRestriction = false;
                    this.imageEncodingRestriction = 0;
                    this.imageSizeRestriction = 0;
                    this.tagSizeRestriction = 0;
                    this.textEncodingRestriction = 0;
                    this.paddingSize = 0;
                    this.textFieldSizeRestriction = 0;
                    logger.info("Creating tag from a tag of a different version");
                    this.frameMap = new LinkedHashMap();
                    if (mp3tag == null) break block11;
                    if (mp3tag instanceof ID3v24Tag) {
                        throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
                    }
                    if (!(mp3tag instanceof AbstractID3v2Tag)) break block12;
                    this.copyPrimitives((AbstractID3v2Tag)mp3tag);
                    this.copyFrames((AbstractID3v2Tag)mp3tag);
                    break block11;
                }
                if (!(mp3tag instanceof ID3v1Tag)) break block13;
                ID3v1Tag id3tag = (ID3v1Tag)mp3tag;
                if (id3tag.title.length() > 0) {
                    newBody = new FrameBodyTIT2(0, id3tag.title);
                    newFrame = new ID3v24Frame("TIT2");
                    newFrame.setBody(newBody);
                    this.frameMap.put(newFrame.getIdentifier(), newFrame);
                }
                if (id3tag.artist.length() > 0) {
                    newBody = new FrameBodyTPE1(0, id3tag.artist);
                    newFrame = new ID3v24Frame("TPE1");
                    newFrame.setBody(newBody);
                    this.frameMap.put(newFrame.getIdentifier(), newFrame);
                }
                if (id3tag.album.length() > 0) {
                    newBody = new FrameBodyTALB(0, id3tag.album);
                    newFrame = new ID3v24Frame("TALB");
                    newFrame.setBody(newBody);
                    this.frameMap.put(newFrame.getIdentifier(), newFrame);
                }
                if (id3tag.year.length() > 0) {
                    newBody = new FrameBodyTDRC(0, id3tag.year);
                    newFrame = new ID3v24Frame("TDRC");
                    newFrame.setBody(newBody);
                    this.frameMap.put(newFrame.getIdentifier(), newFrame);
                }
                if (id3tag.comment.length() > 0) {
                    newBody = new FrameBodyCOMM(0, "ENG", "", id3tag.comment);
                    newFrame = new ID3v24Frame("COMM");
                    newFrame.setBody(newBody);
                    this.frameMap.put(newFrame.getIdentifier(), newFrame);
                }
                if ((id3tag.genre & 0xFF) >= 0 && (id3tag.genre & 0xFF) != 255) {
                    Integer genreId = id3tag.genre & 0xFF;
                    String genre = "(" + genreId + ") " + GenreTypes.getInstanceOf().getValueForId(genreId);
                    newBody = new FrameBodyTCON(0, genre);
                    newFrame = new ID3v24Frame("TCON");
                    newFrame.setBody(newBody);
                    this.frameMap.put(newFrame.getIdentifier(), newFrame);
                }
                if (!(mp3tag instanceof ID3v11Tag)) break block11;
                ID3v11Tag id3tag2 = (ID3v11Tag)mp3tag;
                if (id3tag2.track <= 0) break block11;
                newBody = new FrameBodyTRCK(0, Byte.toString(id3tag2.track));
                newFrame = new ID3v24Frame("TRCK");
                newFrame.setBody(newBody);
                this.frameMap.put(newFrame.getIdentifier(), newFrame);
                break block11;
            }
            if (mp3tag instanceof AbstractLyrics3) {
                Lyrics3v2 lyric = mp3tag instanceof Lyrics3v2 ? new Lyrics3v2((Lyrics3v2)mp3tag) : new Lyrics3v2(mp3tag);
                Iterator iterator = lyric.iterator();
                while (iterator.hasNext()) {
                    try {
                        Lyrics3v2Field field = (Lyrics3v2Field)iterator.next();
                        ID3v24Frame newFrame = new ID3v24Frame(field);
                        this.frameMap.put(newFrame.getIdentifier(), newFrame);
                    }
                    catch (InvalidTagException ex) {
                        logger.warning("Unable to convert Lyrics3 to v24 Frame:Frame Identifier");
                    }
                }
            }
        }
    }

    public ID3v24Tag(ByteBuffer buffer, String loggingFilename) throws TagException {
        this.crcDataFlag = false;
        this.experimental = false;
        this.extended = false;
        this.unsynchronization = false;
        this.crcData = 0;
        this.footer = false;
        this.updateTag = false;
        this.tagRestriction = false;
        this.imageEncodingRestriction = 0;
        this.imageSizeRestriction = 0;
        this.tagSizeRestriction = 0;
        this.textEncodingRestriction = 0;
        this.paddingSize = 0;
        this.textFieldSizeRestriction = 0;
        this.frameMap = new LinkedHashMap();
        this.setLoggingFilename(loggingFilename);
        this.read(buffer);
    }

    public ID3v24Tag(ByteBuffer buffer) throws TagException {
        this(buffer, "");
    }

    public String getIdentifier() {
        return "ID3v2.40";
    }

    public int getSize() {
        int size = 10;
        if (this.extended) {
            size += TAG_EXT_HEADER_LENGTH;
            if (this.updateTag) {
                size += TAG_EXT_HEADER_UPDATE_LENGTH;
            }
            if (this.crcDataFlag) {
                size += TAG_EXT_HEADER_CRC_LENGTH;
            }
            if (this.tagRestriction) {
                size += TAG_EXT_HEADER_RESTRICTION_LENGTH;
            }
        }
        logger.finer("Tag Size is" + (size += super.getSize()));
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v24Tag)) {
            return false;
        }
        ID3v24Tag object = (ID3v24Tag)obj;
        if (this.footer != object.footer) {
            return false;
        }
        if (this.imageEncodingRestriction != object.imageEncodingRestriction) {
            return false;
        }
        if (this.imageSizeRestriction != object.imageSizeRestriction) {
            return false;
        }
        if (this.tagRestriction != object.tagRestriction) {
            return false;
        }
        if (this.tagSizeRestriction != object.tagSizeRestriction) {
            return false;
        }
        if (this.textEncodingRestriction != object.textEncodingRestriction) {
            return false;
        }
        if (this.textFieldSizeRestriction != object.textFieldSizeRestriction) {
            return false;
        }
        if (this.updateTag != object.updateTag) {
            return false;
        }
        return super.equals(obj);
    }

    public void read(ByteBuffer byteBuffer) throws TagException {
        if (!this.seek(byteBuffer)) {
            throw new TagNotFoundException(this.getLoggingFilename() + ":" + this.getIdentifier() + " tag not found");
        }
        byte flags = byteBuffer.get();
        this.unsynchronization = (flags & 0x80) != 0;
        this.extended = (flags & 0x40) != 0;
        this.experimental = (flags & 0x20) != 0;
        boolean bl = this.footer = (flags & 0x10) != 0;
        if (this.isUnsynchronization()) {
            logger.warning(this.getLoggingFilename() + ":" + "ID3v24 Tag is unsynchronized");
        }
        if (this.extended) {
            logger.warning(this.getLoggingFilename() + ":" + "ID3v24 Tag is extended");
        }
        if (this.experimental) {
            logger.warning(this.getLoggingFilename() + ":" + "ID3v24 Tag is experimental");
        }
        if (this.footer) {
            logger.warning(this.getLoggingFilename() + ":" + "ID3v24 Tag has footer");
        }
        int size = ID3SyncSafeInteger.bufferToValue(byteBuffer);
        logger.info(this.getLoggingFilename() + ":" + "Reading tag from file size set in header is" + size);
        if (this.extended) {
            byte[] buffer;
            int extendedHeaderSize = byteBuffer.getInt();
            if (extendedHeaderSize <= TAG_EXT_HEADER_LENGTH) {
                throw new InvalidTagException(this.getLoggingFilename() + ":" + "Invalid Extended Header Size.");
            }
            byteBuffer.get();
            byte extFlag = byteBuffer.get();
            this.updateTag = (extFlag & 0x40) != 0;
            this.crcDataFlag = (extFlag & 0x20) != 0;
            boolean bl2 = this.tagRestriction = (extFlag & 0x10) != 0;
            if (this.updateTag) {
                byteBuffer.get();
            }
            if (this.crcDataFlag) {
                byteBuffer.get();
                buffer = new byte[TAG_EXT_HEADER_CRC_DATA_LENGTH];
                byteBuffer.get(buffer, 0, TAG_EXT_HEADER_CRC_DATA_LENGTH);
                this.crcData = 0;
                for (int i = 0; i < TAG_EXT_HEADER_CRC_DATA_LENGTH; ++i) {
                    this.crcData <<= 8;
                    this.crcData += buffer[i];
                }
            }
            if (this.tagRestriction) {
                byteBuffer.get();
                buffer = new byte[1];
                byteBuffer.get(buffer, 0, 1);
                this.tagSizeRestriction = (byte)((buffer[0] & 0xFFFFFFC0) >> 6);
                this.textEncodingRestriction = (byte)((buffer[0] & 0x20) >> 5);
                this.textFieldSizeRestriction = (byte)((buffer[0] & 0x18) >> 3);
                this.imageEncodingRestriction = (byte)((buffer[0] & 4) >> 2);
                this.imageSizeRestriction = (byte)(buffer[0] & 6);
            }
        }
        this.readFrames(byteBuffer, size);
    }

    protected void readFrames(ByteBuffer byteBuffer, int size) {
        logger.finest(this.getLoggingFilename() + ":" + "Start of frame body at" + byteBuffer.position());
        this.frameMap = new LinkedHashMap();
        this.fileReadSize = size;
        logger.finest(this.getLoggingFilename() + ":" + "Start of frame body at:" + byteBuffer.position() + ",frames data size is:" + size);
        while (byteBuffer.position() <= size) {
            try {
                logger.finest(this.getLoggingFilename() + ":" + "looking for next frame at:" + byteBuffer.position());
                ID3v24Frame next = new ID3v24Frame(byteBuffer, this.getLoggingFilename());
                String id = next.getIdentifier();
                this.loadFrameIntoMap(id, next);
            }
            catch (EmptyFrameException ex) {
                logger.warning(this.getLoggingFilename() + ":" + "Empty Frame:" + ex.getMessage());
                this.emptyFrameBytes += 10;
            }
            catch (InvalidFrameIdentifierException ifie) {
                logger.info(this.getLoggingFilename() + ":" + "Invalid Frame Identifier:" + ifie.getMessage());
                ++this.invalidFrameBytes;
                break;
            }
            catch (InvalidFrameException ife) {
                logger.warning(this.getLoggingFilename() + ":" + "Invalid Frame:" + ife.getMessage());
                ++this.invalidFrameBytes;
                break;
            }
        }
    }

    private ByteBuffer writeHeaderToBuffer(int padding, int size) throws IOException {
        this.unsynchronization = false;
        this.extended = false;
        this.experimental = false;
        this.footer = false;
        ByteBuffer headerBuffer = ByteBuffer.allocate(10);
        headerBuffer.put(TAG_ID);
        headerBuffer.put(this.getMajorVersion());
        headerBuffer.put(this.getRevision());
        byte flagsByte = 0;
        if (this.isUnsynchronization()) {
            flagsByte = (byte)(flagsByte | 0x80);
        }
        if (this.extended) {
            flagsByte = (byte)(flagsByte | 0x40);
        }
        if (this.experimental) {
            flagsByte = (byte)(flagsByte | 0x20);
        }
        if (this.footer) {
            flagsByte = (byte)(flagsByte | 0x10);
        }
        headerBuffer.put(flagsByte);
        int additionalHeaderSize = 0;
        if (this.extended) {
            additionalHeaderSize += TAG_EXT_HEADER_LENGTH;
            if (this.updateTag) {
                additionalHeaderSize += TAG_EXT_HEADER_UPDATE_LENGTH;
            }
            if (this.crcDataFlag) {
                additionalHeaderSize += TAG_EXT_HEADER_CRC_LENGTH;
            }
            if (this.tagRestriction) {
                additionalHeaderSize += TAG_EXT_HEADER_RESTRICTION_LENGTH;
            }
        }
        headerBuffer.put(ID3SyncSafeInteger.valueToBuffer(padding + size + additionalHeaderSize));
        ByteBuffer extHeaderBuffer = null;
        if (this.extended) {
            int extendedSize = TAG_EXT_HEADER_LENGTH;
            if (this.updateTag) {
                extendedSize += TAG_EXT_HEADER_UPDATE_LENGTH;
            }
            if (this.crcDataFlag) {
                extendedSize += TAG_EXT_HEADER_CRC_LENGTH;
            }
            if (this.tagRestriction) {
                extendedSize += TAG_EXT_HEADER_RESTRICTION_LENGTH;
            }
            extHeaderBuffer = ByteBuffer.allocate(extendedSize);
            extHeaderBuffer.putInt(extendedSize);
            extHeaderBuffer.put((byte)TAG_EXT_NUMBER_BYTES_DATA_LENGTH);
            byte extFlag = 0;
            if (this.updateTag) {
                extFlag = (byte)(extFlag | 0x40);
            }
            if (this.crcDataFlag) {
                extFlag = (byte)(extFlag | 0x20);
            }
            if (this.tagRestriction) {
                extFlag = (byte)(extFlag | 0x10);
            }
            extHeaderBuffer.put(extFlag);
            if (this.updateTag) {
                extHeaderBuffer.put((byte)0);
            }
            if (this.crcDataFlag) {
                extHeaderBuffer.put((byte)TAG_EXT_HEADER_CRC_DATA_LENGTH);
                extHeaderBuffer.put((byte)0);
                extHeaderBuffer.putInt(this.crcData);
            }
            if (this.tagRestriction) {
                extHeaderBuffer.put((byte)TAG_EXT_HEADER_RESTRICTION_DATA_LENGTH);
                extHeaderBuffer.put((byte)0);
            }
        }
        if (extHeaderBuffer != null) {
            extHeaderBuffer.flip();
            headerBuffer.put(extHeaderBuffer);
        }
        headerBuffer.flip();
        return headerBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(File file, long audioStartLocation) throws IOException {
        logger.info("Writing tag to file");
        byte[] bodyByteBuffer = this.writeFramesToBuffer().toByteArray();
        int sizeIncPadding = this.calculateTagSize(bodyByteBuffer.length + 10, (int)audioStartLocation);
        int padding = sizeIncPadding - (bodyByteBuffer.length + 10);
        ByteBuffer headerBuffer = this.writeHeaderToBuffer(padding, bodyByteBuffer.length);
        if ((long)sizeIncPadding > audioStartLocation) {
            logger.finest("Adjusting Padding");
            this.adjustPadding(file, sizeIncPadding, audioStartLocation);
        }
        FileChannel fc = null;
        try {
            fc = new RandomAccessFile(file, "rw").getChannel();
            fc.write(headerBuffer);
            fc.write(ByteBuffer.wrap(bodyByteBuffer));
            fc.write(ByteBuffer.wrap(new byte[padding]));
            Object var10_8 = null;
            if (fc == null) return;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (fc == null) throw throwable;
            fc.close();
            throw throwable;
        }
        fc.close();
    }

    public void write(WritableByteChannel channel) throws IOException {
        logger.info("Writing tag to channel");
        byte[] bodyByteBuffer = this.writeFramesToBuffer().toByteArray();
        ByteBuffer headerBuffer = this.writeHeaderToBuffer(0, bodyByteBuffer.length);
        channel.write(headerBuffer);
        channel.write(ByteBuffer.wrap(bodyByteBuffer));
    }

    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("tag", this.getIdentifier());
        super.createStructureHeader();
        MP3File.getStructureFormatter().openHeadingElement("header", "");
        MP3File.getStructureFormatter().addElement(TYPE_UNSYNCHRONISATION, this.isUnsynchronization());
        MP3File.getStructureFormatter().addElement(TYPE_CRCDATA, this.crcData);
        MP3File.getStructureFormatter().addElement(TYPE_EXPERIMENTAL, this.experimental);
        MP3File.getStructureFormatter().addElement(TYPE_EXTENDED, this.extended);
        MP3File.getStructureFormatter().addElement(TYPE_PADDINGSIZE, this.paddingSize);
        MP3File.getStructureFormatter().addElement(TYPE_FOOTER, this.footer);
        MP3File.getStructureFormatter().addElement(TYPE_IMAGEENCODINGRESTRICTION, this.paddingSize);
        MP3File.getStructureFormatter().addElement(TYPE_IMAGESIZERESTRICTION, this.imageSizeRestriction);
        MP3File.getStructureFormatter().addElement(TYPE_TAGRESTRICTION, this.tagRestriction);
        MP3File.getStructureFormatter().addElement(TYPE_TAGSIZERESTRICTION, this.tagSizeRestriction);
        MP3File.getStructureFormatter().addElement(TYPE_TEXTFIELDSIZERESTRICTION, this.textFieldSizeRestriction);
        MP3File.getStructureFormatter().addElement(TYPE_TEXTENCODINGRESTRICTION, this.textEncodingRestriction);
        MP3File.getStructureFormatter().addElement(TYPE_UPDATETAG, this.updateTag);
        MP3File.getStructureFormatter().closeHeadingElement("header");
        super.createStructureBody();
        MP3File.getStructureFormatter().closeHeadingElement("tag");
    }

    public boolean isUnsynchronization() {
        return this.unsynchronization;
    }

    protected String getArtistId() {
        return "TPE1";
    }

    protected String getAlbumId() {
        return "TALB";
    }

    protected String getTitleId() {
        return "TIT2";
    }

    protected String getTrackId() {
        return "TRCK";
    }

    protected String getYearId() {
        return "TDRC";
    }

    protected String getCommentId() {
        return "COMM";
    }

    protected String getGenreId() {
        return "TCON";
    }

    public ID3v24Frame createFrame(String id) {
        return new ID3v24Frame(id);
    }

    public TagField createTagField(ID3v24FieldKey id3Key, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (id3Key == null) {
            throw new KeyNotFoundException();
        }
        return super.doCreateTagField(new AbstractID3v2Tag.FrameAndSubId(id3Key.getFrameId(), id3Key.getSubId()), value);
    }

    public String getFirst(ID3v24FieldKey id3v24FieldKey) throws KeyNotFoundException {
        if (id3v24FieldKey == null) {
            throw new KeyNotFoundException();
        }
        return super.doGetFirst(new AbstractID3v2Tag.FrameAndSubId(id3v24FieldKey.getFrameId(), id3v24FieldKey.getSubId()));
    }

    public void deleteTagField(ID3v24FieldKey id3v24FieldKey) throws KeyNotFoundException {
        if (id3v24FieldKey == null) {
            throw new KeyNotFoundException();
        }
        super.doDeleteTagField(new AbstractID3v2Tag.FrameAndSubId(id3v24FieldKey.getFrameId(), id3v24FieldKey.getSubId()));
    }

    protected AbstractID3v2Tag.FrameAndSubId getFrameAndSubIdFromGenericKey(TagFieldKey genericKey) {
        ID3v24FieldKey id3v24FieldKey = ID3v24Frames.getInstanceOf().getId3KeyFromGenericKey(genericKey);
        if (id3v24FieldKey == null) {
            throw new KeyNotFoundException();
        }
        return new AbstractID3v2Tag.FrameAndSubId(id3v24FieldKey.getFrameId(), id3v24FieldKey.getSubId());
    }

    protected ID3Frames getID3Frames() {
        return ID3v24Frames.getInstanceOf();
    }
}

