/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.ContentDescription;
import org.jaudiotagger.audio.asf.data.ContentDescriptor;
import org.jaudiotagger.audio.asf.data.ExtendedContentDescription;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.AsfHeaderReader;
import org.jaudiotagger.audio.asf.util.ChunkPositionComparator;
import org.jaudiotagger.audio.asf.util.TagConverter;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.generic.AudioFileWriter;
import org.jaudiotagger.audio.generic.GenericTag;
import org.jaudiotagger.tag.Tag;

public class AsfFileWriter
extends AudioFileWriter {
    private void copy(RandomAccessFile source, RandomAccessFile destination, long number) throws IOException {
        byte[] buffer = new byte[8192];
        long bytesCopied = 0L;
        int read = -1;
        while ((read = source.read(buffer, 0, bytesCopied + 8192L > number ? (int)(number - bytesCopied) : 8192)) > 0) {
            bytesCopied += (long)read;
            destination.write(buffer, 0, read);
        }
    }

    private void createModifiedCopy(Tag tag, AsfHeader header, RandomAccessFile raf, RandomAccessFile rafTemp, boolean ignoreDescriptions) throws IOException {
        raf.seek(0L);
        this.copy(raf, rafTemp, 30L);
        Chunk[] chunks = this.getOrderedChunks(header);
        long fileSizeDifference = 0L;
        long chunkCount = header.getChunkCount();
        long newFileHeaderPos = -1L;
        if (header.getExtendedContentDescription() == null && this.isExtendedContentDescriptionMandatory(tag) && !ignoreDescriptions) {
            ++chunkCount;
            fileSizeDifference += this.createNewExtendedContentDescription(tag, null, rafTemp).getChunkLength().longValue();
        }
        if (header.getContentDescription() == null && this.isContentdescriptionMandatory(tag) && !ignoreDescriptions) {
            ++chunkCount;
            fileSizeDifference += this.createNewContentDescription(tag, null, rafTemp).getChunkLength().longValue();
        }
        for (int i = 0; i < chunks.length; ++i) {
            if (chunks[i] == header.getContentDescription()) {
                if (ignoreDescriptions) {
                    --chunkCount;
                    fileSizeDifference -= header.getContentDescription().getChunkLength().longValue();
                    continue;
                }
                fileSizeDifference += this.createNewContentDescription(tag, header.getContentDescription(), rafTemp).getChunkLength().subtract(header.getContentDescription().getChunkLength()).longValue();
                continue;
            }
            if (chunks[i] == header.getExtendedContentDescription()) {
                if (this.deleteExtendedContentDescription(header.getExtendedContentDescription(), tag) || ignoreDescriptions) {
                    --chunkCount;
                    fileSizeDifference -= header.getExtendedContentDescription().getChunkLength().longValue();
                    continue;
                }
                fileSizeDifference += this.createNewExtendedContentDescription(tag, header.getExtendedContentDescription(), rafTemp).getChunkLength().subtract(header.getExtendedContentDescription().getChunkLength()).longValue();
                continue;
            }
            if (GUID.GUID_FILE.equals(chunks[i].getGuid())) {
                newFileHeaderPos = rafTemp.getFilePointer();
            }
            raf.seek(chunks[i].getPosition());
            this.copy(raf, rafTemp, chunks[i].getChunkLength().longValue());
        }
        raf.seek(header.getChunckEnd());
        this.copy(raf, rafTemp, raf.length() - raf.getFilePointer());
        rafTemp.seek(24L);
        this.write16UINT(chunkCount, rafTemp);
        rafTemp.seek(newFileHeaderPos + 40L);
        this.write32UINT(header.getFileHeader().getFileSize().longValue() + fileSizeDifference, rafTemp);
        rafTemp.seek(16L);
        this.write32UINT(header.getChunkLength().longValue() + fileSizeDifference, rafTemp);
    }

    private Chunk createNewContentDescription(Tag tag, ContentDescription contentDescription, RandomAccessFile rafTemp) throws IOException {
        long chunkStart = rafTemp.getFilePointer();
        ContentDescription description = TagConverter.createContentDescription(tag);
        if (contentDescription != null) {
            description.setRating(contentDescription.getRating());
        }
        byte[] asfContent = description.getBytes();
        rafTemp.write(asfContent);
        return new Chunk(GUID.GUID_CONTENTDESCRIPTION, chunkStart, BigInteger.valueOf(asfContent.length));
    }

    private Chunk createNewExtendedContentDescription(Tag tag, ExtendedContentDescription tagChunk, RandomAccessFile rafTemp) throws IOException {
        long chunkStart = rafTemp.getFilePointer();
        if (tagChunk == null) {
            tagChunk = new ExtendedContentDescription();
        }
        TagConverter.assignCommonTagValues(tag, tagChunk);
        TagConverter.assignOptionalTagValues(tag, tagChunk);
        byte[] asfBytes = tagChunk.getBytes();
        rafTemp.write(asfBytes);
        return new Chunk(GUID.GUID_EXTENDED_CONTENT_DESCRIPTION, chunkStart, BigInteger.valueOf(asfBytes.length));
    }

    private boolean deleteExtendedContentDescription(ExtendedContentDescription tagHeader, Tag tag) {
        HashSet<String> ignoreDescriptors = new HashSet<String>(Arrays.asList("WM/Genre", "WM/GenreID", "WM/TrackNumber", "WM/AlbumTitle", "WM/Year"));
        Iterator it = tagHeader.getDescriptors().iterator();
        boolean found = false;
        while (it.hasNext() && !found) {
            ContentDescriptor current = (ContentDescriptor)it.next();
            found = !ignoreDescriptors.contains(current.getName());
        }
        return !found && !this.isExtendedContentDescriptionMandatory(tag);
    }

    protected void deleteTag(RandomAccessFile raf, RandomAccessFile tempRaf) throws CannotWriteException, IOException {
        try {
            AsfHeader header = AsfHeaderReader.readHeader(raf);
            if (header == null) {
                throw new NullPointerException("Header is null, so file couldn't be read properly. (Interpretation of data, not file access rights.)");
            }
            this.createModifiedCopy(new GenericTag(), header, raf, tempRaf, true);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception cre) {
            throw new CannotWriteException("Cannot modify tag because exception occured:\n   " + cre.getMessage());
        }
    }

    private Chunk[] getOrderedChunks(AsfHeader header) {
        int i;
        ArrayList<Chunk> result = new ArrayList<Chunk>();
        for (i = 0; i < header.getUnspecifiedChunkCount(); ++i) {
            result.add(header.getUnspecifiedChunk(i));
        }
        for (i = 0; i < header.getStreamChunkCount(); ++i) {
            result.add(header.getStreamChunk(i));
        }
        if (header.getContentDescription() != null) {
            result.add(header.getContentDescription());
        }
        result.add(header.getFileHeader());
        if (header.getExtendedContentDescription() != null) {
            result.add(header.getExtendedContentDescription());
        }
        if (header.getEncodingChunk() != null) {
            result.add(header.getEncodingChunk());
        }
        if (header.getStreamBitratePropertiesChunk() != null) {
            result.add(header.getStreamBitratePropertiesChunk());
        }
        Chunk[] tmp = result.toArray(new Chunk[result.size()]);
        Arrays.sort(tmp, new ChunkPositionComparator());
        return tmp;
    }

    private boolean isContentdescriptionMandatory(Tag tag) {
        return tag.getFirstArtist().trim().length() > 0 || tag.getFirstComment().trim().length() > 0 || tag.getFirstTitle().trim().length() > 0;
    }

    private boolean isExtendedContentDescriptionMandatory(Tag tag) {
        return tag.getFirstTrack().trim().length() > 0 || tag.getFirstYear().trim().length() > 0 || tag.getFirstGenre().trim().length() > 0 || tag.getFirstAlbum().trim().length() > 0;
    }

    private int write16UINT(long value, RandomAccessFile raf) throws IOException {
        raf.write((int)value & 0xFF);
        raf.write((int)(value >>= 8) & 0xFF);
        return 2;
    }

    private int write32UINT(long value, RandomAccessFile raf) throws IOException {
        raf.write((int)value & 0xFF);
        raf.write((int)(value >>= 8) & 0xFF);
        raf.write((int)(value >>= 8) & 0xFF);
        raf.write((int)(value >>= 8) & 0xFF);
        return 4;
    }

    protected void writeTag(Tag tag, RandomAccessFile raf, RandomAccessFile rafTemp) throws CannotWriteException, IOException {
        try {
            AsfHeader header = AsfHeaderReader.readHeader(raf);
            if (header == null) {
                throw new NullPointerException("Header is null, so file couldn't be read properly. (Interpretation of data, not file access rights.)");
            }
            this.createModifiedCopy(tag, header, raf, rafTemp, false);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception cre) {
            throw new CannotWriteException("Cannot modify tag because exception occured:\n   " + cre.getMessage());
        }
    }
}

