/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.jaudiotagger.tag.datatype.HashMapInterface;
import org.jaudiotagger.tag.datatype.StringFixedLength;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.Languages;

public class StringHashMap
extends StringFixedLength
implements HashMapInterface {
    Map keyToValue = null;
    Map valueToKey = null;
    boolean hasEmptyValue = false;

    public StringHashMap(String identifier, AbstractTagFrameBody frameBody, int size) {
        super(identifier, frameBody, size);
        if (!identifier.equals("Language")) {
            throw new IllegalArgumentException("Hashmap identifier not defined in this class: " + identifier);
        }
        this.valueToKey = Languages.getInstanceOf().getValueToIdMap();
        this.keyToValue = Languages.getInstanceOf().getIdToValueMap();
    }

    public StringHashMap(StringHashMap copyObject) {
        super(copyObject);
        this.hasEmptyValue = copyObject.hasEmptyValue;
        this.keyToValue = copyObject.keyToValue;
        this.valueToKey = copyObject.valueToKey;
    }

    public Map getKeyToValue() {
        return this.keyToValue;
    }

    public Map getValueToKey() {
        return this.valueToKey;
    }

    public void setValue(Object value) {
        this.value = value instanceof String ? ((String)value).toLowerCase() : value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StringHashMap)) {
            return false;
        }
        StringHashMap object = (StringHashMap)obj;
        if (this.hasEmptyValue != object.hasEmptyValue) {
            return false;
        }
        if (this.keyToValue == null ? object.keyToValue != null : !((Object)this.keyToValue).equals(object.keyToValue)) {
            return false;
        }
        if (this.keyToValue == null ? object.keyToValue != null : !((Object)this.valueToKey).equals(object.valueToKey)) {
            return false;
        }
        return super.equals(obj);
    }

    public Iterator iterator() {
        if (this.keyToValue == null) {
            return null;
        }
        TreeSet treeSet = new TreeSet(this.keyToValue.values());
        if (this.hasEmptyValue) {
            treeSet.add("");
        }
        return treeSet.iterator();
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        if (this.keyToValue.get(this.value) == null) {
            return "";
        }
        return this.keyToValue.get(this.value).toString();
    }

    protected String getTextEncodingCharSet() {
        return "ISO-8859-1";
    }
}

