/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.test;

import java.io.File;
import java.io.FileFilter;
import java.text.DateFormat;
import java.util.Date;
import org.jaudiotagger.audio.mp3.MP3File;

public class TestAudioTagger {
    private static int count = 0;
    private static int failed = 0;

    public static void main(String[] args) {
        TestAudioTagger test = new TestAudioTagger();
        if (args.length == 0) {
            System.err.println("usage TestAudioTagger Dirname");
            System.err.println("      You must enter the root directory");
            System.exit(1);
        } else if (args.length > 1) {
            System.err.println("usage TestAudioTagger Dirname");
            System.err.println("      Only one parameter accepted");
            System.exit(1);
        }
        File rootDir = new File(args[0]);
        if (!rootDir.isDirectory()) {
            System.err.println("usage TestAudioTagger Dirname");
            System.err.println("      Directory " + args[0] + " could not be found");
            System.exit(1);
        }
        Date start = new Date();
        System.out.println("Started to read from:" + rootDir.getPath() + " at " + DateFormat.getTimeInstance().format(start));
        test.scanSingleDir(rootDir);
        Date finish = new Date();
        System.out.println("Started to read from:" + rootDir.getPath() + " at " + DateFormat.getTimeInstance().format(start));
        System.out.println("Finished to read from:" + rootDir.getPath() + DateFormat.getTimeInstance().format(finish));
        System.out.println("Attempted  to read:" + count);
        System.out.println("Successful to read:" + (count - failed));
        System.out.println("Failed     to read:" + failed);
    }

    private void scanSingleDir(File dir) {
        File[] audioFileDirs;
        File[] audioFiles = dir.listFiles(new MP3FileFilter());
        if (audioFiles.length > 0) {
            for (File audioFile : audioFiles) {
                ++count;
                File mp3File = audioFile;
                try {
                    MP3File tmpMP3 = new MP3File(mp3File);
                }
                catch (Throwable t) {
                    System.err.println("Unable to read record:" + count + ":" + mp3File.getPath());
                    ++failed;
                    t.printStackTrace();
                }
            }
        }
        if ((audioFileDirs = dir.listFiles(new DirFilter())).length > 0) {
            for (File audioFileDir : audioFileDirs) {
                this.scanSingleDir(audioFileDir);
            }
        }
    }

    public final class DirFilter
    implements FileFilter {
        public static final String IDENT = "$Id: TestAudioTagger.java,v 1.9 2007/08/06 16:04:37 paultaylor Exp $";

        public final boolean accept(File file) {
            return file.isDirectory();
        }
    }

    final class MP3FileFilter
    extends javax.swing.filechooser.FileFilter
    implements FileFilter {
        private final boolean allowDirectories;

        public MP3FileFilter() {
            this(false);
        }

        private MP3FileFilter(boolean allowDirectories) {
            this.allowDirectories = allowDirectories;
        }

        public final boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".mp3") || file.isDirectory() && this.allowDirectories;
        }

        public final String getDescription() {
            return new String(".mp3 Files");
        }
    }
}

