/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.ContentDescriptor;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;

public class ExtendedContentDescription
extends Chunk {
    public static final String[] DEFAULT_GENRES = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A capella", "Euro-House", "Dance Hall"};
    private final ArrayList descriptors = new ArrayList();
    private HashMap indexMap = null;

    public ExtendedContentDescription() {
        this(0L, BigInteger.valueOf(0L));
    }

    public ExtendedContentDescription(long pos, BigInteger chunkLen) {
        super(GUID.GUID_EXTENDED_CONTENT_DESCRIPTION, pos, chunkLen);
    }

    public void addDescriptor(ContentDescriptor toAdd) {
        assert (toAdd != null) : "Argument must not be null.";
        if (this.getDescriptor(toAdd.getName()) != null) {
            throw new RuntimeException(toAdd.getName() + " is already present");
        }
        this.descriptors.add(toAdd);
        this.indexMap.put(toAdd.getName(), new Integer(this.descriptors.size() - 1));
    }

    public void addOrReplace(ContentDescriptor descriptor) {
        assert (descriptor != null) : "Argument must not be null";
        if (this.getDescriptor(descriptor.getName()) != null) {
            this.remove(descriptor.getName());
        }
        this.addDescriptor(descriptor);
    }

    public String getAlbum() {
        ContentDescriptor result = this.getDescriptor("WM/AlbumTitle");
        if (result == null) {
            return "";
        }
        return result.getString();
    }

    public String getArtist() {
        ContentDescriptor result = this.getDescriptor("WM/AlbumArtist");
        if (result == null) {
            return "";
        }
        return result.getString();
    }

    public byte[] getBytes() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            content.write(Utils.getBytes(this.descriptors.size(), 2));
            for (ContentDescriptor current : this.descriptors) {
                content.write(current.getBytes());
            }
            byte[] contentBytes = content.toByteArray();
            result.write(GUID.GUID_EXTENDED_CONTENT_DESCRIPTION.getBytes());
            result.write(Utils.getBytes(contentBytes.length + 24, 8));
            result.write(contentBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toByteArray();
    }

    public ContentDescriptor getDescriptor(String name) {
        Integer pos;
        if (this.indexMap == null) {
            this.indexMap = new HashMap();
            for (int i = 0; i < this.descriptors.size(); ++i) {
                ContentDescriptor current = (ContentDescriptor)this.descriptors.get(i);
                this.indexMap.put(current.getName(), new Integer(i));
            }
        }
        if ((pos = (Integer)this.indexMap.get(name)) != null) {
            return (ContentDescriptor)this.descriptors.get(pos);
        }
        return null;
    }

    public long getDescriptorCount() {
        return this.descriptors.size();
    }

    public Collection getDescriptors() {
        return new ArrayList(this.descriptors);
    }

    public String getGenre() {
        String result = null;
        ContentDescriptor prop = this.getDescriptor("WM/Genre");
        if (prop == null) {
            prop = this.getDescriptor("WM/GenreID");
            if (prop == null) {
                result = "";
            } else {
                result = prop.getString();
                if (result.startsWith("(") && result.endsWith(")")) {
                    result = result.substring(1, result.length() - 1);
                    try {
                        int genreNum = Integer.parseInt(result);
                        if (genreNum >= 0 && genreNum < DEFAULT_GENRES.length) {
                            result = DEFAULT_GENRES[genreNum];
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        } else {
            result = prop.getString();
        }
        return result;
    }

    public String getTrack() {
        ContentDescriptor result = this.getDescriptor("WM/TrackNumber");
        if (result == null) {
            return "";
        }
        return result.getString();
    }

    public String getYear() {
        ContentDescriptor result = this.getDescriptor("WM/Year");
        if (result == null) {
            return "";
        }
        return result.getString();
    }

    public String prettyPrint() {
        StringBuffer result = new StringBuffer(super.prettyPrint());
        result.insert(0, "\nExtended Content Description:\n");
        Object[] list = this.descriptors.toArray(new ContentDescriptor[this.descriptors.size()]);
        Arrays.sort(list);
        for (int i = 0; i < list.length; ++i) {
            result.append("   ");
            result.append(list[i]);
            result.append(Utils.LINE_SEPARATOR);
        }
        return result.toString();
    }

    public ContentDescriptor remove(String id) {
        ContentDescriptor result = this.getDescriptor(id);
        if (result != null) {
            this.descriptors.remove(result);
        }
        this.indexMap = null;
        return result;
    }
}

