/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.util.logging.Logger;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.AbstractTagFrame;
import org.jaudiotagger.tag.id3.ID3v24Frame;

public class ID3TextEncodingConversion {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.tag.id3");

    public static byte getTextEncoding(AbstractTagFrame header, byte textEncoding) {
        if (header == null) {
            logger.warning("Header has not yet been set for this framebody");
            if (TagOptionSingleton.getInstance().isResetTextEncodingForExistingFrames()) {
                return TagOptionSingleton.getInstance().getId3v23DefaultTextEncoding();
            }
            return ID3TextEncodingConversion.convertV24textEncodingToV23textEncoding(textEncoding);
        }
        if (header instanceof ID3v24Frame) {
            if (TagOptionSingleton.getInstance().isResetTextEncodingForExistingFrames()) {
                return TagOptionSingleton.getInstance().getId3v24DefaultTextEncoding();
            }
            return textEncoding;
        }
        if (TagOptionSingleton.getInstance().isResetTextEncodingForExistingFrames()) {
            return TagOptionSingleton.getInstance().getId3v23DefaultTextEncoding();
        }
        return ID3TextEncodingConversion.convertV24textEncodingToV23textEncoding(textEncoding);
    }

    public static byte getUnicodeTextEncoding(AbstractTagFrame header) {
        if (header == null) {
            logger.warning("Header has not yet been set for this framebody");
            return 1;
        }
        if (header instanceof ID3v24Frame) {
            return TagOptionSingleton.getInstance().getId3v24UnicodeTextEncoding();
        }
        return 1;
    }

    private static byte convertV24textEncodingToV23textEncoding(byte textEncoding) {
        if (textEncoding == 2 || textEncoding == 3) {
            return 1;
        }
        return textEncoding;
    }
}

