/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.msoffice;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.msoffice.MSOfficeMetadata;
import org.modeshape.sequencer.msoffice.MSOfficeMetadataLexicon;
import org.modeshape.sequencer.msoffice.MSOfficeMetadataReader;
import org.modeshape.sequencer.msoffice.excel.ExcelMetadata;
import org.modeshape.sequencer.msoffice.excel.ExcelMetadataReader;
import org.modeshape.sequencer.msoffice.powerpoint.PowerPointMetadataReader;
import org.modeshape.sequencer.msoffice.powerpoint.SlideMetadata;
import org.modeshape.sequencer.msoffice.word.WordMetadata;
import org.modeshape.sequencer.msoffice.word.WordMetadataReader;

public class MSOfficeMetadataSequencer
implements StreamSequencer {
    public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
        MSOfficeMetadata metadata = MSOfficeMetadataReader.instance(stream);
        String mimeType = context.getMimeType();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        Path metadataNode = (Path)pathFactory.create(MSOfficeMetadataLexicon.METADATA_NODE);
        if (metadata == null) {
            return;
        }
        output.setProperty(metadataNode, JcrLexicon.PRIMARY_TYPE, new Object[]{MSOfficeMetadataLexicon.METADATA_NODE});
        output.setProperty(metadataNode, MSOfficeMetadataLexicon.TITLE, new Object[]{metadata.getTitle()});
        output.setProperty(metadataNode, MSOfficeMetadataLexicon.SUBJECT, new Object[]{metadata.getSubject()});
        output.setProperty(metadataNode, MSOfficeMetadataLexicon.AUTHOR, new Object[]{metadata.getAuthor()});
        output.setProperty(metadataNode, MSOfficeMetadataLexicon.KEYWORDS, new Object[]{metadata.getKeywords()});
        output.setProperty(metadataNode, MSOfficeMetadataLexicon.COMMENT, new Object[]{metadata.getComment()});
        output.setProperty(metadataNode, MSOfficeMetadataLexicon.TEMPLATE, new Object[]{metadata.getTemplate()});
        output.setProperty(metadataNode, MSOfficeMetadataLexicon.LAST_SAVED_BY, new Object[]{metadata.getLastSavedBy()});
        output.setProperty(metadataNode, MSOfficeMetadataLexicon.REVISION, new Object[]{metadata.getRevision()});
        output.setProperty(metadataNode, MSOfficeMetadataLexicon.TOTAL_EDITING_TIME, new Object[]{metadata.getTotalEditingTime()});
        output.setProperty(metadataNode, MSOfficeMetadataLexicon.LAST_PRINTED, new Object[]{metadata.getLastPrinted()});
        output.setProperty(metadataNode, MSOfficeMetadataLexicon.CREATED, new Object[]{metadata.getCreated()});
        output.setProperty(metadataNode, MSOfficeMetadataLexicon.SAVED, new Object[]{metadata.getSaved()});
        output.setProperty(metadataNode, MSOfficeMetadataLexicon.PAGES, new Object[]{metadata.getPages()});
        output.setProperty(metadataNode, MSOfficeMetadataLexicon.WORDS, new Object[]{metadata.getWords()});
        output.setProperty(metadataNode, MSOfficeMetadataLexicon.CHARACTERS, new Object[]{metadata.getCharacters()});
        output.setProperty(metadataNode, MSOfficeMetadataLexicon.CREATING_APPLICATION, new Object[]{metadata.getCreatingApplication()});
        output.setProperty(metadataNode, MSOfficeMetadataLexicon.THUMBNAIL, new Object[]{metadata.getThumbnail()});
        if (mimeType.equals("application/vnd.ms-powerpoint")) {
            try {
                List<SlideMetadata> ppt_metadata = PowerPointMetadataReader.instance(stream);
                if (ppt_metadata != null) {
                    Path pptPath = pathFactory.create(metadataNode, new Name[]{MSOfficeMetadataLexicon.SLIDE});
                    for (SlideMetadata sm : ppt_metadata) {
                        output.setProperty(pptPath, MSOfficeMetadataLexicon.TITLE, new Object[]{sm.getTitle()});
                        output.setProperty(pptPath, MSOfficeMetadataLexicon.TEXT, new Object[]{sm.getText()});
                        output.setProperty(pptPath, MSOfficeMetadataLexicon.NOTES, new Object[]{sm.getNotes()});
                        output.setProperty(pptPath, MSOfficeMetadataLexicon.THUMBNAIL, new Object[]{sm.getThumbnail()});
                    }
                }
            }
            catch (IOException e) {
                context.getLogger(this.getClass()).debug((Throwable)e, "Error while extracting the PowerPoint metadata", new Object[0]);
            }
        }
        if (mimeType.equals("application/vnd.ms-word")) {
            try {
                WordMetadata wordMetadata = WordMetadataReader.instance(stream);
                Path wordPath = pathFactory.create(metadataNode, new Name[]{MSOfficeMetadataLexicon.HEADING_NODE});
                for (WordMetadata.WordHeading heading : wordMetadata.getHeadings()) {
                    output.setProperty(wordPath, MSOfficeMetadataLexicon.HEADING_NAME, new Object[]{heading.getText()});
                    output.setProperty(wordPath, MSOfficeMetadataLexicon.HEADING_LEVEL, new Object[]{heading.getHeaderLevel()});
                }
            }
            catch (IOException e) {
                context.getLogger(this.getClass()).debug((Throwable)e, "Error while extracting the Word document metadata", new Object[0]);
            }
        }
        if (mimeType.equals("application/vnd.ms-excel")) {
            try {
                ExcelMetadata excel_metadata = ExcelMetadataReader.instance(stream);
                if (excel_metadata != null) {
                    output.setProperty(metadataNode, MSOfficeMetadataLexicon.FULL_CONTENT, new Object[]{excel_metadata.getText()});
                    for (String sheet : excel_metadata.getSheets()) {
                        output.setProperty(metadataNode, MSOfficeMetadataLexicon.SHEET_NAME, new Object[]{sheet});
                    }
                }
            }
            catch (IOException e) {
                context.getLogger(this.getClass()).debug((Throwable)e, "Error while extracting the Excel metadata", new Object[0]);
            }
        }
    }
}

