/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

import org.apache.poi.util.LittleEndian;

public final class BorderCode
implements Cloneable {
    public static final int SIZE = 4;
    private short _info;
    private short _info2;

    public BorderCode() {
    }

    public BorderCode(byte[] buf, int offset) {
        this._info = LittleEndian.getShort(buf, offset);
        this._info2 = LittleEndian.getShort(buf, offset + 2);
    }

    public void serialize(byte[] buf, int offset) {
        LittleEndian.putShort(buf, offset, this._info);
        LittleEndian.putShort(buf, offset + 2, this._info2);
    }

    public int toInt() {
        byte[] buf = new byte[4];
        this.serialize(buf, 0);
        return LittleEndian.getInt(buf);
    }

    public boolean isEmpty() {
        return this._info == 0 && this._info2 == 0;
    }

    public boolean equals(Object o) {
        BorderCode brc = (BorderCode)o;
        return this._info == brc._info && this._info2 == brc._info2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

