/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.msoffice.excel;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.modeshape.sequencer.msoffice.excel.ExcelMetadata;
import org.modeshape.sequencer.msoffice.excel.ExcelSheetMetadata;

public class ExcelMetadataReader {
    private static final char ROW_DELIMITER_CHAR = '\n';
    private static final char CELL_DELIMITER_CHAR = '\t';

    public static ExcelMetadata instance(InputStream stream) throws IOException {
        ExcelMetadata metadata = new ExcelMetadata();
        HSSFWorkbook wb = new HSSFWorkbook(new POIFSFileSystem(stream));
        ArrayList<ExcelSheetMetadata> sheets = new ArrayList<ExcelSheetMetadata>();
        for (int sheetInd = 0; sheetInd < wb.getNumberOfSheets(); ++sheetInd) {
            ExcelSheetMetadata meta = new ExcelSheetMetadata();
            meta.setName(wb.getSheetName(sheetInd));
            sheets.add(meta);
            HSSFSheet worksheet = wb.getSheetAt(sheetInd);
            int lastRowNum = worksheet.getLastRowNum();
            StringBuffer buff = new StringBuffer();
            for (int rowNum = worksheet.getFirstRowNum(); rowNum <= lastRowNum; ++rowNum) {
                HSSFRow row = worksheet.getRow(rowNum);
                if (row == null) continue;
                short lastCellNum = row.getLastCellNum();
                for (int cellNum = row.getFirstCellNum(); cellNum < lastCellNum; ++cellNum) {
                    HSSFCell cell = row.getCell(cellNum);
                    switch (cell.getCellType()) {
                        case 1: {
                            buff.append(cell.getRichStringCellValue().getString());
                            break;
                        }
                        case 0: {
                            buff.append(cell.getNumericCellValue());
                            break;
                        }
                        case 2: {
                            buff.append(cell.getCellFormula());
                        }
                    }
                    HSSFComment comment = cell.getCellComment();
                    if (comment != null) {
                        String commentText = ((HSSFRichTextString)comment.getString()).getString().replace('\n', ' ');
                        buff.append(" [");
                        buff.append(commentText);
                        buff.append(" by ");
                        buff.append(comment.getAuthor());
                        buff.append(']');
                    }
                    if (cellNum < lastCellNum - 1) {
                        buff.append('\t');
                        continue;
                    }
                    buff.append('\n');
                }
            }
            meta.setText(buff.toString());
        }
        metadata.setSheets(sheets);
        metadata.setMetadata(wb.getSummaryInformation());
        return metadata;
    }
}

