/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.sramp;

import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.sramp.SymbolSpace;
import org.modeshape.sequencer.sramp.SymbolSpaceResolvers;
import org.xml.sax.InputSource;

public abstract class AbstractResolvingReader {
    private final SymbolSpaceResolvers resolvers;
    private List<ResolveFuture> resolveFutures = new LinkedList<ResolveFuture>();
    protected final Sequencer.Context context;
    protected final Logger logger = Logger.getLogger(this.getClass());

    public AbstractResolvingReader(Sequencer.Context context, SymbolSpaceResolvers resolvers) {
        CheckArg.isNotNull((Object)context, (String)"context");
        this.context = context;
        this.resolvers = resolvers != null ? resolvers : new SymbolSpaceResolvers();
    }

    public AbstractResolvingReader(Sequencer.Context context) {
        this(context, null);
    }

    public SymbolSpaceResolvers getResolvers() {
        return this.resolvers;
    }

    public Sequencer.Context getContext() {
        return this.context;
    }

    public void read(InputStream stream, Node outputNode) throws Exception {
        this.read(new InputSource(stream), outputNode);
    }

    public abstract void read(InputSource var1, Node var2) throws Exception;

    protected void registerForSymbolSpace(SymbolSpace symbolSpace, String namespace, String name, String identifier) {
        this.resolvers.get(symbolSpace).register(namespace, name, identifier);
    }

    protected String registerNamespace(NamespaceRegistry registry, String namespaceUri, String defaultPrefix) throws RepositoryException {
        List<String> allNamespaces = Arrays.asList(registry.getURIs());
        if (allNamespaces.contains(namespaceUri)) {
            return registry.getPrefix(namespaceUri);
        }
        List<String> allPrefixes = Arrays.asList(registry.getPrefixes());
        if (!allPrefixes.contains(defaultPrefix)) {
            registry.registerNamespace(defaultPrefix, namespaceUri);
            return defaultPrefix;
        }
        String generatedPrefix = this.generateNamespacePrefix(registry);
        registry.registerNamespace(generatedPrefix, namespaceUri);
        return generatedPrefix;
    }

    public void resolveReferences() throws RepositoryException {
        if (this.resolveFutures.isEmpty()) {
            return;
        }
        List<ResolveFuture> futures = this.resolveFutures;
        this.resolveFutures = new LinkedList<ResolveFuture>();
        for (ResolveFuture future : futures) {
            future.resolve();
        }
    }

    protected String setReference(Node node, String propertyName, SymbolSpace kind, String namespace, String name) throws RepositoryException {
        String typeIdentifier = this.resolvers.get(kind).lookupIdentifier(namespace, name);
        if (typeIdentifier != null) {
            node.setProperty(propertyName, typeIdentifier);
        } else {
            this.resolveFutures.add(new ResolveFuture(node, propertyName, kind, namespace, name));
        }
        return typeIdentifier;
    }

    private String generateNamespacePrefix(NamespaceRegistry registry) throws RepositoryException {
        String basePrefix;
        String prefix = basePrefix = "ns";
        int counter = 1;
        List<String> prefixes = Arrays.asList(registry.getPrefixes());
        while (prefixes.contains(prefix)) {
            prefix = basePrefix + counter;
            ++counter;
        }
        return prefix;
    }

    private class ResolveFuture {
        private final Node node;
        private final String propertyName;
        private final SymbolSpace refKind;
        private final String refNamespace;
        private final String refName;

        protected ResolveFuture(Node node, String propertyName, SymbolSpace kind, String namespace, String name) {
            this.node = node;
            this.propertyName = propertyName;
            this.refKind = kind;
            this.refNamespace = namespace;
            this.refName = name;
        }

        protected String resolve() throws RepositoryException {
            return AbstractResolvingReader.this.setReference(this.node, this.propertyName, this.refKind, this.refNamespace, this.refName);
        }
    }
}

