/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.modeshape.common.text.UrlEncoder;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.SecureHash;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrMixLexicon;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.property.BinaryFactory;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.teiid.ModelSequencer;
import org.modeshape.sequencer.teiid.ReferenceResolver;
import org.modeshape.sequencer.teiid.TeiidI18n;
import org.modeshape.sequencer.teiid.VdbManifest;
import org.modeshape.sequencer.teiid.VdbModel;
import org.modeshape.sequencer.teiid.lexicon.VdbLexicon;

public class VdbSequencer
implements StreamSequencer {
    private static final UrlEncoder URL_ENCODER = new UrlEncoder();
    private static final Pattern VERSION_REGEX = Pattern.compile("(.*)[.]\\s*[+-]?([0-9]+)\\s*$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
        BinaryFactory binaryFactory = context.getValueFactories().getBinaryFactory();
        DateTimeFactory dateFactory = context.getValueFactories().getDateFactory();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        NameFactory nameFactory = context.getValueFactories().getNameFactory();
        ValueFactory stringFactory = context.getValueFactories().getStringFactory();
        AtomicInteger version = new AtomicInteger(0);
        Path pathToArchiveFile = context.getInputPath();
        Name zipFileName = VdbLexicon.VIRTUAL_DATABASE;
        if (pathToArchiveFile != null && !pathToArchiveFile.isRoot()) {
            if (pathToArchiveFile.getLastSegment().getName().equals(JcrLexicon.CONTENT)) {
                pathToArchiveFile = pathToArchiveFile.getParent();
            }
            if (!pathToArchiveFile.isRoot()) {
                zipFileName = pathToArchiveFile.getLastSegment().getName();
                String fileNameWithoutExtension = zipFileName.getLocalName().replaceAll("\\.vdb$", "");
                zipFileName = context.getValueFactories().getNameFactory().create(zipFileName.getNamespaceUri(), fileNameWithoutExtension);
                String name = (String)stringFactory.create(zipFileName);
                zipFileName = VdbSequencer.extractVersionInfomation((ExecutionContext)context, name, version);
            }
        }
        assert (zipFileName != null);
        File vdbArchiveFile = null;
        try {
            String prefix = "modeshape" + URL_ENCODER.encode((String)stringFactory.create(zipFileName));
            vdbArchiveFile = File.createTempFile(prefix, "vdb");
            BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(vdbArchiveFile));
            SecureHash.HashingInputStream hashingStream = SecureHash.createHashingStream((SecureHash.Algorithm)SecureHash.Algorithm.SHA_1, (InputStream)stream);
            IoUtil.write((InputStream)hashingStream, (OutputStream)ostream);
            String sha1 = hashingStream.getHashAsHexString();
            ZipFile vdbArchive = new ZipFile(vdbArchiveFile);
            ZipEntry vdbXml = vdbArchive.getEntry("META-INF/vdb.xml");
            if (vdbXml == null) {
                return;
            }
            VdbManifest manifest = VdbManifest.read(vdbArchive.getInputStream(vdbXml), (ExecutionContext)context);
            if (version.get() != 0) {
                manifest.setVersion(version.get());
            }
            NamespaceRegistry registry = context.getNamespaceRegistry();
            this.registerIfMissing(registry, "vdb", "http://www.metamatrix.com/metamodels/VirtualDatabase");
            this.registerIfMissing(registry, "xmi", "http://www.omg.org/XMI");
            this.registerIfMissing(registry, "mmcore", "http://www.metamatrix.com/metamodels/Core");
            Path vdbPath = pathFactory.createRelativePath(new Name[]{zipFileName});
            output.setProperty(vdbPath, JcrLexicon.PRIMARY_TYPE, new Object[]{VdbLexicon.VIRTUAL_DATABASE});
            output.setProperty(vdbPath, JcrLexicon.MIXIN_TYPES, new Object[]{JcrMixLexicon.REFERENCEABLE});
            output.setProperty(vdbPath, JcrLexicon.UUID, new Object[]{UUID.randomUUID()});
            output.setProperty(vdbPath, VdbLexicon.DESCRIPTION, new Object[]{manifest.getDescription()});
            output.setProperty(vdbPath, VdbLexicon.VERSION, new Object[]{(long)manifest.getVersion()});
            output.setProperty(vdbPath, VdbLexicon.PREVIEW, new Object[]{manifest.isPreview()});
            output.setProperty(vdbPath, VdbLexicon.ORIGINAL_FILE, new Object[]{pathToArchiveFile});
            output.setProperty(vdbPath, ModeShapeLexicon.SHA1, new Object[]{sha1});
            ReferenceResolver resolver = new ReferenceResolver((ExecutionContext)context);
            for (VdbModel model : manifest.modelsInDependencyOrder()) {
                if (!model.getType().equalsIgnoreCase("PHYSICAL") && !model.getType().equalsIgnoreCase("VIRTUAL")) continue;
                ModelSequencer sequencer = new ModelSequencer(model, vdbPath, resolver);
                sequencer.setUseXmiUuidsAsJcrUuids(false);
                ZipEntry modelEntry = vdbArchive.getEntry(model.getPathInVdb());
                if (modelEntry == null) {
                    modelEntry = vdbArchive.getEntry("/" + model.getPathInVdb());
                }
                if (modelEntry == null) continue;
                String pathInVdb = model.getPathInVdb();
                sequencer.sequence(vdbArchive.getInputStream(modelEntry), output, context);
            }
        }
        catch (Exception e) {
            String location = (String)context.getValueFactories().getStringFactory().create(context.getInputPath());
            context.getProblems().addError((Throwable)e, TeiidI18n.errorReadingVdbFile, new Object[]{location, e.getMessage()});
        }
        finally {
            if (vdbArchiveFile != null) {
                vdbArchiveFile.delete();
            }
        }
    }

    protected void registerIfMissing(NamespaceRegistry registry, String prefix, String url) {
        if (!registry.isRegisteredNamespaceUri(url)) {
            registry.register(prefix, url);
        }
    }

    protected static Name extractVersionInfomation(ExecutionContext context, String fileNameWithoutExtension, AtomicInteger version) {
        Matcher matcher = VERSION_REGEX.matcher(fileNameWithoutExtension);
        if (matcher.matches()) {
            fileNameWithoutExtension = matcher.group(1);
            version.set(((Long)context.getValueFactories().getLongFactory().create(matcher.group(2))).intValue());
        }
        fileNameWithoutExtension = fileNameWithoutExtension.replaceAll("[.]*$", "");
        return (Name)context.getValueFactories().getNameFactory().create(fileNameWithoutExtension);
    }
}

