/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.basic.LocalNamespaceRegistry;
import org.modeshape.sequencer.teiid.VdbModel;
import org.xml.sax.SAXException;

public class VdbManifest {
    private String name = "";
    private String description = "";
    private boolean preview = false;
    private int version = 1;
    private final List<VdbModel> models = new ArrayList<VdbModel>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name != null ? name : "";
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description != null ? description : "";
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public List<VdbModel> getModels() {
        return this.models;
    }

    public String toString() {
        return this.name + " v" + this.version + " (\"" + this.description + "\")";
    }

    public Iterable<VdbModel> modelsInDependencyOrder() {
        if (!this.models.isEmpty()) {
            Collections.sort(this.models);
        }
        return this.models;
    }

    public static VdbManifest read(InputStream stream, ExecutionContext context) throws IOException, SAXException {
        return new Reader(context).read(stream);
    }

    protected static class Reader {
        private final ExecutionContext context;
        private final ValueFactory<String> stringFactory;

        protected Reader(ExecutionContext context) {
            NamespaceRegistry registry = context.getNamespaceRegistry();
            LocalNamespaceRegistry localRegistry = new LocalNamespaceRegistry(registry);
            this.context = context.with((NamespaceRegistry)localRegistry);
            this.stringFactory = context.getValueFactories().getStringFactory();
        }

        public VdbManifest read(InputStream stream) throws IOException, SAXException {
            VdbManifest manifest = new VdbManifest();
            Graph graph = Graph.create((ExecutionContext)this.context);
            boolean error = false;
            try {
                graph.importXmlFrom(stream).into("/");
                Subgraph subgraph = (Subgraph)graph.getSubgraphOfDepth(100).at("/vdb");
                SubgraphNode vdb = subgraph.getRoot();
                manifest.setName(this.firstValue((Node)vdb, "name"));
                manifest.setDescription(this.firstValue((Node)vdb, "description"));
                manifest.setVersion((int)this.firstValue((Node)vdb, "version", 1L));
                for (Location childLocation : vdb) {
                    SubgraphNode model = (SubgraphNode)subgraph.getNode(childLocation);
                    String name = this.nameOf(childLocation);
                    if ("property".equals(name)) {
                        String propertyName = this.firstValue((Node)model, "name");
                        if (!"preview".equals(propertyName)) continue;
                        manifest.setPreview(this.firstValue((Node)model, "value", false));
                        continue;
                    }
                    if (!"model".equals(name)) continue;
                    String modelName = this.firstValue((Node)model, "name");
                    String modelType = this.firstValue((Node)model, "type");
                    String modelPath = this.firstValue((Node)model, "path");
                    modelPath = modelPath.replaceFirst("^/", "");
                    VdbModel vdbModel = new VdbModel(modelName, modelType, modelPath);
                    vdbModel.setBuiltIn(this.firstValue((Node)model, "builtIn", false));
                    vdbModel.setVisible(this.firstValue((Node)model, "visible", true));
                    vdbModel.setBuiltIn(this.property(model, "builtIn", vdbModel.isBuiltIn()));
                    vdbModel.setChecksum(this.property(model, "checksum", 0L));
                    vdbModel.getImports().addAll(this.properties(model, "imports"));
                    SubgraphNode source = model.getNode("source");
                    if (source != null) {
                        vdbModel.setSourceName(this.firstValue((Node)source, "name"));
                        vdbModel.setSourceTranslator(this.firstValue((Node)source, "translator-name"));
                        vdbModel.setSourceJndiName(this.firstValue((Node)source, "connection-jndi-name"));
                    }
                    for (Location errorLocation : model) {
                        SubgraphNode marker = model.getNode(errorLocation.getPath().getLastSegment());
                        String path = this.firstValue((Node)marker, "path");
                        String severity = this.firstValue((Node)marker, "severity");
                        String message = this.firstValue((Node)marker, JcrLexicon.XMLCHARACTERS, "");
                        vdbModel.addProblem(severity, path, message);
                    }
                    manifest.getModels().add(vdbModel);
                }
            }
            catch (IOException e) {
                error = true;
                throw e;
            }
            catch (RuntimeException e) {
                error = true;
                throw e;
            }
            finally {
                block16: {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException e) {
                        if (error) break block16;
                        throw e;
                    }
                }
            }
            return manifest;
        }

        protected String property(SubgraphNode node, String propertyName) {
            for (Location childLocation : node) {
                SubgraphNode child = node.getNode(childLocation.getPath().getLastSegment());
                String name = this.nameOf(childLocation);
                if (!"property".equals(name) || !propertyName.equals(this.firstValue((Node)child, "name"))) continue;
                return this.firstValue((Node)child, "value");
            }
            return null;
        }

        protected List<String> properties(SubgraphNode node, String propertyName) {
            ArrayList<String> values = new ArrayList<String>();
            for (Location childLocation : node) {
                SubgraphNode child = node.getNode(childLocation.getPath().getLastSegment());
                String name = this.nameOf(childLocation);
                if (!"property".equals(name) || !propertyName.equals(this.firstValue((Node)child, "name"))) continue;
                String value = this.firstValue((Node)child, "value");
                values.add(value);
            }
            return values;
        }

        protected long property(SubgraphNode node, String propertyName, long defaultValue) {
            for (Location childLocation : node) {
                SubgraphNode child = node.getNode(childLocation.getPath().getLastSegment());
                String name = this.nameOf(childLocation);
                if (!"property".equals(name) || !propertyName.equals(this.firstValue((Node)child, "name"))) continue;
                return this.firstValue((Node)child, "value", defaultValue);
            }
            return defaultValue;
        }

        protected boolean property(SubgraphNode node, String propertyName, boolean defaultValue) {
            for (Location childLocation : node) {
                SubgraphNode child = node.getNode(childLocation.getPath().getLastSegment());
                String name = this.nameOf(childLocation);
                if (!"property".equals(name) || !propertyName.equals(this.firstValue((Node)child, "name"))) continue;
                return this.firstValue((Node)child, "value", defaultValue);
            }
            return defaultValue;
        }

        protected String firstValue(Node node, String propertyName) {
            return this.firstValue(node, propertyName, null);
        }

        protected String firstValue(Node node, String propertyName, String defaultValue) {
            Property property = node.getProperty(propertyName);
            if (property == null || property.isEmpty()) {
                return defaultValue;
            }
            return (String)this.stringFactory.create(property.getFirstValue());
        }

        protected String firstValue(Node node, Name propertyName, String defaultValue) {
            Property property = node.getProperty(propertyName);
            if (property == null || property.isEmpty()) {
                return defaultValue;
            }
            return (String)this.stringFactory.create(property.getFirstValue());
        }

        protected boolean firstValue(Node node, String propertyName, boolean defaultValue) {
            Property property = node.getProperty(propertyName);
            if (property == null || property.isEmpty()) {
                return defaultValue;
            }
            return (Boolean)this.context.getValueFactories().getBooleanFactory().create(property.getFirstValue());
        }

        protected long firstValue(Node node, String propertyName, long defaultValue) {
            Property property = node.getProperty(propertyName);
            if (property == null || property.isEmpty()) {
                return defaultValue;
            }
            return (Long)this.context.getValueFactories().getLongFactory().create(property.getFirstValue());
        }

        protected String nameOf(Location location) {
            Path path = location.getPath();
            if (path.isRoot()) {
                return "";
            }
            return path.getLastSegment().getName().getLocalName();
        }
    }
}

