/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.collection.ArrayListMultimap;
import org.modeshape.common.collection.Multimap;
import org.modeshape.common.text.Jsr283Encoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrMixLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.sequencer.teiid.DefaultProperties;
import org.modeshape.sequencer.teiid.ReferenceResolver;
import org.modeshape.sequencer.teiid.VdbModel;
import org.modeshape.sequencer.teiid.XmiGraphReader;
import org.modeshape.sequencer.teiid.lexicon.CoreLexicon;
import org.modeshape.sequencer.teiid.lexicon.JdbcLexicon;
import org.modeshape.sequencer.teiid.lexicon.TransformLexicon;
import org.modeshape.sequencer.teiid.lexicon.VdbLexicon;
import org.modeshape.sequencer.teiid.lexicon.XmiLexicon;
import org.modeshape.sequencer.teiid.lexicon.XsiLexicon;

@NotThreadSafe
public class XmiModelReader
extends XmiGraphReader {
    protected static final TextEncoder ENCODER = new Jsr283Encoder();
    private final Path modelRootPath;
    private final String originalFile;
    private final Map<Name, ModelObjectHandler> handlers = new HashMap<Name, ModelObjectHandler>();
    private ModelObjectHandler defaultHandler;
    private final Map<UUID, PropertySet> mmuuidToPropertySet = new HashMap<UUID, PropertySet>();
    protected final boolean useXmiUuidsAsJcrUuids;
    protected final DefaultProperties defaults;
    protected ReferenceResolver resolver;
    private VdbModel vdbModel;
    private String sha1;

    public XmiModelReader(Path parentPath, Name modelName, String pathToModelFile, Subgraph subgraph, boolean generateShortTypeNames, boolean useXmiUuidsAsJcrUuids, VdbModel vdbModel) {
        super(subgraph, generateShortTypeNames);
        try {
            this.defaults = DefaultProperties.getDefaults();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.originalFile = pathToModelFile;
        this.modelRootPath = parentPath != null ? this.pathFactory.create(parentPath, new Name[]{modelName}) : this.pathFactory.createRelativePath(new Name[]{modelName});
        this.useXmiUuidsAsJcrUuids = useXmiUuidsAsJcrUuids;
        this.vdbModel = vdbModel;
        this.setResolver(null);
        this.prepare();
    }

    protected void prepare() {
        this.namespaces.register("diagram", "http://www.metamatrix.com/metamodels/Diagram");
        this.namespaces.register("transform", "http://www.metamatrix.com/metamodels/Transformation");
        this.namespaces.register("jdbcs", "http://www.metamatrix.com/metamodels/JDBC");
        this.namespaces.register("relational", "http://www.metamatrix.com/metamodels/Relational");
        this.namespaces.register("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.replaceTypeName("relational:importSetting", "jdbcs:imported");
        this.replaceTypeName("relational:result", "relational:procedureResult");
        this.replaceTypeName("relational:parameter", "relational:procedureParameter");
        this.replaceTypeName("jdbcs:jdbcSource", "jdbcs:source");
    }

    protected void registerHandler(String name, ModelObjectHandler handler) {
        this.registerHandler((Name)this.nameFactory.create(name), handler);
    }

    protected void registerHandler(Name name, ModelObjectHandler handler) {
        this.handlers.put(name, handler);
    }

    protected void registerDefaultHandler(ModelObjectHandler handler) {
        this.defaultHandler = handler;
    }

    protected void clearHandlers() {
        this.handlers.clear();
    }

    public void setResolver(ReferenceResolver resolver) {
        this.resolver = resolver != null ? resolver : new ReferenceResolver(this.subgraph.getGraph().getContext());
    }

    public void setSha1Hash(String sha1) {
        this.sha1 = sha1;
    }

    protected PropertySet propertiesFor(UUID mmuuid, boolean createIfMissing) {
        PropertySet result = this.mmuuidToPropertySet.get(mmuuid);
        if (result == null && createIfMissing) {
            result = new PropertySet(this);
            this.mmuuidToPropertySet.put(mmuuid, result);
        }
        return result;
    }

    @Override
    protected UUID uuidFor(Node node) {
        return this.useXmiUuidsAsJcrUuids ? this.xmiUuidFor(node) : super.uuidFor(node);
    }

    public boolean isAcceptedPrimaryMetamodel(String uri) {
        return "http://www.metamatrix.com/metamodels/Relational".equals(uri);
    }

    public boolean write(SequencerOutput output) {
        if (!this.writePhase0(output)) {
            return false;
        }
        if (!this.writePhase1(output)) {
            return false;
        }
        if (!this.writePhase2(output)) {
            return false;
        }
        return this.writePhase3(output);
    }

    public boolean writePhase0(SequencerOutput output) {
        this.clearHandlers();
        this.registerDefaultHandler(new SkipBranchHandler());
        this.registerHandler("annotations", (ModelObjectHandler)new AnnotationHandler());
        this.registerHandler("transformationMappings", (ModelObjectHandler)new TransformationHandler());
        for (SubgraphNode node : this.subgraph) {
            UUID mmUuid = this.xmiUuidFor((Node)node);
            UUID nodeUuid = this.uuidFor((Node)node);
            this.resolver.recordXmiUuidToJcrUuid(mmUuid, nodeUuid);
        }
        return true;
    }

    public boolean writePhase1(SequencerOutput output) {
        Name primaryType;
        SubgraphNode transformationContainer;
        SubgraphNode annotationContainer;
        SubgraphNode xmi = this.subgraph.getRoot();
        SubgraphNode modelAnnotation = xmi.getNode("mmcore:ModelAnnotation");
        if (modelAnnotation != null) {
            String primaryMetamodelUri = this.firstValue((Node)modelAnnotation, "primaryMetamodelUri");
            if (!this.isAcceptedPrimaryMetamodel(primaryMetamodelUri)) {
                return false;
            }
            this.setCurrentNamespaceUri(primaryMetamodelUri);
        }
        if ((annotationContainer = xmi.getNode("mmcore:AnnotationContainer")) != null) {
            for (Location objectLocation : annotationContainer.getChildren()) {
                SubgraphNode modelObject = (SubgraphNode)this.subgraph.getNode(objectLocation);
                this.processObject(this.modelRootPath, modelObject, output);
            }
        }
        if ((transformationContainer = xmi.getNode("transform:TransformationContainer")) != null) {
            for (Location objectLocation : transformationContainer.getChildren()) {
                SubgraphNode modelObject = (SubgraphNode)this.subgraph.getNode(objectLocation);
                this.processObject(this.modelRootPath, modelObject, output);
            }
        }
        Name name = primaryType = this.vdbModel != null ? VdbLexicon.MODEL : XmiLexicon.MODEL;
        if (modelAnnotation != null) {
            UUID xmiUuid = this.xmiUuidFor((Node)modelAnnotation);
            this.resolver.recordXmiUuid(xmiUuid, this.modelRootPath);
            PropertySet props = this.propertiesFor(xmiUuid, true);
            props.add(JcrLexicon.PRIMARY_TYPE, (Object)primaryType);
            props.add(JcrLexicon.MIXIN_TYPES, CoreLexicon.MODEL, JcrMixLexicon.REFERENCEABLE, XmiLexicon.REFERENCEABLE);
            props.add(XmiLexicon.VERSION, (Object)this.firstValue((Node)xmi, "xmi:version", 2.0));
            props.add(CoreLexicon.PRIMARY_METAMODEL_URI, (Object)this.getCurrentNamespaceUri());
            props.add(CoreLexicon.MODEL_TYPE, (Object)this.firstValue((Node)modelAnnotation, "modelType"));
            props.add(CoreLexicon.PRODUCER_NAME, (Object)this.firstValue((Node)modelAnnotation, "ProducerName"));
            props.add(CoreLexicon.PRODUCER_VERSION, (Object)this.firstValue((Node)modelAnnotation, "ProducerVersion"));
            props.writeTo(output, this.modelRootPath);
            output.setProperty(this.modelRootPath, JcrLexicon.UUID, new Object[]{this.uuidFor((Node)modelAnnotation)});
            output.setProperty(this.modelRootPath, XmiLexicon.UUID, new Object[]{xmiUuid});
        } else {
            output.setProperty(this.modelRootPath, JcrLexicon.PRIMARY_TYPE, new Object[]{primaryType});
            output.setProperty(this.modelRootPath, JcrLexicon.MIXIN_TYPES, new Object[]{CoreLexicon.MODEL, JcrMixLexicon.REFERENCEABLE, XmiLexicon.REFERENCEABLE});
            output.setProperty(this.modelRootPath, XmiLexicon.VERSION, new Object[]{this.firstValue((Node)xmi, "xmi:version", 2.0)});
        }
        if (this.originalFile != null) {
            output.setProperty(this.modelRootPath, CoreLexicon.ORIGINAL_FILE, new Object[]{this.originalFile});
        }
        if (this.sha1 != null) {
            output.setProperty(this.modelRootPath, ModeShapeLexicon.SHA1, new Object[]{this.sha1});
        }
        if (this.vdbModel != null) {
            output.setProperty(this.modelRootPath, VdbLexicon.VISIBLE, new Object[]{this.vdbModel.isVisible()});
            output.setProperty(this.modelRootPath, VdbLexicon.CHECKSUM, new Object[]{this.vdbModel.getChecksum()});
            output.setProperty(this.modelRootPath, VdbLexicon.BUILT_IN, new Object[]{this.vdbModel.isBuiltIn()});
            output.setProperty(this.modelRootPath, VdbLexicon.PATH_IN_VDB, new Object[]{this.vdbModel.getPathInVdb()});
            String translator = this.vdbModel.getSourceTranslator();
            String sourceName = this.vdbModel.getSourceName();
            String jndiName = this.vdbModel.getSourceJndiName();
            if (translator != null) {
                output.setProperty(this.modelRootPath, VdbLexicon.SOURCE_TRANSLATOR, new Object[]{translator});
            }
            if (sourceName != null) {
                output.setProperty(this.modelRootPath, VdbLexicon.SOURCE_NAME, new Object[]{sourceName});
            }
            if (jndiName != null) {
                output.setProperty(this.modelRootPath, VdbLexicon.SOURCE_JNDI_NAME, new Object[]{jndiName});
            }
            if (!this.vdbModel.getProblems().isEmpty()) {
                Path markersPath = this.path(this.modelRootPath, VdbLexicon.MARKERS);
                output.setProperty(markersPath, JcrLexicon.PRIMARY_TYPE, new Object[]{VdbLexicon.MARKERS});
                for (VdbModel.ValidationMarker marker : this.vdbModel.getProblems()) {
                    Path markerPath = this.path(markersPath, VdbLexicon.MARKER);
                    output.setProperty(markerPath, JcrLexicon.PRIMARY_TYPE, new Object[]{VdbLexicon.MARKER});
                    output.setProperty(markerPath, VdbLexicon.SEVERITY, new Object[]{marker.getSeverity().name()});
                    output.setProperty(markerPath, VdbLexicon.PATH, new Object[]{marker.getPath()});
                    output.setProperty(markerPath, VdbLexicon.MESSAGE, new Object[]{marker.getMessage()});
                }
            }
        }
        if (modelAnnotation != null) {
            this.registerHandler("modelImports", (ModelObjectHandler)new ModelImportHandler());
            for (Location modelImportLocation : modelAnnotation.getChildren()) {
                SubgraphNode modelImport = (SubgraphNode)this.subgraph.getNode(modelImportLocation);
                this.processObject(this.modelRootPath, modelImport, output);
            }
        }
        return true;
    }

    public boolean writePhase2(SequencerOutput output) {
        this.clearHandlers();
        this.registerDefaultHandler(new DefaultModelObjectHandler(new Name[0]));
        this.registerHandler("mmcore:ModelAnnotation", (ModelObjectHandler)new SkipBranchHandler());
        this.registerHandler("mmcore:AnnotationContainer", (ModelObjectHandler)new SkipBranchHandler());
        this.registerHandler("transform:TransformationContainer", (ModelObjectHandler)new SkipBranchHandler());
        this.registerHandler("diagram:DiagramContainer", (ModelObjectHandler)new SkipBranchHandler());
        this.registerHandler("importSettings", (ModelObjectHandler)new DefaultModelObjectHandler(JdbcLexicon.IMPORTED));
        SubgraphNode xmi = this.subgraph.getRoot();
        for (Location objectLocation : xmi.getChildren()) {
            SubgraphNode modelObject = (SubgraphNode)this.subgraph.getNode(objectLocation);
            this.processObject(this.modelRootPath, modelObject, output);
        }
        return true;
    }

    public boolean writePhase3(SequencerOutput output) {
        for (Map.Entry entry : this.resolver.getUnresolved().asMap().entrySet()) {
            Path propPath = (Path)entry.getKey();
            Collection mmuuids = (Collection)entry.getValue();
            Path path = propPath.getParent();
            Name propName = propPath.getLastSegment().getName();
            Object[] names = new String[mmuuids.size()];
            int i = 0;
            for (UUID mmuuid : mmuuids) {
                ReferenceResolver.ResolvedReference ref = this.resolver.resolve(null, null, null, mmuuid);
                if (ref.getName() == null) {
                    names = null;
                    break;
                }
                names[i++] = ref.getName();
            }
            if (names == null || this.useXmiUuidsAsJcrUuids) continue;
            Name refNameName = this.nameForResolvedName(propName);
            output.setProperty(path, refNameName, names);
        }
        return true;
    }

    protected Name nameFromKey(String keyName) {
        int index = keyName.indexOf(58);
        if (index != -1) {
            String prefix = keyName.substring(0, index);
            if (this.namespaces.getNamespaceForPrefix(prefix) != null) {
                return (Name)this.nameFactory.create(keyName);
            }
            keyName = ENCODER.encode(prefix);
        }
        return (Name)this.nameFactory.create(keyName);
    }

    protected Path processObject(Path parentPath, SubgraphNode node, SequencerOutput output) {
        Location location = node.getLocation();
        Path path = this.path(parentPath, location.getPath().getLastSegment());
        ModelObjectHandler handler = this.findHandler((Node)node);
        Path actualPath = handler.process(path, node, this.subgraph, this, output);
        if (actualPath != null) {
            if (!(handler instanceof SkipNodeHandler)) {
                UUID mmuuid = this.xmiUuidFor((Node)node);
                PropertySet props = this.propertiesFor(mmuuid, false);
                if (props != null) {
                    props.writeTo(output, actualPath);
                }
                UUID xmiUuid = this.xmiUuidFor((Node)node);
                this.resolver.recordXmiUuid(xmiUuid, actualPath);
            }
            for (Location childLocation : node.getChildren()) {
                SubgraphNode childObject = (SubgraphNode)this.subgraph.getNode(childLocation);
                if (childObject == null) continue;
                this.processObject(actualPath, childObject, output);
            }
        }
        return actualPath;
    }

    protected ModelObjectHandler findHandler(Node node) {
        String primaryTypeStr = this.firstValue(node, JcrLexicon.PRIMARY_TYPE);
        Name primaryType = (Name)this.nameFactory.create(primaryTypeStr);
        ModelObjectHandler handler = this.handlers.get(primaryType);
        if (handler == null && primaryTypeStr.indexOf(58) == -1 && (handler = this.handlers.get(primaryType = this.nameFactory.create(this.currentNamespaceUri, primaryTypeStr))) == null) {
            primaryType = this.nameFactory.create("http://www.metamatrix.com/metamodels/Core", primaryTypeStr);
            handler = this.handlers.get(primaryType);
        }
        if (handler == null) {
            Location objectLocation = node.getLocation();
            Name name = objectLocation.getPath().getLastSegment().getName();
            handler = this.handlers.get(name);
        }
        if (handler == null) {
            handler = this.defaultHandler;
        }
        return handler;
    }

    protected PropertySet createPropertySet() {
        return new PropertySet(this);
    }

    public static class SkipBranchHandler
    implements ModelObjectHandler {
        @Override
        public Path process(Path path, SubgraphNode node, Subgraph subgraph, XmiModelReader reader, SequencerOutput output) {
            return null;
        }
    }

    public static class SkipNodeHandler
    implements ModelObjectHandler {
        @Override
        public Path process(Path path, SubgraphNode node, Subgraph subgraph, XmiModelReader reader, SequencerOutput output) {
            return path;
        }
    }

    public static class TransformationHandler
    implements ModelObjectHandler {
        @Override
        public Path process(Path path, SubgraphNode transformation, Subgraph subgraph, XmiModelReader reader, SequencerOutput output) {
            String hrefToTransformedObject = reader.firstValue((Node)transformation, "target");
            if (hrefToTransformedObject != null) {
                UUID mmuuid = reader.resolver.resolveInternalReference(hrefToTransformedObject);
                PropertySet props = reader.propertiesFor(mmuuid, true);
                props.add(JcrLexicon.MIXIN_TYPES, (Object)TransformLexicon.WITH_SQL);
                Path helperNestedNodePath = reader.path(transformation.getLocation().getPath(), "helper/nested");
                SubgraphNode helperNested = (SubgraphNode)subgraph.getNode(helperNestedNodePath);
                if (helperNested != null) {
                    props.add(TransformLexicon.SELECT_SQL, (Object)reader.firstValue((Node)helperNested, "selectSql"));
                    props.add(TransformLexicon.INSERT_SQL, (Object)reader.firstValue((Node)helperNested, "insertSql"));
                    props.add(TransformLexicon.UPDATE_SQL, (Object)reader.firstValue((Node)helperNested, "updateSql"));
                    props.add(TransformLexicon.DELETE_SQL, (Object)reader.firstValue((Node)helperNested, "deleteSql"));
                    props.add(TransformLexicon.INSERT_ALLOWED, (Object)reader.firstValue((Node)helperNested, "insertAllowed", true));
                    props.add(TransformLexicon.UPDATE_ALLOWED, (Object)reader.firstValue((Node)helperNested, "updateAllowed", true));
                    props.add(TransformLexicon.DELETE_ALLOWED, (Object)reader.firstValue((Node)helperNested, "deleteAllowed", true));
                    props.add(TransformLexicon.INSERT_SQL_DEFAULT, (Object)reader.firstValue((Node)helperNested, "insertSqlDefault", true));
                    props.add(TransformLexicon.UPDATE_SQL_DEFAULT, (Object)reader.firstValue((Node)helperNested, "updateSqlDefault", true));
                    props.add(TransformLexicon.DELETE_SQL_DEFAULT, (Object)reader.firstValue((Node)helperNested, "deleteSqlDefault", true));
                }
                for (Location childLocation : transformation.getChildren()) {
                    Name childName = childLocation.getPath().getLastSegment().getName();
                    SubgraphNode child = (SubgraphNode)subgraph.getNode(childLocation);
                    if (childName.getLocalName().equals("inputs")) {
                        String inputHref = reader.firstValue((Node)child, "href");
                        if (inputHref == null) continue;
                        Name name = TransformLexicon.INPUTS;
                        props.addRef(name, inputHref);
                        continue;
                    }
                    if (!childName.getLocalName().equals("nested")) continue;
                    String outputHref = reader.firstValue((Node)child, "outputs");
                    UUID nestedMmuuid = reader.resolver.resolveInternalReference(outputHref);
                    PropertySet nestedProps = reader.propertiesFor(nestedMmuuid, true);
                    for (Location inputLocation : child.getChildren()) {
                        SubgraphNode inputNode = (SubgraphNode)subgraph.getNode(inputLocation);
                        String inputHref = reader.firstValue((Node)inputNode, "href");
                        if (inputHref == null) continue;
                        Name name = TransformLexicon.INPUTS;
                        nestedProps.addRef(name, inputHref);
                        nestedProps.add(JcrLexicon.MIXIN_TYPES, (Object)TransformLexicon.TRANSFORMED);
                    }
                }
            }
            return null;
        }
    }

    public static class AnnotationHandler
    implements ModelObjectHandler {
        @Override
        public Path process(Path path, SubgraphNode annotation, Subgraph subgraph, XmiModelReader reader, SequencerOutput output) {
            List<UUID> mmuuids = reader.references(annotation.getProperty("annotatedObject"));
            if (mmuuids != null) {
                for (UUID mmuuid : mmuuids) {
                    PropertySet props = reader.propertiesFor(mmuuid, true);
                    props.add(CoreLexicon.DESCRIPTION, (Object)reader.firstValue((Node)annotation, "description"));
                    props.add(JcrLexicon.MIXIN_TYPES, (Object)CoreLexicon.ANNOTATED);
                    for (Location tagLocation : annotation.getChildren()) {
                        Name childName = tagLocation.getPath().getLastSegment().getName();
                        if (!childName.getLocalName().equals("tags")) continue;
                        SubgraphNode tag = (SubgraphNode)subgraph.getNode(tagLocation);
                        String key = reader.firstValue((Node)tag, "key");
                        String value = reader.firstValue((Node)tag, "value");
                        props.addTag(key, value);
                    }
                }
            }
            return null;
        }
    }

    public static class ModelImportHandler
    implements ModelObjectHandler {
        @Override
        public Path process(Path path, SubgraphNode node, Subgraph subgraph, XmiModelReader reader, SequencerOutput output) {
            String primaryMetamodelUri = reader.firstValue((Node)node, "primaryMetamodelUri");
            output.setProperty(path, JcrLexicon.PRIMARY_TYPE, new Object[]{CoreLexicon.IMPORT});
            output.setProperty(path, CoreLexicon.PRIMARY_METAMODEL_URI, new Object[]{primaryMetamodelUri});
            output.setProperty(path, CoreLexicon.MODEL_TYPE, new Object[]{reader.firstValue((Node)node, "modelType")});
            output.setProperty(path, CoreLexicon.PATH, new Object[]{reader.firstValue((Node)node, "path")});
            output.setProperty(path, JcrLexicon.UUID, new Object[]{reader.uuidFor((Node)node)});
            output.setProperty(path, XmiLexicon.UUID, new Object[]{reader.firstValue((Node)node, "xmi:uuid")});
            output.setProperty(path, JcrLexicon.MIXIN_TYPES, new Object[]{JcrMixLexicon.REFERENCEABLE, XmiLexicon.REFERENCEABLE});
            return path;
        }
    }

    public static class DefaultModelObjectHandler
    implements ModelObjectHandler {
        private final Set<Name> mixinTypeNames = new HashSet<Name>();

        public DefaultModelObjectHandler(Name ... requiredMixinTypeNames) {
            for (Name name : requiredMixinTypeNames) {
                this.mixinTypeNames.add(name);
            }
        }

        @Override
        public Path process(Path path, SubgraphNode node, Subgraph subgraph, XmiModelReader reader, SequencerOutput output) {
            Name mixinName;
            Name pt;
            if (node.getProperty("href") != null) {
                return null;
            }
            UUID mmuuid = reader.xmiUuidFor((Node)node);
            PropertySet propSet = mmuuid != null ? reader.propertiesFor(mmuuid, true) : reader.createPropertySet();
            Property primaryType = node.getProperty(JcrLexicon.PRIMARY_TYPE);
            Property mixinTypes = node.getProperty(JcrLexicon.MIXIN_TYPES);
            String xsiTypeValue = reader.firstValue((Node)node, "xsi:type");
            Name name = pt = xsiTypeValue != null ? reader.typeNameFrom(reader.nameFrom(xsiTypeValue)) : reader.typeNameFrom(reader.nameFrom(reader.stringFrom(primaryType.getFirstValue())));
            if (JcrNtLexicon.UNSTRUCTURED.equals(pt)) {
                if (mixinTypes != null) {
                    for (Object mixinTypeName : mixinTypes) {
                        mixinName = reader.nameFrom(reader.stringFrom(mixinTypeName));
                        propSet.add(JcrLexicon.MIXIN_TYPES, (Object)reader.typeNameFrom(mixinName));
                    }
                } else {
                    propSet.add(JcrLexicon.MIXIN_TYPES, (Object)reader.typeNameFrom(path.getLastSegment().getName()));
                }
            } else if (mixinTypes != null) {
                for (Object mixinTypeName : mixinTypes) {
                    mixinName = reader.nameFrom(reader.stringFrom(mixinTypeName));
                    propSet.add(JcrLexicon.MIXIN_TYPES, (Object)reader.typeNameFrom(mixinName));
                }
            }
            propSet.add(JcrLexicon.MIXIN_TYPES, (Object)JcrMixLexicon.REFERENCEABLE);
            if (node.getProperty(XmiLexicon.UUID) != null) {
                propSet.add(JcrLexicon.MIXIN_TYPES, (Object)XmiLexicon.REFERENCEABLE);
            }
            propSet.add(JcrLexicon.PRIMARY_TYPE, (Object)pt);
            for (Property property : node.getProperties()) {
                List<UUID> references;
                Name name2 = property.getName();
                if (name2.equals(JcrLexicon.PRIMARY_TYPE) || name2.equals(JcrLexicon.MIXIN_TYPES) || name2.equals(XsiLexicon.TYPE)) continue;
                if (name2.equals(ModeShapeLexicon.UUID) || name2.equals(JcrLexicon.UUID)) {
                    output.setProperty(path, JcrLexicon.UUID, new Object[]{reader.uuidFor((Node)node)});
                    continue;
                }
                if (name2.equals(XmiLexicon.UUID)) {
                    output.setProperty(path, name2, new Object[]{reader.xmiUuidFor((Node)node)});
                    continue;
                }
                if (name2.getNamespaceUri().isEmpty()) {
                    name2 = reader.nameFrom(name2.getLocalName());
                }
                if ((references = reader.references(property)) != null) {
                    for (UUID uuid : references) {
                        ReferenceResolver.ResolvedReference resolved = reader.resolver.resolve(path, name2, null, uuid);
                        propSet.addRef(name2, resolved);
                    }
                    propSet.writeTo(output, path);
                    continue;
                }
                output.setProperty(path, name2, property.getValuesAsArray());
            }
            for (Location childLocation : node.getChildren()) {
                SubgraphNode child = (SubgraphNode)subgraph.getNode(childLocation);
                if (child.getProperty("href") == null) continue;
                Name attributeName = reader.nameFrom(childLocation.getPath().getLastSegment().getName());
                String href = reader.firstValue((Node)child, "href");
                propSet.addRef(attributeName, href);
            }
            if (mmuuid == null) {
                propSet.writeTo(output, path);
            }
            return path;
        }

        protected Object[] filterMixinTypeNames(Iterable<Object> names) {
            HashSet<Name> result = new HashSet<Name>(this.mixinTypeNames);
            for (Object name : names) {
                result.add((Name)name);
            }
            return result.toArray(new Object[result.size()]);
        }
    }

    public static interface ModelObjectHandler {
        public Path process(Path var1, SubgraphNode var2, Subgraph var3, XmiModelReader var4, SequencerOutput var5);
    }

    public static class PropertySet {
        private final Multimap<Name, Object> refsByName = ArrayListMultimap.create();
        private final Multimap<Name, Object> propsByName = ArrayListMultimap.create();
        private final Map<String, String> tags = new HashMap<String, String>();
        private final XmiModelReader reader;

        protected PropertySet(XmiModelReader reader) {
            this.reader = reader;
        }

        public void addTag(String name, String value) {
            if (value != null) {
                this.tags.put(name, value);
            }
        }

        public void addRef(Name attributeName, ReferenceResolver.ResolvedReference resolved) {
            if (resolved != null) {
                this.refsByName.put((Object)attributeName, (Object)resolved);
            }
        }

        public void addRef(Name attributeName, String href) {
            if (href != null) {
                this.refsByName.put((Object)attributeName, (Object)href);
            }
        }

        public void add(Name attributeName, Object value) {
            if (value != null) {
                this.propsByName.put((Object)attributeName, value);
            }
        }

        public void add(Name attributeName, Object ... values) {
            if (values != null && values.length != 0) {
                for (Object value : values) {
                    this.propsByName.put((Object)attributeName, value);
                }
            }
        }

        private void addDefaultsForType(Collection<Object> nodeTypes) {
            if (nodeTypes == null || nodeTypes.isEmpty()) {
                return;
            }
            for (Object nodeType : nodeTypes) {
                String nodeTypeString = this.reader.stringFrom(nodeType);
                for (Map.Entry<String, Object> defaultValue : this.reader.defaults.getDefaultsFor(nodeTypeString).entrySet()) {
                    Name name = this.reader.nameFrom(defaultValue.getKey());
                    if (this.propsByName.containsKey((Object)name)) continue;
                    this.add(name, defaultValue.getValue());
                }
            }
        }

        public void writeTo(SequencerOutput output, Path path) {
            Collection values;
            String[] parts;
            String key;
            boolean tagProps = false;
            for (Map.Entry<String, String> tag : this.tags.entrySet()) {
                key = tag.getKey();
                parts = key.split(":", 2);
                if (parts.length >= 2) continue;
                Name tagName = this.reader.nameFrom(ENCODER.encode(key));
                this.add(tagName, (Object)tag.getValue());
                tagProps = true;
            }
            if (tagProps) {
                this.add(JcrLexicon.MIXIN_TYPES, (Object)CoreLexicon.TAGS);
            }
            this.addDefaultsForType(this.propsByName.get((Object)JcrLexicon.PRIMARY_TYPE));
            this.addDefaultsForType(this.propsByName.get((Object)JcrLexicon.MIXIN_TYPES));
            for (Name propName : this.propsByName.keySet()) {
                values = this.propsByName.get((Object)propName);
                Object[] valueArray = values.toArray(new Object[values.size()]);
                output.setProperty(path, propName, valueArray);
            }
            for (Name propName : this.refsByName.keySet()) {
                values = this.refsByName.get((Object)propName);
                for (Object value : values) {
                    Reference weakReference;
                    ReferenceResolver.ResolvedReference resolved = null;
                    if (value instanceof String) {
                        String href = (String)value;
                        resolved = this.reader.resolver.resolve(null, null, href);
                    } else if (value instanceof ReferenceResolver.ResolvedReference) {
                        resolved = (ReferenceResolver.ResolvedReference)value;
                    }
                    if (resolved == null) continue;
                    if (!this.reader.useXmiUuidsAsJcrUuids) {
                        String resolvedName;
                        if (resolved.getHref() != null) {
                            Name hrefName = this.reader.nameForHref(propName);
                            output.setProperty(path, hrefName, new Object[]{resolved.getHref()});
                        }
                        if (resolved.getId() != null) {
                            Name idName = this.reader.nameForResolvedId(propName);
                            output.setProperty(path, idName, new Object[]{resolved.getId()});
                        }
                        if ((resolvedName = resolved.getName()) != null) {
                            Name refNameName = this.reader.nameForResolvedName(propName);
                            output.setProperty(path, refNameName, new Object[]{resolvedName});
                        }
                    }
                    if ((weakReference = resolved.getWeakReferenceValue()) == null) continue;
                    Name refName = this.reader.nameForResolvedReference(propName);
                    output.setProperty(path, refName, new Object[]{weakReference});
                }
            }
            for (Map.Entry<String, String> tag : this.tags.entrySet()) {
                key = tag.getKey();
                parts = key.split(":", 2);
                if (parts.length < 2) continue;
                Name childName = (Name)this.reader.nameFactory.create(ENCODER.encode(parts[0]));
                Path childPath = this.reader.path(path, childName);
                output.setProperty(childPath, JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.UNSTRUCTURED});
                output.setProperty(childPath, JcrLexicon.MIXIN_TYPES, new Object[]{CoreLexicon.TAGS});
                Name tagName = (Name)this.reader.nameFactory.create(ENCODER.encode(parts[1]));
                String value = tag.getValue();
                output.setProperty(childPath, tagName, new Object[]{value});
            }
        }
    }
}

