/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.modeshape.common.collection.Collections;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.StringUtil;

public class DefaultProperties {
    private static final Map<String, Object> EMPTY = java.util.Collections.emptyMap();
    protected static Set<String> KEYWORDS = Collections.unmodifiableSet((Object[])new String[]{"mixin", "mix", "m", "orderable", "ord", "o", "abstract", "abs", "a", "query", "q", "nq", "noquery", "primaryItem"});
    protected static DefaultProperties instance;
    private final Map<String, Map<String, Object>> defaultValuesByType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void loadDefaultsFromCnd(String resourceName, Map<String, Map<String, Object>> defaultValuesByType) throws IOException {
        InputStream stream = DefaultProperties.class.getResourceAsStream(resourceName);
        try {
            String nodeTypeName = null;
            Map<String, Object> defaultValues = null;
            for (String line : StringUtil.splitLines((String)IoUtil.read((InputStream)stream))) {
                int defaultStart;
                if ((line = line.trim()).length() == 0) continue;
                if (line.charAt(0) == '[') {
                    int typeEnd = line.indexOf(93);
                    nodeTypeName = line.substring(1, typeEnd);
                    defaultValues = null;
                    int supertypesStart = line.indexOf(62, typeEnd);
                    if (supertypesStart == -1) continue;
                    List<String> supertypes = DefaultProperties.findSupertypes(line.substring(supertypesStart + 1));
                    for (String supertype : supertypes) {
                        Map<String, Object> supertypeDefaults = defaultValuesByType.get(supertype);
                        if (supertypeDefaults == null) continue;
                        defaultValues = new HashMap<String, Object>();
                        defaultValuesByType.put(nodeTypeName, defaultValues);
                        defaultValues.putAll(supertypeDefaults);
                    }
                    continue;
                }
                if (line.charAt(0) != '-' || (defaultStart = line.indexOf(61)) == -1) continue;
                defaultStart = line.indexOf(39, defaultStart) + 1;
                int defaultEnd = line.indexOf(39, defaultStart);
                String defaultValueLiteral = line.substring(defaultStart, defaultEnd);
                int typeStart = line.indexOf(40) + 1;
                int typeEnd = line.indexOf(41);
                String type = line.substring(typeStart, typeEnd);
                String name = line.substring(1, typeStart - 1).trim();
                Object defaultValue = defaultValueLiteral;
                if ("boolean".equalsIgnoreCase(type)) {
                    defaultValue = Boolean.parseBoolean(defaultValueLiteral);
                } else if ("long".equalsIgnoreCase(type)) {
                    defaultValue = Long.parseLong(defaultValueLiteral);
                } else if ("double".equalsIgnoreCase(type)) {
                    defaultValue = Double.parseDouble(defaultValueLiteral);
                }
                if (defaultValues == null && (defaultValues = defaultValuesByType.get(nodeTypeName)) == null) {
                    defaultValues = new HashMap();
                    defaultValuesByType.put(nodeTypeName, defaultValues);
                }
                defaultValues.put(name, defaultValue);
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    protected static List<String> findSupertypes(String nodeTypeDefnLine) {
        String[] words = nodeTypeDefnLine.split("[\\s?,]");
        ArrayList<String> supertypeNames = new ArrayList<String>();
        for (String word : words) {
            if ((word = word.trim()).length() == 0) continue;
            if (KEYWORDS.contains(word.toLowerCase())) break;
            supertypeNames.add(word);
        }
        return supertypeNames;
    }

    public static DefaultProperties getDefaults() throws IOException {
        if (instance == null) {
            HashMap<String, Map<String, Object>> defaultValues = new HashMap<String, Map<String, Object>>();
            DefaultProperties.loadDefaultsFromCnd("/org/modeshape/sequencer/teiid/teiid.cnd", defaultValues);
            instance = new DefaultProperties(defaultValues);
        }
        return instance;
    }

    private DefaultProperties(Map<String, Map<String, Object>> defaultValuesByType) {
        this.defaultValuesByType = defaultValuesByType;
    }

    public Object getDefaultFor(String nodeTypeName, String property) {
        Map<String, Object> defaults = this.defaultValuesByType.get(nodeTypeName);
        return defaults != null ? defaults.get(property) : null;
    }

    public Map<String, Object> getDefaultsFor(String nodeTypeName) {
        Map<String, Object> defaults = this.defaultValuesByType.get(nodeTypeName);
        return defaults != null ? defaults : EMPTY;
    }
}

