/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.modeshape.common.util.CheckArg;

public class VdbModel
implements Comparable<VdbModel> {
    private String description;
    private String name;
    private String type;
    private String pathInVdb;
    private String sourceTranslator;
    private String sourceJndiName;
    private String sourceName;
    private boolean visible = true;
    private boolean builtIn = false;
    private long checksum;
    private final Set<String> imports = new HashSet<String>();
    private List<ValidationMarker> problems = new ArrayList<ValidationMarker>();
    private final Map<String, String> properties = new HashMap<String, String>();

    public VdbModel(String name, String type, String pathInVdb) {
        CheckArg.isNotEmpty((String)name, (String)"name");
        CheckArg.isNotEmpty((String)type, (String)"type");
        CheckArg.isNotEmpty((String)pathInVdb, (String)"pathInVdb");
        this.name = name;
        this.pathInVdb = pathInVdb;
        this.type = type;
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public void setDescription(String newValue) {
        this.description = newValue;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getType() {
        return this.type;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public void setBuiltIn(boolean builtIn) {
        this.builtIn = builtIn;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public void setChecksum(long checksum) {
        this.checksum = checksum;
    }

    public String getPathInVdb() {
        return this.pathInVdb;
    }

    public String getSourceTranslator() {
        return this.sourceTranslator;
    }

    public void setSourceTranslator(String sourceTranslator) {
        this.sourceTranslator = sourceTranslator;
    }

    public String getSourceJndiName() {
        return this.sourceJndiName;
    }

    public void setSourceJndiName(String sourceJndiName) {
        this.sourceJndiName = sourceJndiName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public Set<String> getImports() {
        return this.imports;
    }

    public void addImport(String newImport) {
        CheckArg.isNotEmpty((String)newImport, (String)"newImport");
        this.imports.add(newImport);
    }

    public List<ValidationMarker> getProblems() {
        return this.problems;
    }

    public void addProblem(Severity severity, String path, String message) {
        this.problems.add(new ValidationMarker(severity, path, message));
    }

    public void addProblem(String severity, String path, String message) {
        if (severity != null) {
            try {
                this.addProblem(Severity.valueOf(severity.trim().toUpperCase()), path, message);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
    }

    @Override
    public int compareTo(VdbModel that) {
        if (that == null) {
            return 1;
        }
        if (that == this) {
            return 0;
        }
        if (this.getImports().contains(that.getPathInVdb())) {
            return 1;
        }
        if (that.getImports().contains(this.getPathInVdb())) {
            return -1;
        }
        return this.getImports().size() - that.getImports().size();
    }

    public static class ValidationMarker {
        private final String path;
        private final Severity severity;
        private final String message;

        public ValidationMarker(Severity severity, String path, String message) {
            this.severity = severity != null ? severity : Severity.ERROR;
            this.path = path != null ? path : "";
            this.message = message != null ? message : "";
        }

        public String getMessage() {
            return this.message;
        }

        public String getPath() {
            return this.path;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public String toString() {
            return this.severity.name() + " '" + this.path + "': " + this.message;
        }
    }

    public static enum Severity {
        WARNING,
        INFO,
        ERROR;

    }
}

