/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid.model;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.sequencer.AbstractSequencerTest;

public class ModelSequencerTest
extends AbstractSequencerTest {
    @Test
    public void shouldSequencePartsSupplierSourceAModel() throws Exception {
        this.createNodeWithContentFromFile("PartsSupplier_SourceA.xmi", "model/parts/PartsSupplier_SourceA.xmi");
        Node outputNode = this.getOutputNode(this.rootNode, "models/PartsSupplier_SourceA.xmi");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.isNodeType("mmcore:model"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)outputNode.isNodeType("xmi:referenceable"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)outputNode.isNodeType(JcrMixLexicon.REFERENCEABLE.getString()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)outputNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"343b7200-1284-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)outputNode.getProperty("mmcore:primaryMetamodelUri").getString(), (Matcher)Is.is((Object)"http://www.metamatrix.com/metamodels/Relational"));
        Assert.assertThat((Object)outputNode.getProperty("mmcore:modelType").getString(), (Matcher)Is.is((Object)"PHYSICAL"));
        Assert.assertThat((Object)outputNode.getProperty("mmcore:producerName").getString(), (Matcher)Is.is((Object)"MetaMatrix"));
        Assert.assertThat((Object)outputNode.getProperty("mmcore:producerVersion").getString(), (Matcher)Is.is((Object)"5.0"));
        NodeIterator itr = outputNode.getNodes("XMLSchema");
        Assert.assertThat((Object)itr.getSize(), (Matcher)Is.is((Object)1L));
        Node importNode = itr.nextNode();
        Assert.assertThat((Object)importNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"mmcore:import"));
        Assert.assertThat((Object)importNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"a6591281-bf1d-1f2c-9911-b53abd16b14e"));
        Assert.assertThat((Object)importNode.getProperty("mmcore:modelLocation").getString(), (Matcher)Is.is((Object)"http://www.w3.org/2001/XMLSchema"));
        Assert.assertThat((Object)importNode.getProperty("mmcore:modelType").getString(), (Matcher)Is.is((Object)"PHYSICAL"));
        Assert.assertThat((Object)importNode.getProperty("mmcore:primaryMetamodelUri").getString(), (Matcher)Is.is((Object)"http://www.eclipse.org/xsd/2002/XSD"));
    }

    @Test
    public void shouldSequenceMyBooksViewModel() throws Exception {
        this.createNodeWithContentFromFile("MyBooksView.xmi", "model/books/MyBooksView.xmi");
        Node outputNode = this.getOutputNode(this.rootNode, "models/MyBooksView.xmi");
        Assert.assertNotNull((Object)outputNode);
    }

    @Test
    public void shouldSequencePartsSupplierVirtualModel() throws Exception {
        this.createNodeWithContentFromFile("PartsVirtual.xmi", "model/parts/PartsVirtual.xmi");
        Node outputNode = this.getOutputNode(this.rootNode, "models/PartsVirtual.xmi");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.isNodeType("mmcore:model"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)outputNode.isNodeType("xmi:referenceable"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)outputNode.isNodeType(JcrMixLexicon.REFERENCEABLE.getString()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)outputNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"fb52cb80-128a-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)outputNode.getProperty("mmcore:primaryMetamodelUri").getString(), (Matcher)Is.is((Object)"http://www.metamatrix.com/metamodels/Relational"));
        Assert.assertThat((Object)outputNode.getProperty("mmcore:modelType").getString(), (Matcher)Is.is((Object)"VIRTUAL"));
        Assert.assertThat((Object)outputNode.getProperty("mmcore:producerName").getString(), (Matcher)Is.is((Object)"Teiid Designer"));
        Assert.assertThat((Object)outputNode.getProperty("mmcore:producerVersion").getString(), (Matcher)Is.is((Object)"6.0"));
        Node importNode = outputNode.getNode("PartSupplier_SourceB");
        Assert.assertNotNull((Object)importNode);
        Assert.assertThat((Object)importNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"mmcore:import"));
        Assert.assertThat((Object)importNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"980de782-b1e5-1f55-853c-ed5dfdd1bb78"));
        Assert.assertThat((Object)importNode.getProperty("mmcore:modelLocation").getString(), (Matcher)Is.is((Object)"PartSupplier_SourceB.xmi"));
        Assert.assertThat((Object)importNode.getProperty("mmcore:modelType").getString(), (Matcher)Is.is((Object)"PHYSICAL"));
        Assert.assertThat((Object)importNode.getProperty("mmcore:primaryMetamodelUri").getString(), (Matcher)Is.is((Object)"http://www.metamatrix.com/metamodels/Relational"));
        importNode = outputNode.getNode("PartsSupplier_SourceA");
        Assert.assertNotNull((Object)importNode);
        Assert.assertThat((Object)importNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"mmcore:import"));
        Assert.assertThat((Object)importNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"980de784-b1e5-1f55-853c-ed5dfdd1bb78"));
        Assert.assertThat((Object)importNode.getProperty("mmcore:modelLocation").getString(), (Matcher)Is.is((Object)"PartsSupplier_SourceA.xmi"));
        Assert.assertThat((Object)importNode.getProperty("mmcore:modelType").getString(), (Matcher)Is.is((Object)"PHYSICAL"));
        Assert.assertThat((Object)importNode.getProperty("mmcore:primaryMetamodelUri").getString(), (Matcher)Is.is((Object)"http://www.metamatrix.com/metamodels/Relational"));
        importNode = outputNode.getNode("XMLSchema");
        Assert.assertNotNull((Object)importNode);
        Assert.assertThat((Object)importNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"mmcore:import"));
        Assert.assertThat((Object)importNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"a6591280-bf1d-1f2c-9911-b53abd16b14e"));
        Assert.assertThat((Object)importNode.getProperty("mmcore:modelLocation").getString(), (Matcher)Is.is((Object)"http://www.w3.org/2001/XMLSchema"));
        Assert.assertThat((Object)importNode.getProperty("mmcore:modelType").getString(), (Matcher)Is.is((Object)"PHYSICAL"));
        Assert.assertThat((Object)importNode.getProperty("mmcore:primaryMetamodelUri").getString(), (Matcher)Is.is((Object)"http://www.eclipse.org/xsd/2002/XSD"));
        Node tableNode = outputNode.getNode("SupplierInfo");
        Assert.assertNotNull((Object)tableNode);
        Assert.assertThat((Object)tableNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"relational:baseTable"));
        Assert.assertThat((Object)tableNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"2473dbc0-128c-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)tableNode.getProperty("relational:supportsUpdate").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)tableNode.isNodeType("transform:transformed"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)tableNode.getProperty("transform:transformedFromHrefs").getValues().length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)tableNode.getProperty("transform:transformedFromHrefs").getValues()[0].getString(), (Matcher)Is.is((Object)"PartSupplier_SourceB.xmi#mmuuid/54ed0900-1275-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)tableNode.getProperty("transform:transformedFromHrefs").getValues()[1].getString(), (Matcher)Is.is((Object)"PartsSupplier_SourceA.xmi#mmuuid/bc400080-1284-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)tableNode.getProperty("transform:transformedFromXmiUuids").getValues().length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)tableNode.getProperty("transform:transformedFromXmiUuids").getValues()[0].getString(), (Matcher)Is.is((Object)"54ed0900-1275-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)tableNode.getProperty("transform:transformedFromXmiUuids").getValues()[1].getString(), (Matcher)Is.is((Object)"bc400080-1284-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)tableNode.isNodeType("transform:withSql"), (Matcher)Is.is((Object)true));
        String selectSql = "SELECT PartSupplier_Oracle.SUPPLIER_PARTS.SUPPLIER_ID, PartSupplier_Oracle.SUPPLIER_PARTS.PART_ID, PartSupplier_Oracle.SUPPLIER_PARTS.QUANTITY, PartSupplier_Oracle.SUPPLIER_PARTS.SHIPPER_ID, PartsSupplier_SQLServer.SUPPLIER.SUPPLIER_NAME, PartsSupplier_SQLServer.SUPPLIER.SUPPLIER_STATUS, PartsSupplier_SQLServer.SUPPLIER.SUPPLIER_CITY, PartsSupplier_SQLServer.SUPPLIER.SUPPLIER_STATE FROM PartSupplier_Oracle.SUPPLIER_PARTS, PartsSupplier_SQLServer.SUPPLIER WHERE PartSupplier_Oracle.SUPPLIER_PARTS.SUPPLIER_ID = PartsSupplier_SQLServer.SUPPLIER.SUPPLIER_ID";
        Assert.assertThat((Object)tableNode.getProperty("transform:selectSql").getString(), (Matcher)Is.is((Object)"SELECT PartSupplier_Oracle.SUPPLIER_PARTS.SUPPLIER_ID, PartSupplier_Oracle.SUPPLIER_PARTS.PART_ID, PartSupplier_Oracle.SUPPLIER_PARTS.QUANTITY, PartSupplier_Oracle.SUPPLIER_PARTS.SHIPPER_ID, PartsSupplier_SQLServer.SUPPLIER.SUPPLIER_NAME, PartsSupplier_SQLServer.SUPPLIER.SUPPLIER_STATUS, PartsSupplier_SQLServer.SUPPLIER.SUPPLIER_CITY, PartsSupplier_SQLServer.SUPPLIER.SUPPLIER_STATE FROM PartSupplier_Oracle.SUPPLIER_PARTS, PartsSupplier_SQLServer.SUPPLIER WHERE PartSupplier_Oracle.SUPPLIER_PARTS.SUPPLIER_ID = PartsSupplier_SQLServer.SUPPLIER.SUPPLIER_ID"));
        Assert.assertThat((Object)tableNode.getNodes().getSize(), (Matcher)Is.is((Object)8L));
        Node columnNode = tableNode.getNode("SUPPLIER_ID");
        Assert.assertNotNull((Object)columnNode);
        Assert.assertThat((Object)columnNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"relational:column"));
        Assert.assertThat((Object)columnNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"143ff680-1291-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)columnNode.getProperty("relational:length").getLong(), (Matcher)Is.is((Object)10L));
        Assert.assertThat((Object)columnNode.getProperty("relational:nativeType").getString(), (Matcher)Is.is((Object)"VARCHAR2"));
        Assert.assertThat((Object)columnNode.getProperty("relational:nullable").getString(), (Matcher)Is.is((Object)"NO_NULLS"));
        Assert.assertThat((Object)columnNode.getProperty("relational:updateable").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)columnNode.getProperty("relational:typeXmiUuid").getString(), (Matcher)Is.is((Object)"bf6c34c0-c442-1e24-9b01-c8207cd53eb7"));
        Assert.assertThat((Object)columnNode.getProperty("relational:typeName").getString(), (Matcher)Is.is((Object)"string"));
        Assert.assertThat((Object)columnNode.getProperty("relational:typeHref").getString(), (Matcher)Is.is((Object)"http://www.w3.org/2001/XMLSchema#string"));
        Assert.assertThat((Object)columnNode.isNodeType("transform:transformed"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)columnNode.getProperty("transform:transformedFromHrefs").getValues().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)columnNode.getProperty("transform:transformedFromHrefs").getValues()[0].getString(), (Matcher)Is.is((Object)"PartSupplier_SourceB.xmi#mmuuid/55e12d01-1275-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)columnNode.getProperty("transform:transformedFromXmiUuids").getValues().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)columnNode.getProperty("transform:transformedFromXmiUuids").getValues()[0].getString(), (Matcher)Is.is((Object)"55e12d01-1275-1eec-8518-c32201e76066"));
        columnNode = tableNode.getNode("PART_ID");
        Assert.assertNotNull((Object)columnNode);
        Assert.assertThat((Object)columnNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"relational:column"));
        Assert.assertThat((Object)columnNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"1d9b97c0-1291-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)columnNode.getProperty("relational:fixedLength").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)columnNode.getProperty("relational:length").getLong(), (Matcher)Is.is((Object)4L));
        Assert.assertThat((Object)columnNode.getProperty("relational:nativeType").getString(), (Matcher)Is.is((Object)"CHAR"));
        Assert.assertThat((Object)columnNode.getProperty("relational:nullable").getString(), (Matcher)Is.is((Object)"NO_NULLS"));
        Assert.assertThat((Object)columnNode.getProperty("relational:updateable").getBoolean(), (Matcher)Is.is((Object)false));
        columnNode = tableNode.getNode("QUANTITY");
        Assert.assertNotNull((Object)columnNode);
        Assert.assertThat((Object)columnNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"relational:column"));
        Assert.assertThat((Object)columnNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"250ef100-1291-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)columnNode.getProperty("relational:caseSensitive").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)columnNode.getProperty("relational:fixedLength").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)columnNode.getProperty("relational:nativeType").getString(), (Matcher)Is.is((Object)"NUMBER"));
        Assert.assertThat((Object)columnNode.getProperty("relational:precision").getLong(), (Matcher)Is.is((Object)3L));
        Assert.assertThat((Object)columnNode.getProperty("relational:updateable").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)columnNode.getProperty("relational:typeXmiUuid").getString(), (Matcher)Is.is((Object)"5bbcf140-b9ae-1e21-b812-969c8fc8b016"));
        Assert.assertThat((Object)columnNode.getProperty("relational:typeName").getString(), (Matcher)Is.is((Object)"short"));
        Assert.assertThat((Object)columnNode.getProperty("relational:typeHref").getString(), (Matcher)Is.is((Object)"http://www.w3.org/2001/XMLSchema#short"));
        columnNode = tableNode.getNode("SHIPPER_ID");
        Assert.assertNotNull((Object)columnNode);
        Assert.assertThat((Object)columnNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"relational:column"));
        Assert.assertThat((Object)columnNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"2b8e2640-1291-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)columnNode.getProperty("relational:caseSensitive").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)columnNode.getProperty("relational:fixedLength").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)columnNode.getProperty("relational:nativeType").getString(), (Matcher)Is.is((Object)"NUMBER"));
        Assert.assertThat((Object)columnNode.getProperty("relational:precision").getLong(), (Matcher)Is.is((Object)2L));
        Assert.assertThat((Object)columnNode.getProperty("relational:updateable").getBoolean(), (Matcher)Is.is((Object)false));
        columnNode = tableNode.getNode("SUPPLIER_NAME");
        Assert.assertNotNull((Object)columnNode);
        Assert.assertThat((Object)columnNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"relational:column"));
        Assert.assertThat((Object)columnNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"34da8540-1291-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)columnNode.getProperty("relational:length").getLong(), (Matcher)Is.is((Object)30L));
        Assert.assertThat((Object)columnNode.getProperty("relational:nativeType").getString(), (Matcher)Is.is((Object)"varchar"));
        Assert.assertThat((Object)columnNode.getProperty("relational:updateable").getBoolean(), (Matcher)Is.is((Object)false));
        columnNode = tableNode.getNode("SUPPLIER_STATUS");
        Assert.assertNotNull((Object)columnNode);
        Assert.assertThat((Object)columnNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"relational:column"));
        Assert.assertThat((Object)columnNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"3c4dde80-1291-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)columnNode.getProperty("relational:caseSensitive").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)columnNode.getProperty("relational:fixedLength").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)columnNode.getProperty("relational:nativeType").getString(), (Matcher)Is.is((Object)"numeric"));
        Assert.assertThat((Object)columnNode.getProperty("relational:precision").getLong(), (Matcher)Is.is((Object)2L));
        Assert.assertThat((Object)columnNode.getProperty("relational:updateable").getBoolean(), (Matcher)Is.is((Object)false));
        columnNode = tableNode.getNode("SUPPLIER_CITY");
        Assert.assertNotNull((Object)columnNode);
        Assert.assertThat((Object)columnNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"relational:column"));
        Assert.assertThat((Object)columnNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"43c137c0-1291-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)columnNode.getProperty("relational:length").getLong(), (Matcher)Is.is((Object)30L));
        Assert.assertThat((Object)columnNode.getProperty("relational:nativeType").getString(), (Matcher)Is.is((Object)"varchar"));
        Assert.assertThat((Object)columnNode.getProperty("relational:updateable").getBoolean(), (Matcher)Is.is((Object)false));
        columnNode = tableNode.getNode("SUPPLIER_STATE");
        Assert.assertNotNull((Object)columnNode);
        Assert.assertThat((Object)columnNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"relational:column"));
        Assert.assertThat((Object)columnNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"4a4faf40-1291-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)columnNode.getProperty("relational:length").getLong(), (Matcher)Is.is((Object)2L));
        Assert.assertThat((Object)columnNode.getProperty("relational:nativeType").getString(), (Matcher)Is.is((Object)"varchar"));
        Assert.assertThat((Object)columnNode.getProperty("relational:updateable").getBoolean(), (Matcher)Is.is((Object)false));
        Node procedureNode = outputNode.getNode("partsByColor");
        Assert.assertNotNull((Object)procedureNode);
        Assert.assertThat((Object)procedureNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"relational:procedure"));
        Assert.assertThat((Object)procedureNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"27a60e44-129f-1eec-8518-c32201e76066"));
        Node paramNode = procedureNode.getNode("colorIn");
        Assert.assertNotNull((Object)paramNode);
        Assert.assertThat((Object)paramNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"relational:procedureParameter"));
        Assert.assertThat((Object)paramNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"56182540-12a6-1eec-8518-c32201e76066"));
        Node resultNode = procedureNode.getNode("NewProcedureResult");
        Assert.assertNotNull((Object)resultNode);
        Assert.assertThat((Object)resultNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"relational:procedureResult"));
        Assert.assertThat((Object)resultNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"77c5dc41-12a7-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)resultNode.getNodes().getSize(), (Matcher)Is.is((Object)4L));
        columnNode = resultNode.getNode("PART_ID");
        Assert.assertNotNull((Object)columnNode);
        Assert.assertThat((Object)columnNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"86998480-12be-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)columnNode.getProperty("relational:length").getLong(), (Matcher)Is.is((Object)50L));
        Assert.assertThat((Object)columnNode.getProperty("relational:nativeType").getString(), (Matcher)Is.is((Object)"varchar"));
        Assert.assertThat((Object)columnNode.getProperty("relational:nullable").getString(), (Matcher)Is.is((Object)"NO_NULLS"));
        columnNode = resultNode.getNode("PART_NAME");
        Assert.assertNotNull((Object)columnNode);
        Assert.assertThat((Object)columnNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"8fe5e380-12be-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)columnNode.getProperty("relational:length").getLong(), (Matcher)Is.is((Object)255L));
        Assert.assertThat((Object)columnNode.getProperty("relational:nativeType").getString(), (Matcher)Is.is((Object)"varchar"));
        columnNode = resultNode.getNode("PART_COLOR");
        Assert.assertNotNull((Object)columnNode);
        Assert.assertThat((Object)columnNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"984d60c0-12be-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)columnNode.getProperty("relational:length").getLong(), (Matcher)Is.is((Object)30L));
        Assert.assertThat((Object)columnNode.getProperty("relational:nativeType").getString(), (Matcher)Is.is((Object)"varchar"));
        columnNode = resultNode.getNode("PART_WEIGHT");
        Assert.assertNotNull((Object)columnNode);
        Assert.assertThat((Object)columnNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"a0a59bc0-12be-1eec-8518-c32201e76066"));
        Assert.assertThat((Object)columnNode.getProperty("relational:length").getLong(), (Matcher)Is.is((Object)255L));
        Assert.assertThat((Object)columnNode.getProperty("relational:nativeType").getString(), (Matcher)Is.is((Object)"varchar"));
    }

    @Test
    public void shouldSequenceOldBooksPhysicalRelationalModelForOracle() throws Exception {
        this.createNodeWithContentFromFile("BooksO.xmi", "model/old/BooksO.xmi");
        Node outputNode = this.getOutputNode(this.rootNode, "models/BooksO.xmi");
        Assert.assertNotNull((Object)outputNode);
    }

    @Test
    public void shouldSequenceOldBooksPhysicalRelationalModelForSqlServer() throws Exception {
        this.createNodeWithContentFromFile("BooksS.xmi", "model/old/BooksS.xmi");
        Node outputNode = this.getOutputNode(this.rootNode, "models/BooksS.xmi");
        Assert.assertNotNull((Object)outputNode);
    }

    @Test
    public void shouldSequenceNewBooksPhysicalRelationalModelForSourceA() throws Exception {
        this.createNodeWithContentFromFile("Books_SourceA.xmi", "model/books/Books_SourceA.xmi");
        Node outputNode = this.getOutputNode(this.rootNode, "models/Books_SourceA.xmi");
        Assert.assertNotNull((Object)outputNode);
    }

    @Test
    public void shouldSequenceNewBooksPhysicalRelationalModelForSourceB() throws Exception {
        this.createNodeWithContentFromFile("Books_SourceB.xmi", "model/books/Books_SourceB.xmi");
        Node outputNode = this.getOutputNode(this.rootNode, "models/Books_SourceB.xmi");
        Assert.assertNotNull((Object)outputNode);
    }

    @Test
    public void shouldSequencePartsSupplierPhysicalRelationalModelForSourceB() throws Exception {
        this.createNodeWithContentFromFile("PartSupplier_SourceB.xmi", "model/parts/PartSupplier_SourceB.xmi");
        Node outputNode = this.getOutputNode(this.rootNode, "models/PartSupplier_SourceB.xmi");
        Assert.assertNotNull((Object)outputNode);
    }

    @Test
    public void shouldSequenceYeeHaaPhysicalRelationalModelForProducts() throws Exception {
        this.createNodeWithContentFromFile("Products.xmi", "model/YeeHaa/Products.xmi");
        Node outputNode = this.getOutputNode(this.rootNode, "models/Products.xmi");
        Assert.assertNotNull((Object)outputNode);
    }

    @Test
    public void shouldSequenceYeeHaaPhysicalRelationalModelForMarketData() throws Exception {
        this.createNodeWithContentFromFile("MarketData.xmi", "model/YeeHaa/MarketData.xmi");
        Node outputNode = this.getOutputNode(this.rootNode, "models/MarketData.xmi");
        Assert.assertNotNull((Object)outputNode);
    }

    @Test
    public void shouldSequenceYeeHaaPhysicalRelationalModelForCustomerAccounts() throws Exception {
        this.createNodeWithContentFromFile("Customer_Accounts.xmi", "model/YeeHaa/Customer_Accounts.xmi");
        Node outputNode = this.getOutputNode(this.rootNode, "models/Customer_Accounts.xmi");
        Assert.assertNotNull((Object)outputNode);
        Node tableNode = outputNode.getNode("CUSTOMER");
        Assert.assertNotNull((Object)tableNode);
        Assert.assertThat((Object)tableNode.isNodeType("relational:table"), (Matcher)Is.is((Object)true));
        Node columnNode = tableNode.getNode("CUSTID");
        Assert.assertNotNull((Object)columnNode);
        Assert.assertThat((Object)columnNode.isNodeType("relational:column"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)columnNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"664708a0-e0b2-4b9e-8b0f-2b49528e0e31"));
        Assert.assertThat((Object)columnNode.getProperty("relational:nameInSource").getString(), (Matcher)Is.is((Object)"CUSTID"));
        Assert.assertThat((Object)columnNode.getProperty("relational:indexXmiUuids").getValues().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)columnNode.getProperty("relational:indexXmiUuids").getValues()[0].getString(), (Matcher)Is.is((Object)"eb7b26ea-b003-4a2a-8b1d-3518952997f2"));
        Assert.assertThat((Object)columnNode.getProperty("relational:indexNames").getValues().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)columnNode.getProperty("relational:indexNames").getValues()[0].getString(), (Matcher)Is.is((Object)"IX_CUSTOMER"));
        Node indexNode = outputNode.getNode("IX_CUSTOMER");
        Assert.assertNotNull((Object)indexNode);
        Assert.assertThat((Object)indexNode.isNodeType("relational:index"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)indexNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"eb7b26ea-b003-4a2a-8b1d-3518952997f2"));
        Assert.assertThat((Object)indexNode.getProperty("relational:nameInSource").getString(), (Matcher)Is.is((Object)"CUSTOMER"));
        Assert.assertThat((Object)indexNode.getProperty("relational:unique").getBoolean(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSequenceYeeHaaPhysicalRelationalModelForMyPortfolio() throws Exception {
        this.createNodeWithContentFromFile("MyPortfolio.xmi", "model/YeeHaa/MyPortfolio.xmi");
        Node outputNode = this.getOutputNode(this.rootNode, "models/MyPortfolio.xmi");
        Assert.assertNotNull((Object)outputNode);
    }

    @Test
    public void shouldSequenceRelationalModel() throws Exception {
        this.createNodeWithContentFromFile("RelationalModel.xmi", "model/relational/RelationalModel.xmi");
        Node outputNode = this.getOutputNode(this.rootNode, "models/RelationalModel.xmi");
        Assert.assertNotNull((Object)outputNode);
        Node catalogEmptyNode = outputNode.getNode("Catalog_Empty");
        Assert.assertNotNull((Object)catalogEmptyNode);
        Assert.assertThat((Object)catalogEmptyNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"relational:catalog"));
        Assert.assertTrue((boolean)catalogEmptyNode.isNodeType("mmcore:annotated"));
        Assert.assertThat((Object)catalogEmptyNode.getProperty("mmcore:description").getString(), (Matcher)Is.is((Object)"Empty Catalog in relational model"));
        Node catalogNode = outputNode.getNode("Catalog");
        Assert.assertNotNull((Object)catalogNode);
        Assert.assertThat((Object)catalogNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"relational:catalog"));
        Node schemaNode = catalogNode.getNode("SchemaInCatalog");
        Assert.assertNotNull((Object)schemaNode);
        Assert.assertThat((Object)schemaNode.isNodeType("relational:schema"), (Matcher)Is.is((Object)true));
        Node viewNode = schemaNode.getNode("View");
        Assert.assertNotNull((Object)viewNode);
        Assert.assertThat((Object)viewNode.isNodeType("relational:view"), (Matcher)Is.is((Object)true));
        Node accessPatternNode = viewNode.getNode("AccessPattern");
        Assert.assertNotNull((Object)accessPatternNode);
        Assert.assertThat((Object)accessPatternNode.isNodeType("relational:accessPattern"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)accessPatternNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"bd3c041e-6982-4d08-9cd2-31eb94cc6c69"));
        Assert.assertThat((Object)accessPatternNode.getProperty("relational:nameInSource").getString(), (Matcher)Is.is((Object)"MyAccessPatter"));
        Assert.assertThat((Object)accessPatternNode.getProperty("relational:columnXmiUuids").getValues().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)accessPatternNode.getProperty("relational:columnXmiUuids").getValues()[0].getString(), (Matcher)Is.is((Object)"580d34a0-c1d7-4a80-9fd5-2bbc19fa47c5"));
        Assert.assertThat((Object)accessPatternNode.getProperty("relational:columnNames").getValues().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)accessPatternNode.getProperty("relational:columnNames").getValues()[0].getString(), (Matcher)Is.is((Object)"column"));
    }

    @Test
    public void shouldSequenceRelationalModelUsingXmlFromSource() throws Exception {
        this.createNodeWithContentFromFile("PartsView.xmi", "model/XmlParts/PartsView.xmi");
        Node outputNode = this.getOutputNode(this.rootNode, "models/PartsView.xmi");
        Assert.assertNotNull((Object)outputNode);
    }

    @Test
    public void shouldNotSequenceXmlDocumentModelForEmployees() throws Exception {
        this.createNodeWithContentFromFile("EmpDoc.xmi", "model/QuickEmployees/EmpDoc.xmi");
        Node outputNode = this.getOutputNode(this.rootNode, "models/EmpDoc.xmi");
        Assert.assertNull((Object)outputNode);
    }

    @Test
    public void shouldSequenceBooksOracleModel() throws Exception {
        this.createNodeWithContentFromFile("Books_Oracle.xmi", "model/books/Books_Oracle.xmi");
        Node outputNode = this.getOutputNode(this.rootNode, "models/Books_Oracle.xmi");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.isNodeType("mmcore:model"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)outputNode.isNodeType("xmi:referenceable"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)outputNode.isNodeType(JcrMixLexicon.REFERENCEABLE.getString()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)outputNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"6f83e692-6183-464c-8a5f-2df8113c98ec"));
        Assert.assertThat((Object)outputNode.getProperty("mmcore:primaryMetamodelUri").getString(), (Matcher)Is.is((Object)"http://www.metamatrix.com/metamodels/Relational"));
        Assert.assertThat((Object)outputNode.getProperty("mmcore:modelType").getString(), (Matcher)Is.is((Object)"PHYSICAL"));
        Assert.assertThat((Object)outputNode.getProperty("mmcore:producerName").getString(), (Matcher)Is.is((Object)"Teiid Designer"));
        Assert.assertThat((Object)outputNode.getProperty("mmcore:producerVersion").getString(), (Matcher)Is.is((Object)"7.4.0.qualifier"));
        Assert.assertThat((Object)outputNode.getProperty("mmcore:maxSetSize").getLong(), (Matcher)Is.is((Object)1000L));
        Node importNode = outputNode.getNode("XMLSchema");
        Assert.assertNotNull((Object)importNode);
        Assert.assertThat((Object)importNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"mmcore:import"));
        Assert.assertThat((Object)importNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"5ba789f7-13bb-4a0a-acd1-ee614a7c06fe"));
        Assert.assertThat((Object)importNode.getProperty("mmcore:modelLocation").getString(), (Matcher)Is.is((Object)"http://www.w3.org/2001/XMLSchema"));
        Assert.assertThat((Object)importNode.getProperty("mmcore:modelType").getString(), (Matcher)Is.is((Object)"TYPE"));
        Assert.assertThat((Object)importNode.getProperty("mmcore:primaryMetamodelUri").getString(), (Matcher)Is.is((Object)"http://www.eclipse.org/xsd/2002/XSD"));
        importNode = outputNode.getNode("SimpleDatatypes-instance");
        Assert.assertNotNull((Object)importNode);
        Assert.assertThat((Object)importNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"mmcore:import"));
        Assert.assertThat((Object)importNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"4cbd7bf3-033a-4898-9811-233b043c5c0a"));
        Assert.assertThat((Object)importNode.getProperty("mmcore:modelLocation").getString(), (Matcher)Is.is((Object)"http://www.metamatrix.com/metamodels/SimpleDatatypes-instance"));
        Assert.assertThat((Object)importNode.getProperty("mmcore:modelType").getString(), (Matcher)Is.is((Object)"TYPE"));
        Assert.assertThat((Object)importNode.getProperty("mmcore:primaryMetamodelUri").getString(), (Matcher)Is.is((Object)"http://www.eclipse.org/xsd/2002/XSD"));
        Node schemaNode = outputNode.getNode("BOOKS");
        Assert.assertNotNull((Object)schemaNode);
        Assert.assertThat((Object)schemaNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"1e40dcf2-8113-4c0b-81de-5a9dbf8bede0"));
        Assert.assertThat((Object)schemaNode.getProperty("relational:nameInSource").getString(), (Matcher)Is.is((Object)"BOOKS"));
        Node tableNode = schemaNode.getNode("AUTHORS");
        Assert.assertNotNull((Object)tableNode);
        Assert.assertThat((Object)tableNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"0351c0b2-f83c-4e1a-b9b2-765f8ee22c26"));
        Assert.assertThat((Object)tableNode.getProperty("relational:nameInSource").getString(), (Matcher)Is.is((Object)"AUTHORS"));
        Node columnNode = tableNode.getNode("AUTHOR_ID");
        Assert.assertNotNull((Object)columnNode);
        Assert.assertThat((Object)columnNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"relational:column"));
        Assert.assertThat((Object)columnNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"3a98c9a7-9298-4495-9ba9-13d54da54592"));
        Assert.assertThat((Object)columnNode.getProperty("relational:nameInSource").getString(), (Matcher)Is.is((Object)"AUTHOR_ID"));
        Assert.assertThat((Object)columnNode.getProperty("relational:caseSensitive").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)columnNode.getProperty("relational:fixedLength").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)columnNode.getProperty("relational:nativeType").getString(), (Matcher)Is.is((Object)"NUMBER"));
        Assert.assertThat((Object)columnNode.getProperty("relational:nullable").getString(), (Matcher)Is.is((Object)"NO_NULLS"));
        Assert.assertThat((Object)columnNode.getProperty("relational:precision").getLong(), (Matcher)Is.is((Object)10L));
        Assert.assertThat((Object)columnNode.getProperty("relational:searchability").getString(), (Matcher)Is.is((Object)"ALL_EXCEPT_LIKE"));
        Node primaryKeyNode = tableNode.getNode("PK_AUTHORS");
        Assert.assertNotNull((Object)primaryKeyNode);
        Assert.assertThat((Object)primaryKeyNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"relational:primaryKey"));
        Assert.assertThat((Object)primaryKeyNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"2ab9553e-1b7a-401e-8076-0c6becdc03bd"));
        Assert.assertThat((Object)primaryKeyNode.getProperty("relational:nameInSource").getString(), (Matcher)Is.is((Object)"PK_AUTHORS"));
        tableNode = schemaNode.getNode("BOOKS");
        Assert.assertNotNull((Object)tableNode);
        Assert.assertThat((Object)tableNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"aab80502-e67d-4a58-9f0b-af9d136c43a0"));
        Assert.assertThat((Object)tableNode.getProperty("relational:nameInSource").getString(), (Matcher)Is.is((Object)"BOOKS"));
        Node foreignKey = tableNode.getNode("FK_PUBLISHER");
        Assert.assertNotNull((Object)foreignKey);
        Assert.assertThat((Object)foreignKey.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"32963de6-3d4a-4309-a19d-d709413c825f"));
        Assert.assertThat((Object)foreignKey.getProperty("relational:nameInSource").getString(), (Matcher)Is.is((Object)"FK_PUBLISHER"));
        Assert.assertThat((Object)foreignKey.getProperty("relational:foreignKeyMultiplicity").getString(), (Matcher)Is.is((Object)"UNSPECIFIED"));
        Assert.assertThat((Object)foreignKey.getProperty("relational:primaryKeyMultiplicity").getString(), (Matcher)Is.is((Object)"UNSPECIFIED"));
        Node jdbcSourceNode = outputNode.getNode("Books Oracle");
        Assert.assertNotNull((Object)jdbcSourceNode);
        Assert.assertThat((Object)jdbcSourceNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"jdbcs:source"));
        Assert.assertThat((Object)jdbcSourceNode.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"a0444c0c-35b3-4ddf-ace4-2b0ce2e5b931"));
        Assert.assertThat((Object)jdbcSourceNode.getProperty("jdbcs:driverName").getString(), (Matcher)Is.is((Object)"Oracle Thin Driver"));
        Assert.assertThat((Object)jdbcSourceNode.getProperty("jdbcs:driverClass").getString(), (Matcher)Is.is((Object)"oracle.jdbc.OracleDriver"));
        Assert.assertThat((Object)jdbcSourceNode.getProperty("jdbcs:username").getString(), (Matcher)Is.is((Object)"books"));
        Assert.assertThat((Object)jdbcSourceNode.getProperty("jdbcs:url").getString(), (Matcher)Is.is((Object)"jdbc:oracle:thin:@englxdbs11.mm.atl2.redhat.com:1521:ORCL"));
        Node settings = outputNode.getNode("jdbcs:imported");
        Assert.assertNotNull((Object)settings);
        Assert.assertThat((Object)settings.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"jdbcs:imported"));
        Assert.assertThat((Object)settings.getProperty("xmi:uuid").getString(), (Matcher)Is.is((Object)"5c6e0cc1-400d-4e3b-aa8a-d4fdef6a3e36"));
        Assert.assertThat((Object)settings.getProperty("jdbcs:includeIndexes").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)settings.getProperty("jdbcs:includeApproximateIndexes").getBoolean(), (Matcher)Is.is((Object)false));
        Property property = settings.getProperty("jdbcs:includedSchemaPaths");
        Assert.assertNotNull((Object)property);
        Assert.assertThat((Object)property.getValues().length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)property.getValues()[0].getString(), (Matcher)Is.is((Object)"/BOOKS"));
        Assert.assertThat((Object)property.getValues()[1].getString(), (Matcher)Is.is((Object)"/EBOOKS"));
        property = settings.getProperty("jdbcs:includedTableTypes");
        Assert.assertNotNull((Object)property);
        Assert.assertThat((Object)property.getValues().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)property.getValues()[0].getString(), (Matcher)Is.is((Object)"TABLE"));
    }
}

