/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid.model;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.teiid.TeiidI18n;
import org.modeshape.sequencer.teiid.VdbModel;
import org.modeshape.sequencer.teiid.model.ModelNodeWriter;
import org.modeshape.sequencer.teiid.model.ModelReader;
import org.modeshape.sequencer.teiid.model.ReferenceResolver;

public class ModelSequencer
extends Sequencer {
    private static final boolean DEBUG = false;
    private static final String[] MODEL_FILE_EXTENSIONS = new String[]{".xmi"};
    private static final Logger LOGGER = Logger.getLogger(ModelSequencer.class);
    private final ReferenceResolver resolver;

    private void debug(String message) {
        LOGGER.debug(message, new Object[0]);
    }

    public static boolean shouldSequence(ModelReader modelReader) {
        assert (modelReader != null);
        String modelType = modelReader.getModelType();
        boolean validModelType = "PHYSICAL".equalsIgnoreCase(modelType) || "VIRTUAL".equalsIgnoreCase(modelType);
        return validModelType && "http://www.metamatrix.com/metamodels/Relational".equals(modelReader.getPrimaryMetamodelUri());
    }

    public ModelSequencer() {
        this.resolver = new ReferenceResolver();
    }

    public ModelSequencer(ReferenceResolver resolver) {
        CheckArg.isNotNull((Object)resolver, (String)"resolver");
        this.resolver = resolver;
    }

    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        outputNode.addMixin("mmcore:model");
        return this.sequenceModel(binaryValue.getStream(), outputNode, outputNode.getPath(), null, context);
    }

    public boolean hasModelFileExtension(String resourceName) {
        for (String extension : MODEL_FILE_EXTENSIONS) {
            if (!resourceName.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        this.debug("enter initialize");
        super.registerNodeTypes("../xmi.cnd", nodeTypeManager, true);
        this.debug("xmi.cnd loaded");
        super.registerNodeTypes("../mmcore.cnd", nodeTypeManager, true);
        this.debug("mmcore.cnd loaded");
        super.registerNodeTypes("../jdbc.cnd", nodeTypeManager, true);
        this.debug("jdbc.cnd loaded");
        super.registerNodeTypes("../relational.cnd", nodeTypeManager, true);
        this.debug("relational.cnd loaded");
        super.registerNodeTypes("../transformation.cnd", nodeTypeManager, true);
        this.debug("transformation.cnd loaded");
        this.registerNamespace("diagram", "http://www.metamatrix.com/metamodels/Diagram", registry);
        this.registerNamespace("modelExtensionDefinition", "http://www.jboss.org/teiiddesigner/ext/2012", registry);
        this.debug("exit initialize");
    }

    private boolean sequenceModel(InputStream modelStream, Node modelOutputNode, String modelPath, VdbModel vdbModel, Sequencer.Context context) throws Exception {
        assert (modelStream != null);
        assert (modelOutputNode != null);
        assert (context != null);
        assert (modelOutputNode.isNodeType("mmcore:model"));
        this.debug("sequenceModel:model node path=" + modelOutputNode.getPath() + ", model path=" + modelPath + ", vdb model=" + vdbModel);
        NamespaceRegistry registry = modelOutputNode.getSession().getWorkspace().getNamespaceRegistry();
        ModelReader modelReader = new ModelReader(modelPath, this.resolver, registry);
        modelReader.readModel(modelStream);
        if (ModelSequencer.shouldSequence(modelReader)) {
            ModelNodeWriter nodeWriter = new ModelNodeWriter(modelOutputNode, modelReader, this.resolver, vdbModel, context);
            return nodeWriter.write();
        }
        return false;
    }

    public boolean sequenceVdbModel(InputStream modelStream, Node modelOutputNode, VdbModel vdbModel, Sequencer.Context context) throws Exception {
        CheckArg.isNotNull((Object)modelStream, (String)"modelStream");
        CheckArg.isNotNull((Object)modelOutputNode, (String)"modelOutputNode");
        CheckArg.isNotNull((Object)vdbModel, (String)"vdbModel");
        if (!modelOutputNode.isNodeType("vdb:model")) {
            throw new RuntimeException(TeiidI18n.invalidVdbModelNodeType.text(new Object[]{modelOutputNode.getPath()}));
        }
        return this.sequenceModel(modelStream, modelOutputNode, vdbModel.getPathInVdb(), vdbModel, context);
    }
}

