/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Value;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.jcr.sequencer.AbstractSequencerTest;
import org.modeshape.sequencer.teiid.VdbSequencer;

public class VdbSequencerTest
extends AbstractSequencerTest {
    protected InputStream getRepositoryConfigStream() {
        return this.resourceStream("config/repo-config.json");
    }

    @Ignore
    @Test
    public void shouldSequencePartsSupplierVDB() throws Exception {
        this.createNodeWithContentFromFile("model/parts/PartsSupplierVDB.vdb", "model/parts/PartsSupplierVDB.vdb");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/PartsSupplierVDB.vdb");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertEquals((Object)"vdb:virtualDatabase", (Object)outputNode.getPrimaryNodeType().getName());
    }

    @Test
    public void shouldHaveValidCnds() throws Exception {
        this.registerNodeTypes("org/modeshape/sequencer/teiid/xmi.cnd");
        this.registerNodeTypes("org/modeshape/sequencer/teiid/jdbc.cnd");
        this.registerNodeTypes("org/modeshape/sequencer/teiid/mmcore.cnd");
        this.registerNodeTypes("org/modeshape/sequencer/teiid/relational.cnd");
        this.registerNodeTypes("org/modeshape/sequencer/teiid/transformation.cnd");
        this.registerNodeTypes("org/modeshape/sequencer/teiid/vdb.cnd");
    }

    @Test
    public void shouldSequenceBooksVDB() throws Exception {
        this.createNodeWithContentFromFile("BooksVDB.vdb", "model/books/BooksVDB.vdb");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/BooksVDB.vdb");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:virtualDatabase"));
        Assert.assertThat((Object)outputNode.getProperty("vdb:description").getString(), (Matcher)Is.is((Object)"This is a VDB description"));
        Assert.assertThat((Object)outputNode.getProperty("vdb:version").getLong(), (Matcher)Is.is((Object)2L));
        Assert.assertThat((Object)outputNode.getProperty("vdb:preview").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)outputNode.getProperty("query-timeout").getLong(), (Matcher)Is.is((Object)10000L));
        Node modelNode = outputNode.getNode("BooksProcedures.xmi");
        Assert.assertThat((Object)modelNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:model"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:pathInVdb").getString(), (Matcher)Is.is((Object)"/TestRESTWarGen/BooksProcedures.xmi"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:visible").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)modelNode.getProperty("vdb:builtIn").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)modelNode.getProperty("vdb:checksum").getLong(), (Matcher)Is.is((Object)1855484649L));
        Assert.assertThat((Object)modelNode.getProperty("vdb:description").getString(), (Matcher)Is.is((Object)"This is a model description"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:type").getString(), (Matcher)Is.is((Object)"VIRTUAL"));
        Assert.assertThat((Object)modelNode.getProperty("modelClass").getString(), (Matcher)Is.is((Object)"Relational"));
        Assert.assertThat((Object)modelNode.getProperty("indexName").getString(), (Matcher)Is.is((Object)"1159106455.INDEX"));
        modelNode = outputNode.getNode("MyBooks.xmi");
        Assert.assertThat((Object)modelNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:model"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:pathInVdb").getString(), (Matcher)Is.is((Object)"/TestRESTWarGen/MyBooks.xmi"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:visible").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)modelNode.getProperty("vdb:type").getString(), (Matcher)Is.is((Object)"PHYSICAL"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:builtIn").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)modelNode.getProperty("vdb:sourceTranslator").getString(), (Matcher)Is.is((Object)"MyBooks_mysql5"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:sourceJndiName").getString(), (Matcher)Is.is((Object)"MyBooks"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:sourceName").getString(), (Matcher)Is.is((Object)"MyBooks"));
        Assert.assertThat((Object)modelNode.getProperty("modelClass").getString(), (Matcher)Is.is((Object)"Relational"));
        Assert.assertThat((Object)modelNode.getProperty("indexName").getString(), (Matcher)Is.is((Object)"718925066.INDEX"));
        modelNode = outputNode.getNode("MyBooksView.xmi");
        Assert.assertThat((Object)modelNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:model"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:type").getString(), (Matcher)Is.is((Object)"VIRTUAL"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:pathInVdb").getString(), (Matcher)Is.is((Object)"/TestRESTWarGen/MyBooksView.xmi"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:visible").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)modelNode.getProperty("vdb:builtIn").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)modelNode.getProperty("vdb:checksum").getLong(), (Matcher)Is.is((Object)825941341L));
        Assert.assertThat((Object)modelNode.getProperty("modelClass").getString(), (Matcher)Is.is((Object)"Relational"));
        Assert.assertThat((Object)modelNode.getProperty("indexName").getString(), (Matcher)Is.is((Object)"2173178531.INDEX"));
        Node booksTable = modelNode.getNode("BOOKS");
        Assert.assertThat((Object)booksTable.isNodeType("transform:transformed"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)booksTable.hasProperty("transform:transformedFromNames"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)booksTable.getProperty("transform:transformedFromNames").getValues().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)booksTable.getProperty("transform:transformedFromNames").getValues()[0].getString(), (Matcher)Is.is((Object)"BOOKS"));
        Node markersGroupNode = modelNode.getNode("vdb:markers");
        Assert.assertNotNull((Object)markersGroupNode);
        NodeIterator itr = markersGroupNode.getNodes();
        Assert.assertThat((Object)itr.getSize(), (Matcher)Is.is((Object)3L));
        String message1 = "The name BOOKS is the same (ignoring case) as 1 other object(s) under the same parent";
        String message2 = "Group does not exist: MyBooksView.BOOKS";
        String message3 = "The name BOOKS is the same (ignoring case) as 1 other object(s) under the same parent";
        int messagesFound = 0;
        while (itr.hasNext()) {
            Node node = itr.nextNode();
            Assert.assertThat((Object)node.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:marker"));
            Assert.assertThat((Object)node.getProperty("vdb:path").getString(), (Matcher)Is.is((Object)"BOOKS"));
            Assert.assertThat((Object)node.getProperty("vdb:severity").getString(), (Matcher)Is.is((Object)"ERROR"));
            if (node.getProperty("vdb:message").getString().equals(message1)) {
                ++messagesFound;
                message1 = "message1 found";
                continue;
            }
            if (node.getProperty("vdb:message").getString().equals(message2)) {
                ++messagesFound;
                message2 = "message2 found";
                continue;
            }
            if (!node.getProperty("vdb:message").getString().equals(message3)) continue;
            ++messagesFound;
            message3 = "message3 found";
        }
        Assert.assertThat((Object)messagesFound, (Matcher)Is.is((Object)3));
        boolean entry1Found = false;
        boolean entry2Found = false;
        Node entriesGroupNode = outputNode.getNode("vdb:entries");
        Assert.assertNotNull((Object)entriesGroupNode);
        Assert.assertThat((Object)entriesGroupNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:entries"));
        itr = entriesGroupNode.getNodes();
        Assert.assertThat((Object)itr.getSize(), (Matcher)Is.is((Object)2L));
        while (itr.hasNext()) {
            Node entryNode = itr.nextNode();
            Assert.assertThat((Object)entryNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:entry"));
            if (!entry1Found && "path1".equals(entryNode.getProperty("vdb:path").getString())) {
                entry1Found = true;
                Assert.assertThat((Object)entryNode.getProperty("vdb:description").getString(), (Matcher)Is.is((Object)"This is entry 1 description"));
                Assert.assertThat((Object)entryNode.getProperty("drummer").getString(), (Matcher)Is.is((Object)"Ringo"));
                Assert.assertThat((Object)entryNode.getProperty("guitar").getString(), (Matcher)Is.is((Object)"John"));
                continue;
            }
            if (!entry2Found && "path2".equals(entryNode.getProperty("vdb:path").getString())) {
                entry2Found = true;
                Assert.assertThat((Object)entryNode.getProperty("vdb:path").getString(), (Matcher)Is.is((Object)"path2"));
                Assert.assertThat((Object)entryNode.getProperty("vdb:description").getString(), (Matcher)Is.is((Object)"This is entry 2 description"));
                Assert.assertThat((Object)entryNode.getProperty("bass").getString(), (Matcher)Is.is((Object)"Paul"));
                Assert.assertThat((Object)entryNode.getProperty("leadGuitar").getString(), (Matcher)Is.is((Object)"George"));
                continue;
            }
            Assert.fail();
        }
        Assert.assertThat((Object)(entry1Found && entry2Found ? 1 : 0), (Matcher)Is.is((Object)true));
        Node translatorsGroupNode = outputNode.getNode("vdb:translators");
        Assert.assertNotNull((Object)translatorsGroupNode);
        Assert.assertThat((Object)translatorsGroupNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:translators"));
        Assert.assertThat((Object)translatorsGroupNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        Node translatorNode = translatorsGroupNode.getNode("MyBooks_mysql5");
        Assert.assertNotNull((Object)translatorNode);
        Assert.assertThat((Object)translatorNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:translator"));
        Assert.assertThat((Object)translatorNode.getProperty("vdb:type").getString(), (Matcher)Is.is((Object)"mysql5"));
        Assert.assertThat((Object)translatorNode.getProperty("vdb:description").getString(), (Matcher)Is.is((Object)"This is a translator description"));
        Assert.assertThat((Object)translatorNode.getProperty("nameInSource").getString(), (Matcher)Is.is((Object)"bogusName"));
        Assert.assertThat((Object)translatorNode.getProperty("supportsUpdate").getBoolean(), (Matcher)Is.is((Object)true));
        Node dataRolesGroupNode = outputNode.getNode("vdb:dataRoles");
        Assert.assertNotNull((Object)dataRolesGroupNode);
        Assert.assertThat((Object)dataRolesGroupNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:dataRoles"));
        Assert.assertThat((Object)dataRolesGroupNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        Node dataRoleNode = dataRolesGroupNode.getNode("My Data Role");
        Assert.assertNotNull((Object)dataRoleNode);
        Assert.assertThat((Object)dataRoleNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:dataRole"));
        Assert.assertThat((Object)dataRoleNode.getProperty("vdb:description").getString(), (Matcher)Is.is((Object)"my data role description"));
        Assert.assertThat((Object)dataRoleNode.getProperty("vdb:allowCreateTemporaryTables").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)dataRoleNode.getProperty("vdb:anyAuthenticated").getBoolean(), (Matcher)Is.is((Object)true));
        Value[] roleNames = dataRoleNode.getProperty("vdb:mappedRoleNames").getValues();
        Assert.assertThat((Object)roleNames.length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)("Sledge".equals(roleNames[0].getString()) || "Sledge".equals(roleNames[1].getString()) ? 1 : 0), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)("Hammer".equals(roleNames[0].getString()) || "Hammer".equals(roleNames[1].getString()) ? 1 : 0), (Matcher)Is.is((Object)true));
        Node permissionsGroupNode = dataRoleNode.getNode("vdb:permissions");
        Assert.assertNotNull((Object)permissionsGroupNode);
        Assert.assertThat((Object)permissionsGroupNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:permissions"));
        Assert.assertThat((Object)permissionsGroupNode.getNodes().getSize(), (Matcher)Is.is((Object)3L));
        Node permNode = permissionsGroupNode.getNode("BooksProcedures");
        Assert.assertNotNull((Object)permNode);
        Assert.assertThat((Object)permNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:permission"));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowCreate").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowRead").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowUpdate").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowDelete").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowExecute").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowAlter").getBoolean(), (Matcher)Is.is((Object)false));
        permNode = permissionsGroupNode.getNode("sysadmin");
        Assert.assertNotNull((Object)permNode);
        Assert.assertThat((Object)permNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:permission"));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowCreate").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowRead").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowUpdate").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowDelete").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowExecute").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowAlter").getBoolean(), (Matcher)Is.is((Object)false));
        permNode = permissionsGroupNode.getNode("MyBooks");
        Assert.assertNotNull((Object)permNode);
        Assert.assertThat((Object)permNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:permission"));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowCreate").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowRead").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowUpdate").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowDelete").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowExecute").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowAlter").getBoolean(), (Matcher)Is.is((Object)false));
    }

    @Ignore
    @Test
    public void shouldSequenceVdbForQuickEmployees() throws Exception {
        this.createNodeWithContentFromFile("vdb/qe.vdb", "vdb/qe.vdb");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/qe.vdb");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertEquals((Object)"vdb:virtualDatabase", (Object)outputNode.getPrimaryNodeType().getName());
    }

    @Ignore
    @Test
    public void shouldSequenceVdbForQuickEmployeesWithVersionSpecifiedInFileName() throws Exception {
        this.createNodeWithContentFromFile("vdb/qe.2.vdb", "vdb/qe.2.vdb");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/qe.2.vdb");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertEquals((Object)"vdb:virtualDatabase", (Object)outputNode.getPrimaryNodeType().getName());
    }

    @Ignore
    @Test
    public void shouldSequenceVdbForPartsFromXml() throws Exception {
        this.createNodeWithContentFromFile("vdb/PartsFromXml.vdb", "vdb/PartsFromXml.vdb");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/PartsFromXml.vdb");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertEquals((Object)"vdb:virtualDatabase", (Object)outputNode.getPrimaryNodeType().getName());
    }

    @Ignore
    @Test
    public void shouldSequenceVdbForYahooUdfTest() throws Exception {
        this.createNodeWithContentFromFile("vdb/YahooUdfTest.vdb", "vdb/YahooUdfTest.vdb");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/YahooUdfTest.vdb");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertEquals((Object)"vdb:virtualDatabase", (Object)outputNode.getPrimaryNodeType().getName());
    }

    @Test
    public void shouldExtractVersionInformation() {
        this.assertVersionInfo("something", "something", 1);
        this.assertVersionInfo("something.else", "something.else", 1);
        this.assertVersionInfo("something else", "something else", 1);
        this.assertVersionInfo("something.", "something", 1);
        this.assertVersionInfo("something.1", "something", 1);
        this.assertVersionInfo("something.12", "something", 12);
        this.assertVersionInfo("something.123", "something", 123);
        this.assertVersionInfo("something.4", "something", 4);
        this.assertVersionInfo("something.-4", "something", 4);
        this.assertVersionInfo("something.+4", "something", 4);
        this.assertVersionInfo("something. 4", "something", 4);
        this.assertVersionInfo("something.  4", "something", 4);
        this.assertVersionInfo("something.  -4", "something", 4);
        this.assertVersionInfo("something.  -1234  ", "something", 1234);
    }

    protected void assertVersionInfo(String fileNameWithoutExtension, String expectedName, int expectedVersion) {
        AtomicInteger actual = new AtomicInteger(1);
        String name = VdbSequencer.extractVersionInfomation((String)fileNameWithoutExtension, (AtomicInteger)actual);
        Assert.assertThat((Object)name, (Matcher)Is.is((Object)expectedName));
        Assert.assertThat((Object)actual.get(), (Matcher)Is.is((Object)expectedVersion));
    }
}

