/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.teiid.ImportVdb;
import org.modeshape.sequencer.teiid.TeiidI18n;
import org.modeshape.sequencer.teiid.VdbDataRole;
import org.modeshape.sequencer.teiid.VdbEntry;
import org.modeshape.sequencer.teiid.VdbManifest;
import org.modeshape.sequencer.teiid.VdbModel;
import org.modeshape.sequencer.teiid.VdbTranslator;
import org.modeshape.sequencer.teiid.model.ModelSequencer;
import org.modeshape.sequencer.teiid.model.ReferenceResolver;

public class VdbSequencer
extends Sequencer {
    private static final Logger LOGGER = Logger.getLogger(VdbSequencer.class);
    private static final String MANIFEST_FILE = "META-INF/vdb.xml";
    private static final Pattern VERSION_REGEX = Pattern.compile("(.*)[.]\\s*[+-]?([0-9]+)\\s*$");
    private ModelSequencer modelSequencer;
    private ReferenceResolver resolver;

    public static String extractVersionInfomation(String fileNameWithoutExtension, AtomicInteger version) {
        Matcher matcher = VERSION_REGEX.matcher(fileNameWithoutExtension);
        if (matcher.matches()) {
            fileNameWithoutExtension = matcher.group(1);
            version.set(Integer.parseInt(matcher.group(2)));
        }
        return fileNameWithoutExtension.replaceAll("[.]*$", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        boolean entryName222;
        ZipInputStream vdbStream;
        block19: {
            LOGGER.debug("VdbSequencer.execute called:outputNode name='{0}', path='{1}'", new Object[]{outputNode.getName(), outputNode.getPath()});
            javax.jcr.Binary binaryValue = inputProperty.getBinary();
            CheckArg.isNotNull((Object)binaryValue, (String)"binary");
            vdbStream = null;
            vdbStream = new ZipInputStream(binaryValue.getStream());
            VdbManifest manifest = null;
            ZipEntry entry = null;
            while ((entry = vdbStream.getNextEntry()) != null) {
                String entryName222 = entry.getName();
                if (entryName222.endsWith(MANIFEST_FILE)) {
                    LOGGER.debug("----before reading vdb.xml", new Object[0]);
                    manifest = VdbManifest.read(vdbStream, context);
                    assert (manifest != null) : "manifest is null";
                    outputNode.setPrimaryType("vdb:virtualDatabase");
                    outputNode.addMixin("mix:referenceable");
                    outputNode.setProperty("vdb:version", (long)manifest.getVersion());
                    outputNode.setProperty("vdb:originalFile", outputNode.getPath());
                    outputNode.setProperty("mode:sha1", ((Binary)binaryValue).getHexHash());
                    this.setProperty(outputNode, "vdb:description", manifest.getDescription());
                    this.sequenceImportVdbs(manifest, outputNode);
                    this.sequenceTranslators(manifest, outputNode);
                    this.sequenceDataRoles(manifest, outputNode);
                    this.sequenceEntries(manifest, outputNode);
                    this.sequenceProperties(manifest, outputNode);
                    this.sequenceDeclarativeModels(manifest, outputNode);
                    LOGGER.debug(">>>>done reading vdb.xml\n\n", new Object[0]);
                    continue;
                }
                if (!entry.isDirectory() && this.modelSequencer.hasModelFileExtension(entryName222)) {
                    Node modelNode;
                    boolean sequenced;
                    LOGGER.debug("----before reading model '{0}'", new Object[]{entryName222});
                    if (manifest == null) {
                        throw new Exception("VDB manifest file has not been read");
                    }
                    VdbModel vdbModel = manifest.getModel(entryName222);
                    if (vdbModel == null) {
                        throw new Exception("Model '" + entryName222 + "' was not found");
                    }
                    int index = entryName222.lastIndexOf(47) + 1;
                    if (index != -1 && index < entryName222.length()) {
                        entryName222 = entryName222.substring(index);
                    }
                    if (!(sequenced = this.modelSequencer.sequenceVdbModel(vdbStream, modelNode = outputNode.addNode(entryName222, "vdb:model"), vdbModel, context))) {
                        modelNode.remove();
                        LOGGER.debug(">>>>model NOT sequenced '{0}'\n\n", new Object[]{entryName222});
                        continue;
                    }
                    LOGGER.debug(">>>>done sequencing model '{0}'\n\n", new Object[]{entryName222});
                    continue;
                }
                LOGGER.debug("----ignoring resource '{0}'", new Object[]{entryName222});
            }
            entryName222 = true;
            if (vdbStream == null) break block19;
            try {
                vdbStream.close();
            }
            catch (Exception e) {
                this.getLogger().warn((Throwable)e, TeiidI18n.errorClosingVdbFile.text(new Object[]{inputProperty.getPath(), e.getMessage()}), new Object[0]);
            }
        }
        return entryName222;
        catch (Exception e) {
            boolean bl;
            block20: {
                try {
                    this.getLogger().error((Throwable)e, TeiidI18n.errorReadingVdbFile.text(new Object[]{inputProperty.getPath(), e.getMessage()}), new Object[0]);
                    bl = false;
                    if (vdbStream == null) break block20;
                }
                catch (Throwable throwable) {
                    if (vdbStream != null) {
                        try {
                            vdbStream.close();
                        }
                        catch (Exception e2) {
                            this.getLogger().warn((Throwable)e2, TeiidI18n.errorClosingVdbFile.text(new Object[]{inputProperty.getPath(), e2.getMessage()}), new Object[0]);
                        }
                    }
                    throw throwable;
                }
                try {
                    vdbStream.close();
                }
                catch (Exception e3) {
                    this.getLogger().warn((Throwable)e3, TeiidI18n.errorClosingVdbFile.text(new Object[]{inputProperty.getPath(), e3.getMessage()}), new Object[0]);
                }
            }
            return bl;
        }
    }

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        registry.registerNamespace("vdb", "http://www.metamatrix.com/metamodels/VirtualDatabase");
        registry.registerNamespace("xmi", "http://www.omg.org/XMI");
        registry.registerNamespace("mmcore", "http://www.metamatrix.com/metamodels/Core");
        this.registerNodeTypes("xmi.cnd", nodeTypeManager, true);
        this.registerNodeTypes("mmcore.cnd", nodeTypeManager, true);
        this.registerNodeTypes("vdb.cnd", nodeTypeManager, true);
        this.resolver = new ReferenceResolver();
        this.modelSequencer = new ModelSequencer(this.resolver);
        this.modelSequencer.initialize(registry, nodeTypeManager);
    }

    private void sequenceDataRoles(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        List<VdbDataRole> dataRolesGroup = manifest.getDataRoles();
        if (!dataRolesGroup.isEmpty()) {
            Node dataRolesGroupNode = outputNode.addNode("vdb:dataRoles", "vdb:dataRoles");
            for (VdbDataRole dataRole : dataRolesGroup) {
                List<VdbDataRole.Permission> permissionsGroup;
                Node dataRoleNode = dataRolesGroupNode.addNode(dataRole.getName(), "vdb:dataRole");
                this.setProperty(dataRoleNode, "vdb:description", dataRole.getDescription());
                dataRoleNode.setProperty("vdb:anyAuthenticated", dataRole.isAnyAuthenticated());
                dataRoleNode.setProperty("vdb:allowCreateTemporaryTables", dataRole.isAllowCreateTempTables());
                List<String> roleNames = dataRole.getMappedRoleNames();
                if (!roleNames.isEmpty()) {
                    dataRoleNode.setProperty("vdb:mappedRoleNames", roleNames.toArray(new String[roleNames.size()]));
                }
                if ((permissionsGroup = dataRole.getPermissions()).isEmpty()) continue;
                Node permissionsGroupNode = dataRoleNode.addNode("vdb:permissions", "vdb:permissions");
                for (VdbDataRole.Permission permission : permissionsGroup) {
                    Node permissionNode = permissionsGroupNode.addNode(permission.getResourceName(), "vdb:permission");
                    permissionNode.setProperty("vdb:allowAlter", permission.canAlter());
                    permissionNode.setProperty("vdb:allowCreate", permission.canCreate());
                    permissionNode.setProperty("vdb:allowDelete", permission.canDelete());
                    permissionNode.setProperty("vdb:allowExecute", permission.canExecute());
                    permissionNode.setProperty("vdb:allowRead", permission.canRead());
                    permissionNode.setProperty("vdb:allowUpdate", permission.canUpdate());
                }
            }
        }
    }

    private void sequenceDeclarativeModels(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        for (VdbModel model : manifest.getModels()) {
            if (!model.isDeclarative()) continue;
            LOGGER.debug(">>>>writing declarative model '{0}'", new Object[]{model.getName()});
            Node modelNode = outputNode.addNode(model.getName(), "vdb:declarativeModel");
            this.setProperty(modelNode, "vdb:description", model.getDescription());
            modelNode.setProperty("vdb:visible", model.isVisible());
            this.setProperty(modelNode, "vdb:pathInVdb", model.getPathInVdb());
            this.setProperty(modelNode, "vdb:sourceTranslator", model.getSourceTranslator());
            this.setProperty(modelNode, "vdb:sourceJndiName", model.getSourceJndiName());
            this.setProperty(modelNode, "vdb:sourceName", model.getSourceName());
            this.setProperty(modelNode, "mmcore:modelType", model.getType());
            this.setProperty(modelNode, "vdb:metadataType", model.getMetadataType());
            this.setProperty(modelNode, "vdb:modelDefinition", model.getModelDefinition());
        }
    }

    private void sequenceEntries(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        List<VdbEntry> entriesGroup = manifest.getEntries();
        if (!entriesGroup.isEmpty()) {
            Node entriesGroupNode = outputNode.addNode("vdb:entries", "vdb:entries");
            for (VdbEntry entry : entriesGroup) {
                Node entryNode = entriesGroupNode.addNode("vdb:entry", "vdb:entry");
                this.setProperty(entryNode, "vdb:path", entry.getPath());
                this.setProperty(entryNode, "vdb:description", entry.getDescription());
                Map<String, String> props = entry.getProperties();
                if (props.isEmpty()) continue;
                for (Map.Entry<String, String> prop : props.entrySet()) {
                    this.setProperty(entryNode, prop.getKey(), prop.getValue());
                }
            }
        }
    }

    private void sequenceImportVdbs(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        List<ImportVdb> importVdbsGroup = manifest.getImportVdbs();
        if (!importVdbsGroup.isEmpty()) {
            Node importVdbsGroupNode = outputNode.addNode("vdb:importVdbs", "vdb:importVdbs");
            for (ImportVdb importVdb : importVdbsGroup) {
                Node importVdbNode = importVdbsGroupNode.addNode(importVdb.getName(), "vdb:importVdb");
                importVdbNode.setProperty("vdb:version", (long)importVdb.getVersion());
                importVdbNode.setProperty("vdb:importDataPolicies", importVdb.isImportDataPolicies());
            }
        }
    }

    private void sequenceProperties(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        Map<String, String> props = manifest.getProperties();
        if (!props.isEmpty()) {
            for (Map.Entry<String, String> prop : props.entrySet()) {
                if ("preview".equals(prop.getKey())) {
                    outputNode.setProperty("vdb:preview", Boolean.parseBoolean(prop.getValue()));
                    continue;
                }
                this.setProperty(outputNode, prop.getKey(), prop.getValue());
            }
        }
    }

    private void sequenceTranslators(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        List<VdbTranslator> translatorsGroup = manifest.getTranslators();
        if (!translatorsGroup.isEmpty()) {
            Node translatorsGroupNode = outputNode.addNode("vdb:translators", "vdb:translators");
            for (VdbTranslator translator : translatorsGroup) {
                Node translatorNode = translatorsGroupNode.addNode(translator.getName(), "vdb:translator");
                this.setProperty(translatorNode, "vdb:type", translator.getType());
                this.setProperty(translatorNode, "vdb:description", translator.getDescription());
                Map<String, String> props = translator.getProperties();
                if (props.isEmpty()) continue;
                for (Map.Entry<String, String> prop : props.entrySet()) {
                    this.setProperty(translatorNode, prop.getKey(), prop.getValue());
                }
            }
        }
    }

    private void setProperty(Node node, String name, String value) throws Exception {
        assert (node != null);
        assert (!StringUtil.isBlank((String)name));
        if (!StringUtil.isBlank((String)value)) {
            node.setProperty(name, value);
        }
    }
}

