/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.text.DefaultRowFactory;
import org.modeshape.sequencer.text.RowFactory;
import org.modeshape.sequencer.text.TextSequencerI18n;

@ThreadSafe
public abstract class AbstractTextSequencer
implements StreamSequencer {
    private final Logger logger = Logger.getLogger(this.getClass());
    private String rowFactoryClassName = null;
    private String commentMarker = null;
    private int maximumLinesToRead = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
        BufferedReader reader = null;
        String line = null;
        RowFactory rowFactory = null;
        String rowFactoryClassName = this.rowFactoryClassName;
        String commentMarker = this.commentMarker;
        int maxLinesToRead = this.maximumLinesToRead;
        int rowCount = 0;
        try {
            rowFactory = this.createRowFactory(rowFactoryClassName);
        }
        catch (Exception ex) {
            throw new IllegalStateException(TextSequencerI18n.couldNotInstantiateRowFactory.text(new Object[]{rowFactoryClassName}));
        }
        try {
            reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                if (commentMarker != null && line.startsWith(this.commentMarker)) continue;
                if (maxLinesToRead > 0 && ++rowCount > maxLinesToRead) {
                    return;
                }
                String[] columns = this.parseLine(line);
                rowFactory.recordRow(context, output, columns);
            }
        }
        catch (IOException ioe) {
            this.logger.error((Throwable)ioe, TextSequencerI18n.errorReadingLine, new Object[]{context.getInputPath()});
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ignore) {}
        }
    }

    public void setCommentMarker(String commentMarker) {
        this.commentMarker = commentMarker;
    }

    public String getCommentMarker() {
        return this.commentMarker;
    }

    public int getMaximumLinesToRead() {
        return this.maximumLinesToRead;
    }

    public void setMaximumLinesToRead(int maximumLinesToRead) {
        this.maximumLinesToRead = maximumLinesToRead;
    }

    public String getRowFactoryClassName() {
        return this.rowFactoryClassName;
    }

    public synchronized void setRowFactoryClassName(String rowFactoryClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.createRowFactory(rowFactoryClassName);
        this.rowFactoryClassName = rowFactoryClassName;
    }

    protected abstract String[] parseLine(String var1);

    protected synchronized RowFactory createRowFactory(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (this.rowFactoryClassName == null) {
            return new DefaultRowFactory();
        }
        Class<?> rowFactoryClass = Class.forName(this.rowFactoryClassName);
        RowFactory rowFactory = (RowFactory)rowFactoryClass.newInstance();
        return rowFactory;
    }
}

