/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.video;

import javax.jcr.Node;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jcr.sequencer.AbstractSequencerTest;

public class VideoMetadataSequencerTest
extends AbstractSequencerTest {
    @Test
    public void shouldSequenceAvi() throws Exception {
        String filename = "sample.avi";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.getOutputNode(this.rootNode, "sequenced/video/" + filename);
        Assert.assertThat((Object)sequencedNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)"video/x-msvideo"));
        Assert.assertThat((Object)sequencedNode.getProperty("video:duration").getDouble(), (Matcher)Is.is((Object)3.0));
        Assert.assertThat((Object)sequencedNode.getProperty("video:title").getString(), (Matcher)Is.is((Object)"Title"));
        Assert.assertThat((Object)sequencedNode.getProperty("video:comment").getString(), (Matcher)Is.is((Object)"Comment"));
        Assert.assertThat((Object)sequencedNode.getProperty("video:encoder").getString(), (Matcher)Is.is((Object)"Lavf56.25.101"));
        Node videoStream = sequencedNode.getNode("video:stream0");
        Assert.assertThat((Object)videoStream.getProperty("video:streamType").getString(), (Matcher)Is.is((Object)"video"));
        Assert.assertThat((Object)videoStream.getProperty("video:codec").getString(), (Matcher)Is.is((Object)"mpeg4"));
        Assert.assertThat((Object)videoStream.getProperty("video:width").getLong(), (Matcher)Is.is((Object)320L));
        Assert.assertThat((Object)videoStream.getProperty("video:height").getLong(), (Matcher)Is.is((Object)240L));
        Assert.assertThat((Object)videoStream.getProperty("video:framerate").getDouble(), (Matcher)Is.is((Object)15.0));
        Node audioStream = sequencedNode.getNode("video:stream1");
        Assert.assertThat((Object)audioStream.getProperty("video:streamType").getString(), (Matcher)Is.is((Object)"audio"));
        Assert.assertThat((Object)audioStream.getProperty("video:codec").getString(), (Matcher)Is.is((Object)"mp3"));
        Assert.assertThat((Object)audioStream.getProperty("video:samplerate").getLong(), (Matcher)Is.is((Object)48000L));
        Assert.assertThat((Object)audioStream.getProperty("video:channels").getLong(), (Matcher)Is.is((Object)2L));
    }

    @Test
    public void shouldSequenceMp4() throws Exception {
        String filename = "sample.mp4";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.getOutputNode(this.rootNode, "sequenced/video/" + filename);
        Assert.assertThat((Object)sequencedNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)"video/mp4"));
        Assert.assertThat((Object)sequencedNode.getProperty("video:title").getString(), (Matcher)Is.is((Object)"Title"));
        Assert.assertThat((Object)sequencedNode.getProperty("video:comment").getString(), (Matcher)Is.is((Object)"Comment"));
        Assert.assertThat((Object)sequencedNode.getProperty("video:encoder").getString(), (Matcher)Is.is((Object)"Lavf56.25.101"));
        Node videoStream = sequencedNode.getNode("video:stream0");
        Assert.assertThat((Object)videoStream.getProperty("video:streamType").getString(), (Matcher)Is.is((Object)"video"));
        Assert.assertThat((Object)videoStream.getProperty("video:codec").getString(), (Matcher)Is.is((Object)"h264"));
        Assert.assertThat((Object)videoStream.getProperty("video:height").getLong(), (Matcher)Is.is((Object)240L));
        Assert.assertThat((Object)videoStream.getProperty("video:framerate").getDouble(), (Matcher)Is.is((Object)30.0));
        Node audioStream = sequencedNode.getNode("video:stream1");
        Assert.assertThat((Object)audioStream.getProperty("video:streamType").getString(), (Matcher)Is.is((Object)"audio"));
        Assert.assertThat((Object)audioStream.getProperty("video:codec").getString(), (Matcher)Is.is((Object)"aac"));
        Assert.assertThat((Object)audioStream.getProperty("video:samplerate").getLong(), (Matcher)Is.is((Object)48000L));
        Assert.assertThat((Object)audioStream.getProperty("video:channels").getLong(), (Matcher)Is.is((Object)6L));
    }

    @Test
    public void shouldSequenceMkv() throws Exception {
        String filename = "sample.mkv";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.getOutputNode(this.rootNode, "sequenced/video/" + filename);
        Assert.assertThat((Object)sequencedNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)"video/x-matroska"));
        Assert.assertThat((Object)sequencedNode.getProperty("video:title").getString(), (Matcher)Is.is((Object)"Title"));
        Assert.assertThat((Object)sequencedNode.getProperty("video:encoder").getString(), (Matcher)Is.is((Object)"Lavf56.25.101"));
        Node videoStream = sequencedNode.getNode("video:stream0");
        Assert.assertThat((Object)videoStream.getProperty("video:streamType").getString(), (Matcher)Is.is((Object)"video"));
        Assert.assertThat((Object)videoStream.getProperty("video:codec").getString(), (Matcher)Is.is((Object)"h264"));
        Assert.assertThat((Object)videoStream.getProperty("video:height").getLong(), (Matcher)Is.is((Object)240L));
        Assert.assertThat((Object)videoStream.getProperty("video:framerate").getDouble(), (Matcher)Is.is((Object)50.0));
        Node audioStream = sequencedNode.getNode("video:stream1");
        Assert.assertThat((Object)audioStream.getProperty("video:streamType").getString(), (Matcher)Is.is((Object)"audio"));
        Assert.assertThat((Object)audioStream.getProperty("video:codec").getString(), (Matcher)Is.is((Object)"aac"));
        Assert.assertThat((Object)audioStream.getProperty("video:samplerate").getLong(), (Matcher)Is.is((Object)48000L));
        Assert.assertThat((Object)audioStream.getProperty("video:channels").getLong(), (Matcher)Is.is((Object)6L));
    }
}

