/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFixedFacet;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDWhiteSpace;
import org.eclipse.xsd.XSDWhiteSpaceFacet;
import org.eclipse.xsd.impl.XSDFixedFacetImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDWhiteSpaceFacetImpl
extends XSDFixedFacetImpl
implements XSDWhiteSpaceFacet {
    protected static final XSDWhiteSpace VALUE_EDEFAULT = XSDWhiteSpace.PRESERVE_LITERAL;
    protected XSDWhiteSpace value = VALUE_EDEFAULT;

    public static XSDWhiteSpaceFacet createWhiteSpaceFacet(Node node) {
        if (XSDConstants.nodeType(node) == 41) {
            XSDWhiteSpaceFacet xsdWhiteSpaceFacet = XSDFactory.eINSTANCE.createXSDWhiteSpaceFacet();
            xsdWhiteSpaceFacet.setElement((Element)node);
            return xsdWhiteSpaceFacet;
        }
        return null;
    }

    protected XSDWhiteSpaceFacetImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_WHITE_SPACE_FACET;
    }

    public XSDWhiteSpace getValue() {
        return this.value;
    }

    public void setValue(XSDWhiteSpace newValue) {
        XSDWhiteSpace oldValue = this.value;
        XSDWhiteSpace xSDWhiteSpace = this.value = newValue == null ? VALUE_EDEFAULT : newValue;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldValue, (Object)this.value));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 11: {
                return this.getValue();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 11: {
                this.setValue((XSDWhiteSpace)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 11: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 11: {
                return this.value != VALUE_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (value: ");
        result.append(this.value);
        result.append(')');
        return result.toString();
    }

    public Element createElement() {
        Element newElement = this.createElement(41);
        this.setElement(newElement);
        return newElement;
    }

    protected void validateRestriction(XSDFixedFacet xsdFixedFacet) {
        if (this.getValue().getValue() < ((XSDWhiteSpaceFacet)xsdFixedFacet).getValue().getValue()) {
            XSDDiagnostic xsdDiagnostic = this.reportConstraintViolation("http://www.w3.org/TR/xmlschema-2/", "whiteSpace-valid-restriction", this.getElement(), "value", new Object[]{this.getLexicalValue(), xsdFixedFacet.getLexicalValue(), xsdFixedFacet.getSimpleTypeDefinition().getURI()});
            xsdDiagnostic.getComponents().add(xsdFixedFacet);
        }
    }

    protected void validateValue() {
        XSDSimpleTypeDefinition whiteSpaceEnumeration = ((XSDAttributeUse)((XSDComplexTypeDefinition)this.getSimpleTypeDefinition().getSchema().getSchemaForSchema().resolveElementDeclaration("whiteSpace").getTypeDefinition()).getAttributeContents().get(0)).getAttributeDeclaration().getTypeDefinition();
        this.checkSimpleTypeConstraint(whiteSpaceEnumeration, this.getLexicalValue(), "http://www.w3.org/TR/xmlschema-2/", "element-whiteSpace", this.getElement(), "value", true);
    }

    protected void changeAttribute(EAttribute eAttribute) {
        super.changeAttribute(eAttribute);
        if (eAttribute == XSDPackage.Literals.XSD_FACET__LEXICAL_VALUE) {
            String newValue = this.getLexicalValue();
            XSDWhiteSpace literal = XSDWhiteSpace.get(newValue);
            if (literal == null) {
                if (this.getValue() != XSDWhiteSpace.PRESERVE_LITERAL) {
                    this.setValue(XSDWhiteSpace.PRESERVE_LITERAL);
                }
            } else if (literal != this.getValue()) {
                this.setValue(literal);
            }
        }
    }

    public String getNormalizedLiteral(String literal) {
        switch (this.getValue().getValue()) {
            case 2: {
                StringBuffer stringBuffer = new StringBuffer();
                boolean holdWhitespace = false;
                int i = 0;
                int length = literal.length();
                while (i < length) {
                    char character = literal.charAt(i);
                    if (Character.isWhitespace(character)) {
                        holdWhitespace = true;
                    } else {
                        if (stringBuffer.length() == 0) {
                            holdWhitespace = false;
                        }
                        if (holdWhitespace) {
                            holdWhitespace = false;
                            stringBuffer.append(" ");
                        }
                        stringBuffer.append(character);
                    }
                    ++i;
                }
                return stringBuffer.toString();
            }
            case 1: {
                StringBuffer stringBuffer = new StringBuffer(literal);
                int i = 0;
                int length = literal.length();
                while (i < length) {
                    char character = literal.charAt(i);
                    if (Character.isWhitespace(character)) {
                        stringBuffer.setCharAt(i, Character.isWhitespace(character) ? (char)' ' : (char)character);
                    }
                    ++i;
                }
                return stringBuffer.toString();
            }
        }
        return literal;
    }

    public Object getEffectiveValue() {
        return this.getValue();
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDWhiteSpaceFacetImpl clonedWhiteSpaceFacet = (XSDWhiteSpaceFacetImpl)this.getXSDFactory().createXSDWhiteSpaceFacet();
        clonedWhiteSpaceFacet.isReconciling = true;
        if (this.getLexicalValue() != null) {
            clonedWhiteSpaceFacet.setLexicalValue(this.getLexicalValue());
        }
        if (this.isSetFixed()) {
            clonedWhiteSpaceFacet.setFixed(this.isFixed());
        }
        if (deep && this.getAnnotation() != null) {
            clonedWhiteSpaceFacet.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedWhiteSpaceFacet.setElement(this.getElement());
        }
        clonedWhiteSpaceFacet.isReconciling = shareDOM;
        return clonedWhiteSpaceFacet;
    }
}

