/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.xsd;

import java.util.HashMap;
import java.util.Map;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.sequencer.xsd.NamespaceEntityResolver;

public class XsdResolvers {
    private final Map<SymbolSpace, NamespaceEntityResolver> resolversByKind = new HashMap<SymbolSpace, NamespaceEntityResolver>();

    public NamespaceEntityResolver get(SymbolSpace kind) {
        NamespaceEntityResolver resolver = this.resolversByKind.get(kind);
        if (resolver == null) {
            resolver = new NamespaceEntityResolver();
            this.resolversByKind.put(kind, resolver);
        }
        return resolver;
    }

    @Immutable
    public static final class SymbolSpace {
        public static final SymbolSpace ATTRIBUTE_DECLARATIONS = new SymbolSpace("AttributeDeclarations");
        public static final SymbolSpace ELEMENT_DECLARATION = new SymbolSpace("ElementDeclarations");
        public static final SymbolSpace TYPE_DEFINITIONS = new SymbolSpace("TypeDeclarations");
        public static final SymbolSpace ATTRIBUTE_GROUP_DEFINITIONS = new SymbolSpace("AttributeGroupDeclarations");
        public static final SymbolSpace MODEL_GROUP_DEFINITIONS = new SymbolSpace("ModelGroupDeclarations");
        public static final SymbolSpace IDENTITY_CONSTRAINT_DEFINITIONS = new SymbolSpace("IdentityConstraintDeclarations");
        private final String space;

        public SymbolSpace(String space) {
            this.space = space;
        }

        public int hashCode() {
            return this.space.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SymbolSpace) {
                SymbolSpace that = (SymbolSpace)obj;
                return this.space.equals(that.space);
            }
            return false;
        }

        public String toString() {
            return this.space;
        }
    }
}

