/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDSchemaCompositorImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDIncludeImpl
extends XSDSchemaCompositorImpl
implements XSDInclude {
    protected XSDAnnotation annotation = null;

    public static XSDInclude createInclude(Node node) {
        if (XSDConstants.nodeType(node) == 18) {
            XSDInclude xsdInclude = XSDFactory.eINSTANCE.createXSDInclude();
            xsdInclude.setElement((Element)node);
            return xsdInclude;
        }
        return null;
    }

    protected XSDIncludeImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_INCLUDE;
    }

    public XSDAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(XSDAnnotation newAnnotation) {
        if (newAnnotation != this.annotation) {
            NotificationChain msgs = null;
            if (this.annotation != null) {
                msgs = ((InternalEObject)((Object)this.annotation)).eInverseRemove(this, -9, null, msgs);
            }
            if (newAnnotation != null) {
                msgs = ((InternalEObject)((Object)newAnnotation)).eInverseAdd(this, -9, null, msgs);
            }
            if ((msgs = this.basicSetAnnotation(newAnnotation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 8, (Object)newAnnotation, (Object)newAnnotation));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return this.basicSetAnnotation(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain basicSetAnnotation(XSDAnnotation newAnnotation, NotificationChain msgs) {
        XSDAnnotation oldAnnotation = this.annotation;
        this.annotation = newAnnotation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldAnnotation, (Object)newAnnotation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getAnnotation();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setAnnotation(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.annotation != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public Element createElement() {
        Element newElement = this.createElement(18);
        this.setElement(newElement);
        return newElement;
    }

    protected void patch() {
        if (this.getSchemaLocation() != null && this.getSchemaLocation().length() > 0) {
            this.resolve("", this.getSchemaLocation());
        }
        super.patch();
    }

    protected void handleResolvedSchema(XSDSchema xsdSchema) {
        if (xsdSchema == null) {
            this.setResolvedSchema(null);
            this.setIncorporatedSchema(null);
        } else {
            ((XSDSchemaImpl)xsdSchema).included(this);
        }
    }

    public void validate() {
        super.validate();
        Element theElement = this.getElement();
        if (theElement != null) {
            this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", "element-include", theElement, new String[]{"id", "schemaLocation"});
            this.checkComplexContent("annotated", "http://www.w3.org/TR/xmlschema-1/", "element-include", theElement);
            this.checkBuiltInTypeConstraint("ID", null, "http://www.w3.org/TR/xmlschema-1/", "element-include", theElement, "id", false);
        }
        this.checkBuiltInTypeConstraint("anyURI", this.getSchemaLocation(), "http://www.w3.org/TR/xmlschema-1/", "element-include", theElement, "schemaLocation", true);
        XSDSchema theResolvedSchema = this.getResolvedSchema();
        if (theResolvedSchema == null) {
            this.createDiagnostic(XSDDiagnosticSeverity.WARNING_LITERAL, "src-include.0", this.getSchemaLocation() == null ? "" : this.getSchemaLocation());
        } else if (theResolvedSchema.eResource() == null || theResolvedSchema.getElement() == null || XSDConstants.nodeType(theResolvedSchema.getElement()) != 33) {
            this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-include.1", this.getSchemaLocation() == null ? "" : this.getSchemaLocation());
        } else {
            XSDSchema theSchema = this.getSchema();
            if (theSchema.getTargetNamespace() == null ? theResolvedSchema.getTargetNamespace() != null : !theSchema.getTargetNamespace().equals(theResolvedSchema.getTargetNamespace()) && theResolvedSchema.getTargetNamespace() != null) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-include.2", theResolvedSchema.getTargetNamespace() == null ? "" : theResolvedSchema.getTargetNamespace(), theSchema.getTargetNamespace() == null ? "" : theSchema.getTargetNamespace());
            }
        }
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDIncludeImpl clonedInclude = (XSDIncludeImpl)this.getXSDFactory().createXSDInclude();
        clonedInclude.isReconciling = true;
        clonedInclude.setSchemaLocation(this.getSchemaLocation());
        if (deep && this.getAnnotation() != null) {
            clonedInclude.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedInclude.setElement(this.getElement());
        }
        clonedInclude.isReconciling = shareDOM;
        return clonedInclude;
    }
}

