/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.wsdl;

import java.io.InputStream;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.sequencer.MockSequencerContext;
import org.modeshape.graph.sequencer.MockSequencerOutput;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.wsdl.Wsdl11Reader;

public class Wsdl11ReaderTest {
    private ExecutionContext execContext;
    private MockSequencerOutput output;
    private StreamSequencerContext context;
    private Wsdl11Reader reader;
    private boolean print;

    @Before
    public void beforeEach() {
        this.print = false;
        this.execContext = new ExecutionContext();
        this.execContext.getNamespaceRegistry().register("xsd", "http://www.w3.org/2001/XMLSchema");
        this.execContext.getNamespaceRegistry().register("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.execContext.getNamespaceRegistry().register("sramp", "http://s-ramp.org/xmlns/2010/s-ramp");
    }

    @After
    public void afterEach() {
        System.out.flush();
        System.err.flush();
        this.context = null;
        this.output = null;
        this.reader = null;
    }

    protected void read(String pathToFile) {
        InputStream stream = this.load(pathToFile);
        this.context = new MockSequencerContext(this.execContext, pathToFile);
        this.output = new MockSequencerOutput(this.context, true);
        this.reader = new Wsdl11Reader((SequencerOutput)this.output, this.context);
        this.reader.read(stream, this.context.getInputPath());
        if (this.context.getProblems().hasProblems()) {
            System.out.println(this.context.getProblems());
            Assert.fail((String)("At least one problem sequencing \"" + pathToFile + "\""));
        }
    }

    @Test
    public void shouldBeAbleToParse_loanServicePT() {
        this.read("loanServicePT.wsdl");
        this.print = true;
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParse_uddi_api_v3_portType() {
        this.read("uddi_api_v3_portType.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParse_uddi_custody_v3_binding() {
        this.read("uddi_custody_v3_binding.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParse_uddi_repl_v3_binding() {
        this.read("uddi_repl_v3_binding.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParse_uddi_repl_v3_portType() {
        this.read("uddi_repl_v3_portType.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParse_uddi_sub_v3_binding() {
        this.read("uddi_sub_v3_binding.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParse_uddi_sub_v3_portType() {
        this.read("uddi_sub_v3_portType.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParse_uddi_sbr_v3_binding() {
        this.read("uddi_subr_v3_binding.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParse_uddi_v3_service() {
        this.read("uddi_v3_service.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParse_uddi_vs_v3_binding() {
        this.read("uddi_vs_v3_binding.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParse_uddi_vs_v3_portType() {
        this.read("uddi_vs_v3_portType.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParse_uddi_vscache_v3_binding() {
        this.read("uddi_vscache_v3_binding.wsdl");
        this.printOutput();
    }

    @Test
    public void shouldBeAbleToParse_uddi_vscache_v3_portType() {
        this.read("uddi_vscache_v3_portType.wsdl");
        this.printOutput();
    }

    protected void printOutput() {
        if (this.print) {
            for (Path path : this.output.getOrderOfCreation()) {
                Map props = this.output.getProperties(path);
                for (Map.Entry entry : props.entrySet()) {
                    System.out.println(this.string(path) + " " + ((Property)entry.getValue()).getString(this.context.getNamespaceRegistry()));
                }
            }
        }
    }

    protected InputStream load(String resourcePath) {
        InputStream stream = this.getClass().getResourceAsStream("/" + resourcePath);
        Assert.assertThat((Object)stream, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        return stream;
    }

    protected final Path path(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected final Path relativePath(Name ... segments) {
        return this.context.getValueFactories().getPathFactory().createRelativePath(segments);
    }

    protected final String string(String path) {
        return (String)this.context.getValueFactories().getStringFactory().create(path);
    }

    protected final String string(Object value) {
        return (String)this.context.getValueFactories().getStringFactory().create(value);
    }

    protected final Name name(String path) {
        return (Name)this.context.getValueFactories().getNameFactory().create(path);
    }
}

