/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.zip;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.property.BinaryFactory;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;

public class ZipSequencer
implements StreamSequencer {
    public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
        BinaryFactory binaryFactory = context.getValueFactories().getBinaryFactory();
        DateTimeFactory dateFactory = context.getValueFactories().getDateFactory();
        String resourcePrimaryType = (String)context.getValueFactories().getStringFactory().create(ModeShapeLexicon.RESOURCE);
        try {
            ZipInputStream in = new ZipInputStream(stream);
            ZipEntry entry = in.getNextEntry();
            byte[] buf = new byte[1024];
            output.setProperty("zip:content", "jcr:primaryType", new Object[]{"zip:content"});
            while (entry != null) {
                if (entry.isDirectory()) {
                    output.setProperty("zip:content/" + entry.getName(), "jcr:primaryType", new Object[]{"nt:folder"});
                } else {
                    int n;
                    output.setProperty("zip:content/" + entry.getName(), "jcr:primaryType", new Object[]{"nt:file"});
                    output.setProperty("zip:content/" + entry.getName() + "/jcr:content", "jcr:primaryType", new Object[]{resourcePrimaryType});
                    ByteArrayOutputStream baout = new ByteArrayOutputStream();
                    while ((n = in.read(buf, 0, 1024)) > -1) {
                        baout.write(buf, 0, n);
                    }
                    byte[] bytes = baout.toByteArray();
                    output.setProperty("zip:content/" + entry.getName() + "/jcr:content", "jcr:data", new Object[]{binaryFactory.create(bytes)});
                    output.setProperty("zip:content/" + entry.getName() + "/jcr:content", "jcr:encoding", new Object[]{"binary"});
                    output.setProperty("zip:content/" + entry.getName() + "/jcr:content", "jcr:lastModified", new Object[]{((DateTime)dateFactory.create(entry.getTime())).toString()});
                    output.setProperty("zip:content/" + entry.getName() + "/jcr:content", "jcr:mimeType", new Object[]{"application/octet-stream"});
                }
                in.closeEntry();
                entry = in.getNextEntry();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

