/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.cmis;

import java.util.HashMap;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.StandardAuthenticationProvider;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Element;

public class ModeShapeCmisClientTest {
    private Session session;

    @Before
    public void setUp() {
        SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", this.serviceUrl("ACLService?wsdl"));
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", this.serviceUrl("/DiscoveryService?wsdl"));
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", this.serviceUrl("MultiFilingService?wsdl"));
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", this.serviceUrl("NavigationService?wsdl"));
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", this.serviceUrl("ObjectService?wsdl"));
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", this.serviceUrl("/PolicyService?wsdl"));
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", this.serviceUrl("RelationshipService?wsdl"));
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", this.serviceUrl("RepositoryService?wsdl"));
        parameter.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", this.serviceUrl("VersioningService?wsdl"));
        parameter.put("org.apache.chemistry.opencmis.session.repository.id", "cmis_repo:default");
        this.session = factory.createSession(parameter, null, (AuthenticationProvider)new StandardAuthenticationProvider(){

            public Element getSOAPHeaders(Object portObject) {
                return super.getSOAPHeaders(portObject);
            }
        }, null);
    }

    @Test
    public void shouldAccessRootFolder() throws Exception {
        Folder root = this.session.getRootFolder();
        System.out.println("Root: " + root);
    }

    private String serviceUrl(String serviceMethod) {
        return "http://localhost:8090/modeshape-cmis/services/" + serviceMethod;
    }
}

