/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr;

import java.util.Iterator;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.jcr.JcrDocument;
import org.apache.chemistry.opencmis.jcr.JcrPrivateWorkingCopy;
import org.apache.chemistry.opencmis.jcr.JcrTypeManager;
import org.apache.chemistry.opencmis.jcr.JcrVersion;
import org.apache.chemistry.opencmis.jcr.PathManager;
import org.apache.chemistry.opencmis.jcr.type.JcrTypeHandlerManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JcrVersionBase
extends JcrDocument {
    private static final Log log = LogFactory.getLog(JcrVersionBase.class);

    protected JcrVersionBase(Node node, JcrTypeManager typeManager, PathManager pathManager, JcrTypeHandlerManager typeHandlerManager) {
        super(node, typeManager, pathManager, typeHandlerManager);
    }

    public Iterator<JcrVersion> getVersions() {
        try {
            VersionHistory versionHistory = JcrVersionBase.getVersionHistory(this.getNode());
            final VersionIterator versions = versionHistory.getAllLinearVersions();
            return new Iterator<JcrVersion>(){

                @Override
                public boolean hasNext() {
                    return versions.hasNext();
                }

                @Override
                public JcrVersion next() {
                    return new JcrVersion(JcrVersionBase.this.getNode(), versions.nextVersion(), JcrVersionBase.this.typeManager, JcrVersionBase.this.pathManager, JcrVersionBase.this.typeHandlerManager);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void delete(boolean allVersions, boolean isPwc) {
        block5: {
            Node node = this.getNode();
            try {
                if (node.isCheckedOut()) {
                    if (isPwc) {
                        JcrVersionBase.cancelCheckout(node);
                        break block5;
                    }
                    throw new CmisStorageException("Cannot delete checked out document: " + this.getId());
                }
                if (allVersions) {
                    JcrVersionBase.checkout(node);
                    node.remove();
                    node.getSession().save();
                    break block5;
                }
                throw new CmisRuntimeException("Cannot delete a single version");
            }
            catch (RepositoryException e) {
                log.debug((Object)e.getMessage(), (Throwable)e);
                throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public JcrPrivateWorkingCopy checkout() {
        Node node = this.getNode();
        try {
            if (node.isCheckedOut()) {
                throw new CmisConstraintException("Document is already checked out " + this.getId());
            }
            JcrVersionBase.checkout(node);
            return this.getPwc();
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public JcrVersion checkin(Properties properties, ContentStream contentStream, String checkinComment) {
        Node node = this.getNode();
        try {
            if (!node.isCheckedOut()) {
                throw new CmisStorageException("Not checked out: " + this.getId());
            }
            if (properties != null && !properties.getPropertyList().isEmpty()) {
                this.updateProperties(properties);
            }
            if (contentStream != null) {
                this.setContentStream(contentStream, true);
            }
            JcrVersionBase.checkin(node);
            return (JcrVersion)this.create(node);
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public void cancelCheckout() {
        Node node = this.getNode();
        try {
            JcrVersionBase.cancelCheckout(node);
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public JcrPrivateWorkingCopy getPwc() {
        try {
            Node node = this.getNode();
            if (node.isCheckedOut()) {
                return new JcrPrivateWorkingCopy(this.getNode(), this.typeManager, this.pathManager, this.typeHandlerManager);
            }
            throw new CmisObjectNotFoundException("Not checked out document has no private working copy");
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public JcrVersion getVersion(String name) {
        try {
            Node node = this.getNode();
            VersionHistory versionHistory = JcrVersionBase.getVersionHistory(node);
            Version version = versionHistory.getVersion(name);
            return new JcrVersion(node, version, this.typeManager, this.pathManager, this.typeHandlerManager);
        }
        catch (UnsupportedRepositoryOperationException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisObjectNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (VersionException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisObjectNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    protected String getBaseNodeId() throws RepositoryException {
        Version baseVersion = JcrVersionBase.getBaseVersion(this.getNode());
        JcrVersion baseNode = new JcrVersion(this.getNode(), baseVersion, this.typeManager, this.pathManager, this.typeHandlerManager);
        return baseNode.getId();
    }

    protected String getPwcId() throws RepositoryException {
        return null;
    }

    @Override
    protected void compileProperties(PropertiesImpl properties, Set<String> filter, ObjectInfoImpl objectInfo) throws RepositoryException {
        super.compileProperties(properties, filter, objectInfo);
        objectInfo.setWorkingCopyOriginalId(this.getBaseNodeId());
        objectInfo.setWorkingCopyId(this.getPwcId());
    }

    @Override
    protected Set<Action> compileAllowableActions(Set<Action> aas) {
        Set<Action> result = super.compileAllowableActions(aas);
        JcrVersionBase.setAction(result, Action.CAN_GET_ALL_VERSIONS, true);
        JcrVersionBase.setAction(result, Action.CAN_CHECK_OUT, true);
        JcrVersionBase.setAction(result, Action.CAN_CANCEL_CHECK_OUT, true);
        JcrVersionBase.setAction(result, Action.CAN_CHECK_IN, true);
        return result;
    }

    @Override
    protected String getTypeIdInternal() {
        return "cmis:document";
    }

    @Override
    protected boolean isCheckedOut() throws RepositoryException {
        return this.getNode().isCheckedOut();
    }

    @Override
    protected String getCheckedOutId() throws RepositoryException {
        return this.isCheckedOut() ? this.getVersionSeriesId() + "/pwc" : null;
    }

    @Override
    protected String getCheckedOutBy() throws RepositoryException {
        return this.isCheckedOut() ? this.getNode().getSession().getUserID() : null;
    }

    private static void checkout(Node node) throws RepositoryException {
        JcrVersionBase.getVersionManager(node).checkout(node.getPath());
    }

    private static void checkin(Node node) throws RepositoryException {
        JcrVersionBase.getVersionManager(node).checkin(node.getPath());
    }

    private static void cancelCheckout(Node node) throws RepositoryException {
        Version base = JcrVersionBase.getBaseVersion(node);
        JcrVersionBase.getVersionManager(node).restore(base, true);
    }
}

