/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.cmis;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RepositoryConfig {
    private static final String REPO_PARAMETER_PREFIX = "jcr.";
    private static final String MOUNT_PATH_CONFIG = "mount-path";

    public static Map<String, Map<String, String>> load(Map<String, String> params) {
        HashMap<String, Map<String, String>> set = new HashMap<String, Map<String, String>>();
        Set<String> keys = params.keySet();
        for (String key : keys) {
            if (!key.startsWith(REPO_PARAMETER_PREFIX)) continue;
            String fqn = key.substring(REPO_PARAMETER_PREFIX.length());
            String repositoryId = fqn.substring(0, fqn.indexOf("."));
            HashMap<String, String> map = (HashMap<String, String>)set.get(repositoryId);
            if (map == null) {
                map = new HashMap<String, String>();
                set.put(repositoryId, map);
            }
            String name = fqn.substring(fqn.indexOf(".") + 1, fqn.length());
            String value = params.get(key);
            map.put(name, RepositoryConfig.replaceSystemProperties(value));
        }
        return set;
    }

    private static String replaceSystemProperties(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        StringBuilder property = null;
        boolean inProperty = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (inProperty) {
                if (c == '}') {
                    String value = System.getProperty(property.toString());
                    if (value != null) {
                        result.append(value);
                    }
                    inProperty = false;
                    continue;
                }
                property.append(c);
                continue;
            }
            if (c == '{') {
                property = new StringBuilder();
                inProperty = true;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }
}

