/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.support.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.server.support.TypeManager;
import org.apache.chemistry.opencmis.server.support.TypeValidator;
import org.apache.chemistry.opencmis.server.support.query.CmisQueryException;
import org.apache.chemistry.opencmis.server.support.query.CmisSelector;
import org.apache.chemistry.opencmis.server.support.query.ColumnReference;
import org.apache.chemistry.opencmis.server.support.query.FunctionReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryObject {
    private static final Logger LOG = LoggerFactory.getLogger(QueryObject.class);
    protected TypeManager typeMgr;
    protected final List<CmisSelector> selectReferences = new ArrayList<CmisSelector>();
    protected final List<CmisSelector> whereReferences = new ArrayList<CmisSelector>();
    protected final List<CmisSelector> joinReferences = new ArrayList<CmisSelector>();
    protected final Map<String, CmisSelector> colOrFuncAlias = new HashMap<String, CmisSelector>();
    protected final Map<String, String> froms = new LinkedHashMap<String, String>();
    protected String from = null;
    protected final List<JoinSpec> joinSpecs = new LinkedList<JoinSpec>();
    protected final Map<Integer, CmisSelector> columnReferences = new HashMap<Integer, CmisSelector>();
    protected final Map<Integer, String> typeReferences = new HashMap<Integer, String>();
    protected final List<SortSpec> sortSpecs = new ArrayList<SortSpec>();
    private String errorMessage;

    public QueryObject() {
    }

    public QueryObject(TypeManager tm) {
        this.typeMgr = tm;
    }

    public Map<Integer, CmisSelector> getColumnReferences() {
        return Collections.unmodifiableMap(this.columnReferences);
    }

    public CmisSelector getColumnReference(Integer token) {
        return this.columnReferences.get(token);
    }

    public String getTypeReference(Integer token) {
        return this.typeReferences.get(token);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<CmisSelector> getSelectReferences() {
        return this.selectReferences;
    }

    public void addSelectReference(Tree node, CmisSelector selRef) {
        this.selectReferences.add(selRef);
        this.columnReferences.put(node.getTokenStartIndex(), selRef);
    }

    public void addAlias(String aliasName, CmisSelector aliasRef) {
        LOG.debug("add alias: " + aliasName + " for: " + aliasRef);
        if (this.colOrFuncAlias.containsKey(aliasName)) {
            throw new CmisQueryException("You cannot use name " + aliasName + " more than once as alias in a select.");
        }
        aliasRef.setAliasName(aliasName);
        this.colOrFuncAlias.put(aliasName, aliasRef);
    }

    public CmisSelector getSelectAlias(String aliasName) {
        return this.colOrFuncAlias.get(aliasName);
    }

    public String addType(String aliasName, String typeQueryName) {
        try {
            LOG.debug("add alias: " + aliasName + " for: " + typeQueryName);
            if (this.froms.containsKey(aliasName)) {
                throw new CmisQueryException("You cannot use name " + aliasName + " more than once as alias in a from part.");
            }
            if (aliasName == null) {
                aliasName = typeQueryName;
            }
            this.froms.put(aliasName, typeQueryName);
            if (this.from == null) {
                this.from = aliasName;
            }
            return aliasName;
        }
        catch (CmisQueryException cqe) {
            this.errorMessage = cqe.getMessage();
            return null;
        }
    }

    public String getMainTypeAlias() {
        return this.from;
    }

    public Map<String, String> getTypes() {
        return Collections.unmodifiableMap(this.froms);
    }

    public String getTypeQueryName(String qualifier) {
        return this.froms.get(qualifier);
    }

    public TypeDefinition getTypeDefinitionFromQueryName(String queryName) {
        return this.typeMgr.getTypeByQueryName(queryName);
    }

    public TypeDefinition getParentType(TypeDefinition td) {
        String parentType = td.getParentTypeId();
        return parentType == null ? null : this.typeMgr.getTypeById(parentType).getTypeDefinition();
    }

    public TypeDefinition getParentType(String typeId) {
        TypeDefinition td = this.typeMgr.getTypeById(typeId).getTypeDefinition();
        String parentType = td == null ? null : td.getParentTypeId();
        return parentType == null ? null : this.typeMgr.getTypeById(parentType).getTypeDefinition();
    }

    public TypeDefinition getMainFromName() {
        String queryName = this.froms.values().iterator().next();
        TypeDefinition td = this.getTypeDefinitionFromQueryName(queryName);
        return td;
    }

    public Map<String, String> getRequestedPropertiesByAlias() {
        return this.getRequestedProperties(true);
    }

    @Deprecated
    public Map<String, String> getRequestedProperties() {
        return this.getRequestedProperties(false);
    }

    private Map<String, String> getRequestedProperties(boolean byAlias) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (CmisSelector sel : this.selectReferences) {
            String propDescr;
            if (!(sel instanceof ColumnReference)) continue;
            ColumnReference colRef = (ColumnReference)sel;
            String key = colRef.getPropertyId();
            if (null == key) {
                key = colRef.getPropertyQueryName();
            }
            String string = propDescr = colRef.getAliasName() == null ? colRef.getPropertyQueryName() : colRef.getAliasName();
            if (byAlias) {
                res.put(propDescr, key);
                continue;
            }
            res.put(key, propDescr);
        }
        return res;
    }

    @Deprecated
    public Map<String, String> getRequestedFuncs() {
        return this.getRequestedFuncs(false);
    }

    public Map<String, String> getRequestedFuncsByAlias() {
        return this.getRequestedFuncs(true);
    }

    private Map<String, String> getRequestedFuncs(boolean byAlias) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (CmisSelector sel : this.selectReferences) {
            String propDescr;
            if (!(sel instanceof FunctionReference)) continue;
            FunctionReference funcRef = (FunctionReference)sel;
            String string = propDescr = funcRef.getAliasName() == null ? funcRef.getName() : funcRef.getAliasName();
            if (byAlias) {
                res.put(propDescr, funcRef.getName());
                continue;
            }
            res.put(funcRef.getName(), propDescr);
        }
        return res;
    }

    public void addJoinReference(Tree node, CmisSelector reference) {
        this.columnReferences.put(node.getTokenStartIndex(), reference);
        this.joinReferences.add(reference);
    }

    public List<CmisSelector> getJoinReferences() {
        return Collections.unmodifiableList(this.joinReferences);
    }

    public void addJoin(String kind, String alias, boolean hasSpec) {
        JoinSpec join = new JoinSpec(kind, alias);
        if (hasSpec) {
            int n = this.joinReferences.size();
            ColumnReference onLeft = (ColumnReference)this.joinReferences.get(n - 2);
            ColumnReference onRight = (ColumnReference)this.joinReferences.get(n - 1);
            join.setSelectors(onLeft, onRight);
        }
        this.joinSpecs.add(join);
    }

    public List<JoinSpec> getJoins() {
        return this.joinSpecs;
    }

    public void addWhereReference(Tree node, CmisSelector reference) {
        LOG.debug("add node to where: " + System.identityHashCode(node));
        this.columnReferences.put(node.getTokenStartIndex(), reference);
        this.whereReferences.add(reference);
    }

    public List<CmisSelector> getWhereReferences() {
        return Collections.unmodifiableList(this.whereReferences);
    }

    public void addWhereTypeReference(Tree node, String qualifier) {
        if (node != null) {
            this.typeReferences.put(node.getTokenStartIndex(), qualifier);
        }
    }

    public List<SortSpec> getOrderBys() {
        return Collections.unmodifiableList(this.sortSpecs);
    }

    public void addSortCriterium(Tree node, ColumnReference colRef, boolean ascending) {
        LOG.debug("addSortCriterium: " + colRef + " ascending: " + ascending);
        this.columnReferences.put(node.getTokenStartIndex(), colRef);
        this.sortSpecs.add(new SortSpec(node.getTokenStartIndex(), ascending));
    }

    public boolean resolveTypes() {
        try {
            ColumnReference colRef;
            LOG.debug("First pass of query traversal is complete, resolving types");
            if (null == this.typeMgr) {
                return true;
            }
            for (CmisSelector cmisSelector : this.colOrFuncAlias.values()) {
                if (!(cmisSelector instanceof ColumnReference)) continue;
                colRef = (ColumnReference)cmisSelector;
                this.resolveTypeForAlias(colRef);
            }
            for (Integer n : this.columnReferences.keySet()) {
                CmisSelector selector = this.columnReferences.get(n);
                String key = selector.getName();
                if (!this.colOrFuncAlias.containsKey(key)) continue;
                CmisSelector resolvedReference = this.colOrFuncAlias.get(key);
                this.columnReferences.put(n, resolvedReference);
                if (this.whereReferences.remove(selector)) {
                    this.whereReferences.add(resolvedReference);
                }
                if (!this.joinReferences.remove(selector)) continue;
                this.joinReferences.add(resolvedReference);
            }
            for (CmisSelector cmisSelector : this.columnReferences.values()) {
                if (!(cmisSelector instanceof ColumnReference) || (colRef = (ColumnReference)cmisSelector).getTypeDefinition() != null) continue;
                if (colRef.getQualifier() == null) {
                    this.resolveTypeForColumnReference(colRef);
                    continue;
                }
                this.validateColumnReferenceAndResolveType(colRef);
            }
            for (Map.Entry entry : this.typeReferences.entrySet()) {
                Integer obj = (Integer)entry.getKey();
                String qualifier = (String)entry.getValue();
                String typeQueryName = this.getReferencedTypeQueryName(qualifier);
                if (typeQueryName == null) {
                    throw new CmisQueryException(qualifier + " is neither a type query name nor an alias.");
                }
                if (!typeQueryName.equals(qualifier)) continue;
                String alias = null;
                for (Map.Entry<String, String> e : this.froms.entrySet()) {
                    String q = e.getKey();
                    String tqn = e.getValue();
                    if (tqn.equals(q) || !typeQueryName.equals(tqn)) continue;
                    alias = q;
                    break;
                }
                if (alias == null) continue;
                this.typeReferences.put(obj, alias);
            }
            return true;
        }
        catch (CmisQueryException cqe) {
            this.errorMessage = cqe.getMessage();
            return false;
        }
    }

    protected void resolveTypeForAlias(ColumnReference colRef) {
        CmisSelector selector;
        String aliasName = colRef.getAliasName();
        if (this.colOrFuncAlias.containsKey(aliasName) && (selector = this.colOrFuncAlias.get(aliasName)) instanceof ColumnReference) {
            colRef = (ColumnReference)selector;
            if (colRef.getQualifier() == null) {
                this.resolveTypeForColumnReference(colRef);
            } else {
                this.validateColumnReferenceAndResolveType(colRef);
            }
        }
    }

    protected void resolveTypeForColumnReference(ColumnReference colRef) {
        String propName = colRef.getPropertyQueryName();
        boolean isStar = propName.equals("*");
        int noFound = 0;
        TypeDefinition tdFound = null;
        for (String typeQueryName : this.froms.values()) {
            TypeDefinition td = this.typeMgr.getTypeByQueryName(typeQueryName);
            if (null == td) {
                throw new CmisQueryException(typeQueryName + " is neither a type query name nor an alias.");
            }
            if (isStar) {
                ++noFound;
                tdFound = null;
                continue;
            }
            if (!TypeValidator.typeContainsPropertyWithQueryName(td, propName)) continue;
            ++noFound;
            tdFound = td;
        }
        if (noFound == 0) {
            throw new CmisQueryException(propName + " is not a property query name in any of the types in from ...");
        }
        if (noFound > 1 && !isStar) {
            throw new CmisQueryException(propName + " is not a unique property query name within the types in from ...");
        }
        if (null != tdFound) {
            this.validateColumnReferenceAndResolveType(tdFound, colRef);
        }
    }

    protected void validateColumnReferenceAndResolveType(ColumnReference colRef) {
        String typeQueryName = this.getReferencedTypeQueryName(colRef.getQualifier());
        TypeDefinition td = this.typeMgr.getTypeByQueryName(typeQueryName);
        if (null == td) {
            throw new CmisQueryException(colRef.getQualifier() + " is neither a type query name nor an alias.");
        }
        this.validateColumnReferenceAndResolveType(td, colRef);
    }

    protected void validateColumnReferenceAndResolveType(TypeDefinition td, ColumnReference colRef) {
        boolean hasProp = colRef.getPropertyQueryName().equals("*") ? true : TypeValidator.typeContainsPropertyWithQueryName(td, colRef.getPropertyQueryName());
        if (!hasProp) {
            throw new CmisQueryException(colRef.getPropertyQueryName() + " is not a valid property query name in type " + td.getId() + ".");
        }
        colRef.setTypeDefinition(this.typeMgr.getPropertyIdForQueryName(td, colRef.getPropertyQueryName()), td);
    }

    protected String getReferencedTypeQueryName(String qualifier) {
        String typeQueryName = this.froms.get(qualifier);
        if (null == typeQueryName) {
            String q = null;
            for (String tqn : this.froms.values()) {
                if (!qualifier.equals(tqn)) continue;
                if (q != null) {
                    throw new CmisQueryException(qualifier + " is an ambiguous type query name.");
                }
                q = tqn;
            }
            return q;
        }
        return typeQueryName;
    }

    public class SortSpec {
        public final boolean ascending;
        public final Integer colRefKey;

        public SortSpec(Integer key, boolean ascending) {
            this.colRefKey = key;
            this.ascending = ascending;
        }

        public CmisSelector getSelector() {
            return QueryObject.this.columnReferences.get(this.colRefKey);
        }

        public boolean isAscending() {
            return this.ascending;
        }
    }

    public static class JoinSpec {
        public final String kind;
        public final String alias;
        public ColumnReference onLeft;
        public ColumnReference onRight;

        public JoinSpec(String kind, String alias) {
            this.kind = kind;
            this.alias = alias;
        }

        public void setSelectors(ColumnReference onLeft, ColumnReference onRight) {
            this.onLeft = onLeft;
            this.onRight = onRight;
        }

        public String toString() {
            return "JoinReference(" + this.kind + "," + this.alias + "," + this.onLeft + "," + this.onRight + ")";
        }
    }
}

