/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr.impl;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.DocumentTypeDefinitionImpl;
import org.apache.chemistry.opencmis.jcr.JcrDocument;
import org.apache.chemistry.opencmis.jcr.JcrTypeManager;
import org.apache.chemistry.opencmis.jcr.JcrUnversionedDocument;
import org.apache.chemistry.opencmis.jcr.impl.DefaultDocumentIdentifierMap;
import org.apache.chemistry.opencmis.jcr.impl.DefaultDocumentTypeHandler;
import org.apache.chemistry.opencmis.jcr.query.IdentifierMap;

public class DefaultUnversionedDocumentTypeHandler
extends DefaultDocumentTypeHandler {
    public static final String DOCUMENT_UNVERSIONED_TYPE_ID = "cmis:unversioned-document";

    public String getTypeId() {
        return DOCUMENT_UNVERSIONED_TYPE_ID;
    }

    public TypeDefinition getTypeDefinition() {
        DocumentTypeDefinitionImpl unversionedDocument = new DocumentTypeDefinitionImpl();
        unversionedDocument.initialize(super.getTypeDefinition());
        unversionedDocument.setDescription("Unversioned document");
        unversionedDocument.setDisplayName("Unversioned document");
        unversionedDocument.setLocalName("Unversioned document");
        unversionedDocument.setIsQueryable(Boolean.valueOf(true));
        unversionedDocument.setQueryName(DOCUMENT_UNVERSIONED_TYPE_ID);
        unversionedDocument.setId(DOCUMENT_UNVERSIONED_TYPE_ID);
        unversionedDocument.setParentTypeId("cmis:document");
        unversionedDocument.setIsVersionable(Boolean.valueOf(false));
        unversionedDocument.setContentStreamAllowed(ContentStreamAllowed.ALLOWED);
        JcrTypeManager.addBasePropertyDefinitions((AbstractTypeDefinition)unversionedDocument);
        JcrTypeManager.addDocumentPropertyDefinitions(unversionedDocument);
        return unversionedDocument;
    }

    public IdentifierMap getIdentifierMap() {
        return new DefaultDocumentIdentifierMap(false);
    }

    public boolean canHandle(Node node) throws RepositoryException {
        return node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}file") && !node.isNodeType("{http://www.jcp.org/jcr/mix/1.0}simpleVersionable");
    }

    public JcrDocument getJcrNode(Node node) {
        return new JcrUnversionedDocument(node, this.typeManager, this.pathManager, this.typeHandlerManager);
    }
}

