/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractCmisService;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.jcr.JcrRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrService
extends AbstractCmisService {
    private final JcrRepository jcrRepository;
    private final Map<String, Session> sessions = new HashMap<String, Session>();
    private CallContext context;

    public JcrService(JcrRepository jcrRepository) {
        this.jcrRepository = jcrRepository;
    }

    public void close() {
        for (Session session : this.sessions.values()) {
            session.logout();
        }
        super.close();
    }

    public void setCallContext(CallContext context) {
        this.context = context;
    }

    public CallContext getCallContext() {
        return this.context;
    }

    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        return this.jcrRepository.getRepositoryInfo(this.login(repositoryId));
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        return this.jcrRepository.getRepositoryInfos(this.login(null));
    }

    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.jcrRepository.getTypeChildren(this.login(repositoryId), typeId, includePropertyDefinitions, maxItems, skipCount);
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        return this.jcrRepository.getTypeDefinition(this.login(repositoryId), typeId);
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        return this.jcrRepository.getTypesDescendants(this.login(repositoryId), typeId, depth, includePropertyDefinitions);
    }

    public ObjectInFolderList getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.jcrRepository.getChildren(this.login(repositoryId), folderId, filter, includeAllowableActions, includePathSegment, maxItems, skipCount, (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public List<ObjectInFolderContainer> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        return this.jcrRepository.getDescendants(this.login(repositoryId), folderId, depth, filter, includeAllowableActions, includePathSegment, (ObjectInfoHandler)this, this.context.isObjectInfoRequired(), false);
    }

    public ObjectData getFolderParent(String repositoryId, String folderId, String filter, ExtensionsData extension) {
        return this.jcrRepository.getFolderParent(this.login(repositoryId), folderId, filter, (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public List<ObjectInFolderContainer> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        return this.jcrRepository.getDescendants(this.login(repositoryId), folderId, depth, filter, includeAllowableActions, includePathSegment, (ObjectInfoHandler)this, this.context.isObjectInfoRequired(), true);
    }

    public List<ObjectParentData> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension) {
        return this.jcrRepository.getObjectParents(this.login(repositoryId), objectId, filter, includeAllowableActions, includeRelativePathSegment, (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public ObjectList getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.jcrRepository.getCheckedOutDocs(this.login(repositoryId), folderId, filter, orderBy, includeAllowableActions, maxItems, skipCount);
    }

    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.jcrRepository.createDocument(this.login(repositoryId), properties, folderId, contentStream, versioningState);
    }

    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.jcrRepository.createDocumentFromSource(this.login(repositoryId), sourceId, properties, folderId, versioningState);
    }

    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        this.jcrRepository.setContentStream(this.login(repositoryId), objectId, overwriteFlag, contentStream);
    }

    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        this.jcrRepository.setContentStream(this.login(repositoryId), objectId, true, null);
    }

    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        return this.jcrRepository.createFolder(this.login(repositoryId), properties, folderId);
    }

    public void deleteObjectOrCancelCheckOut(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.jcrRepository.deleteObject(this.login(repositoryId), objectId, allVersions);
    }

    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        return this.jcrRepository.deleteTree(this.login(repositoryId), folderId);
    }

    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        return this.jcrRepository.getAllowableActions(this.login(repositoryId), objectId);
    }

    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        return this.jcrRepository.getContentStream(this.login(repositoryId), objectId, offset, length);
    }

    public ObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        return this.jcrRepository.getObject(this.login(repositoryId), objectId, filter, includeAllowableActions, (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        return this.jcrRepository.getObjectByPath(this.login(repositoryId), path, filter, includeAllowableActions, includeAcl, (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        return this.jcrRepository.getProperties(this.login(repositoryId), objectId, filter, false, (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        this.jcrRepository.moveObject(this.login(repositoryId), objectId, targetFolderId, (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        this.jcrRepository.updateProperties(this.login(repositoryId), objectId, properties, (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public void checkOut(String repositoryId, Holder<String> objectId, ExtensionsData extension, Holder<Boolean> contentCopied) {
        this.jcrRepository.checkOut(this.login(repositoryId), objectId, contentCopied);
    }

    public void cancelCheckOut(String repositoryId, String objectId, ExtensionsData extension) {
        this.jcrRepository.cancelCheckout(this.login(repositoryId), objectId);
    }

    public void checkIn(String repositoryId, Holder<String> objectId, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.jcrRepository.checkIn(this.login(repositoryId), objectId, major, properties, contentStream, checkinComment);
    }

    public List<ObjectData> getAllVersions(String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension) {
        return this.jcrRepository.getAllVersions(this.login(repositoryId), versionSeriesId == null ? objectId : versionSeriesId, filter, includeAllowableActions, (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public ObjectData getObjectOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        return this.jcrRepository.getObject(this.login(repositoryId), versionSeriesId == null ? objectId : versionSeriesId, filter, includeAllowableActions, (ObjectInfoHandler)this, this.context.isObjectInfoRequired());
    }

    public Properties getPropertiesOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        ObjectData object = this.getObjectOfLatestVersion(repositoryId, objectId, versionSeriesId, major, filter, false, null, null, false, false, extension);
        return object.getProperties();
    }

    public ObjectList query(String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        return this.jcrRepository.query(this.login(repositoryId), statement, searchAllVersions, includeAllowableActions, maxItems, skipCount);
    }

    protected Session login(String workspaceName) {
        if (this.context == null) {
            throw new CmisRuntimeException("No user context!");
        }
        Session session = this.sessions.get(workspaceName);
        if (session == null) {
            String userName = this.context.getUsername();
            String password = this.context.getPassword();
            SimpleCredentials credentials = userName == null ? null : new SimpleCredentials(userName, password == null ? "".toCharArray() : password.toCharArray());
            session = this.jcrRepository.login((Credentials)credentials, workspaceName);
            this.sessions.put(workspaceName, session);
        }
        return session;
    }
}

