/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.chemistry.opencmis.jcr.util.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final Predicate<T> predicate;
    private T next;

    public FilterIterator(Iterator<T> iterator, Predicate<T> predicate) {
        this.iterator = iterator;
        this.predicate = predicate;
    }

    @Override
    public boolean hasNext() {
        while (this.next == null && this.iterator.hasNext()) {
            T e = this.iterator.next();
            if (!this.predicate.evaluate(e)) continue;
            this.next = e;
        }
        return this.next != null;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T e = this.next;
            this.next = null;
            return e;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

