/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr.util;

import java.util.Iterator;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.collections.iterators.SingletonIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Iterables {
    private Iterables() {
    }

    public static <T> Iterable<T> concat(final Iterable<T> it1, final Iterable<T> it2) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new IteratorChain(it1.iterator(), it2.iterator());
            }
        };
    }

    public static <T> Iterable<T> singleton(final T element) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new SingletonIterator(element);
            }
        };
    }

    public static <T> Iterable<T> empty() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return EmptyIterator.INSTANCE;
            }
        };
    }
}

