/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.jcr.JcrBinary;
import org.apache.chemistry.opencmis.jcr.JcrNode;
import org.apache.chemistry.opencmis.jcr.JcrTypeManager;
import org.apache.chemistry.opencmis.jcr.JcrVersionBase;
import org.apache.chemistry.opencmis.jcr.PathManager;
import org.apache.chemistry.opencmis.jcr.type.JcrTypeHandlerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JcrDocument
extends JcrNode {
    private static final Logger log = LoggerFactory.getLogger(JcrDocument.class);
    public static final String MIME_UNKNOWN = "application/octet-stream";

    protected JcrDocument(Node node, JcrTypeManager typeManager, PathManager pathManager, JcrTypeHandlerManager typeHandlerManager) {
        super(node, typeManager, pathManager, typeHandlerManager);
    }

    public boolean isDocumentCheckedOut() {
        try {
            return this.getNode().isCheckedOut();
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public ContentStream getContentStream() {
        try {
            Node contentNode = this.getContextNode();
            Property data = contentNode.getProperty("{http://www.jcp.org/jcr/1.0}data");
            ContentStreamImpl result = new ContentStreamImpl();
            result.setFileName(this.getNodeName());
            result.setLength(BigInteger.valueOf(data.getLength()));
            result.setMimeType(JcrDocument.getPropertyOrElse(contentNode, "{http://www.jcp.org/jcr/1.0}mimeType", MIME_UNKNOWN));
            result.setStream((InputStream)new BufferedInputStream(data.getBinary().getStream()));
            return result;
        }
        catch (PathNotFoundException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisObjectNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JcrNode setContentStream(ContentStream contentStream, boolean overwriteFlag) {
        try {
            boolean autoCheckout;
            Node contentNode = this.getNode().getNode("{http://www.jcp.org/jcr/1.0}content");
            Property data = contentNode.getProperty("{http://www.jcp.org/jcr/1.0}data");
            if (!overwriteFlag && data.getLength() != 0L) {
                throw new CmisContentAlreadyExistsException("Content already exists!");
            }
            JcrVersionBase jcrVersion = this.isVersionable() ? this.asVersion() : null;
            boolean bl = autoCheckout = jcrVersion != null && !jcrVersion.isCheckedOut();
            if (autoCheckout) {
                jcrVersion.checkout();
            }
            Binary binary = contentStream == null || contentStream.getStream() == null ? JcrBinary.EMPTY : new JcrBinary(new BufferedInputStream(contentStream.getStream()));
            try {
                contentNode.setProperty("{http://www.jcp.org/jcr/1.0}data", binary);
                if (contentStream != null && contentStream.getMimeType() != null) {
                    contentNode.setProperty("{http://www.jcp.org/jcr/1.0}mimeType", contentStream.getMimeType());
                }
            }
            finally {
                binary.dispose();
            }
            contentNode.getSession().save();
            if (autoCheckout) {
                return jcrVersion.checkin(null, null, "auto checkout");
            }
            if (jcrVersion != null) {
                return jcrVersion.getPwc();
            }
            return this;
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisStorageException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisStorageException(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract boolean isLatestVersion() throws RepositoryException;

    protected abstract boolean isMajorVersion() throws RepositoryException;

    protected abstract boolean isLatestMajorVersion() throws RepositoryException;

    protected abstract String getVersionLabel() throws RepositoryException;

    protected abstract boolean isCheckedOut() throws RepositoryException;

    protected abstract String getCheckedOutId() throws RepositoryException;

    protected abstract String getCheckedOutBy() throws RepositoryException;

    protected abstract String getCheckInComment() throws RepositoryException;

    protected boolean getIsImmutable() {
        return false;
    }

    @Override
    protected void compileProperties(PropertiesImpl properties, Set<String> filter, ObjectInfoImpl objectInfo) throws RepositoryException {
        super.compileProperties(properties, filter, objectInfo);
        objectInfo.setHasContent(true);
        objectInfo.setHasParent(true);
        objectInfo.setSupportsDescendants(false);
        objectInfo.setSupportsFolderTree(false);
        String typeId = this.getTypeIdInternal();
        Node contextNode = this.getContextNode();
        this.addPropertyBoolean(properties, typeId, filter, "cmis:isImmutable", this.getIsImmutable());
        long length = JcrDocument.getPropertyLength(contextNode, "{http://www.jcp.org/jcr/1.0}data");
        this.addPropertyInteger(properties, typeId, filter, "cmis:contentStreamLength", length);
        String mimeType = JcrDocument.getPropertyOrElse(contextNode, "{http://www.jcp.org/jcr/1.0}mimeType", MIME_UNKNOWN);
        this.addPropertyString(properties, typeId, filter, "cmis:contentStreamMimeType", mimeType);
        objectInfo.setContentType(mimeType);
        String fileName = this.getNodeName();
        this.addPropertyString(properties, typeId, filter, "cmis:contentStreamFileName", fileName);
        objectInfo.setFileName(fileName);
        this.addPropertyId(properties, typeId, filter, "cmis:contentStreamId", this.getObjectId() + "/stream");
        this.addPropertyBoolean(properties, typeId, filter, "cmis:isLatestVersion", this.isLatestVersion());
        this.addPropertyBoolean(properties, typeId, filter, "cmis:isMajorVersion", this.isMajorVersion());
        this.addPropertyBoolean(properties, typeId, filter, "cmis:isLatestMajorVersion", this.isLatestMajorVersion());
        this.addPropertyString(properties, typeId, filter, "cmis:versionLabel", this.getVersionLabel());
        this.addPropertyId(properties, typeId, filter, "cmis:versionSeriesId", this.getVersionSeriesId());
        this.addPropertyString(properties, typeId, filter, "cmis:checkinComment", this.getCheckInComment());
        boolean isCheckedOut = this.isCheckedOut();
        this.addPropertyBoolean(properties, typeId, filter, "cmis:isVersionSeriesCheckedOut", isCheckedOut);
        if (isCheckedOut) {
            this.addPropertyId(properties, typeId, filter, "cmis:versionSeriesCheckedOutId", this.getCheckedOutId());
            this.addPropertyString(properties, typeId, filter, "cmis:versionSeriesCheckedOutBy", this.getCheckedOutBy());
        }
    }

    @Override
    protected Set<Action> compileAllowableActions(Set<Action> aas) {
        Set<Action> result = super.compileAllowableActions(aas);
        JcrDocument.setAction(result, Action.CAN_GET_CONTENT_STREAM, true);
        JcrDocument.setAction(result, Action.CAN_SET_CONTENT_STREAM, true);
        JcrDocument.setAction(result, Action.CAN_DELETE_CONTENT_STREAM, true);
        JcrDocument.setAction(result, Action.CAN_GET_RENDITIONS, false);
        return result;
    }

    @Override
    protected BaseTypeId getBaseTypeId() {
        return BaseTypeId.CMIS_DOCUMENT;
    }
}

