/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathManager {
    private static final Logger log = LoggerFactory.getLogger(PathManager.class);
    public static final String CMIS_ROOT_ID = "[root]";
    public static final String CMIS_ROOT_PATH = "/";
    private final String jcrRootPath;

    public PathManager(String jcrRootPath) {
        this.jcrRootPath = PathManager.normalize(jcrRootPath);
    }

    public String getJcrRootPath() {
        return this.jcrRootPath;
    }

    public boolean isRoot(Node node) {
        try {
            return node.getPath().equals(this.jcrRootPath);
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public String getPath(Node node) {
        try {
            if (this.jcrRootPath.length() > node.getPath().length()) {
                throw new IllegalArgumentException("Node is not part of the hierarchy: " + node.getPath());
            }
            String path = node.getPath().substring(this.jcrRootPath.length());
            return path.startsWith(CMIS_ROOT_PATH) ? path : '/' + path;
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isRoot(String cmisPath) {
        return CMIS_ROOT_PATH.equals(cmisPath);
    }

    public static boolean isAbsolute(String cmisPath) {
        return cmisPath.startsWith(CMIS_ROOT_PATH);
    }

    public static String createCmisPath(String cmisPath, String child) {
        return cmisPath.length() > 0 && cmisPath.charAt(cmisPath.length() - 1) == '/' ? cmisPath + child : cmisPath + '/' + child;
    }

    public static String relativize(String prefix, String cmisPath) {
        if (cmisPath.startsWith(prefix)) {
            return cmisPath.substring(prefix.length());
        }
        throw new IllegalArgumentException(prefix + " is not a prefix of " + cmisPath);
    }

    private static String normalize(String path) {
        if (path == null || path.length() == 0) {
            return CMIS_ROOT_PATH;
        }
        if (!path.startsWith(CMIS_ROOT_PATH)) {
            throw new CmisInvalidArgumentException("Root path must be absolute. Got: " + path);
        }
        while (path.length() > 1 && path.endsWith(CMIS_ROOT_PATH)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }
}

