/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr.type;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.jcr.JcrNode;
import org.apache.chemistry.opencmis.jcr.JcrTypeManager;
import org.apache.chemistry.opencmis.jcr.PathManager;
import org.apache.chemistry.opencmis.jcr.query.IdentifierMap;
import org.apache.chemistry.opencmis.jcr.type.JcrDocumentTypeHandler;
import org.apache.chemistry.opencmis.jcr.type.JcrFolderTypeHandler;
import org.apache.chemistry.opencmis.jcr.type.JcrTypeHandler;
import org.apache.chemistry.opencmis.jcr.util.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrTypeHandlerManager {
    private static final Logger log = LoggerFactory.getLogger(JcrTypeHandlerManager.class);
    private final PathManager pathManager;
    private final JcrTypeManager typeManager;
    private final Map<String, JcrTypeHandler> typeHandlers = new HashMap<String, JcrTypeHandler>();

    public JcrTypeHandlerManager(PathManager pathManager, JcrTypeManager typeManager) {
        this.pathManager = pathManager;
        this.typeManager = typeManager;
    }

    public void addHandler(JcrTypeHandler typeHandler) {
        if (this.typeManager.addType(typeHandler.getTypeDefinition())) {
            this.typeHandlers.put(typeHandler.getTypeId(), typeHandler);
            typeHandler.initialize(this.pathManager, this.typeManager, this);
        }
    }

    public JcrTypeHandler getTypeHandler(String typeId) {
        JcrTypeHandler typeHandler = this.typeHandlers.get(typeId);
        if (typeHandler == null) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
        }
        return typeHandler;
    }

    public JcrFolderTypeHandler getFolderTypeHandler(String typeId) {
        JcrTypeHandler typeHandler = this.getTypeHandler(typeId);
        if (!(typeHandler instanceof JcrFolderTypeHandler)) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' is not a folder!");
        }
        return (JcrFolderTypeHandler)typeHandler;
    }

    public JcrDocumentTypeHandler getDocumentTypeHandler(String typeId) {
        JcrTypeHandler typeHandler = this.getTypeHandler(typeId);
        if (!(typeHandler instanceof JcrDocumentTypeHandler)) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' is not a document!");
        }
        return (JcrDocumentTypeHandler)typeHandler;
    }

    public Predicate<Node> getNodePredicate() {
        return new Predicate<Node>(){

            @Override
            public boolean evaluate(Node node) {
                try {
                    for (JcrTypeHandler typeHandler : JcrTypeHandlerManager.this.typeHandlers.values()) {
                        if (!typeHandler.canHandle(node)) continue;
                        return true;
                    }
                    return false;
                }
                catch (RepositoryException e) {
                    log.debug(e.getMessage(), (Throwable)e);
                    throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
                }
            }
        };
    }

    public IdentifierMap getIdentifierMap(String typeId) {
        JcrTypeHandler typeHandler = this.getTypeHandler(typeId);
        IdentifierMap identifierMap = typeHandler.getIdentifierMap();
        if (identifierMap == null) {
            throw new CmisRuntimeException("Not supported: query for type " + typeId);
        }
        return identifierMap;
    }

    public JcrNode create(Node node) {
        try {
            for (JcrTypeHandler typeHandler : this.typeHandlers.values()) {
                if (!typeHandler.canHandle(node)) continue;
                return typeHandler.getJcrNode(node);
            }
            throw new CmisObjectNotFoundException("No object type for object '" + node.getIdentifier() + "'");
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisObjectNotFoundException(e.getMessage(), (Throwable)e);
        }
    }
}

