/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.CapabilityAcl;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.CapabilityContentStreamUpdates;
import org.apache.chemistry.opencmis.commons.enums.CapabilityJoin;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.apache.chemistry.opencmis.commons.enums.CapabilityRenditions;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectParentDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryCapabilitiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryInfoImpl;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.jcr.JcrConverter;
import org.apache.chemistry.opencmis.jcr.JcrDocument;
import org.apache.chemistry.opencmis.jcr.JcrFolder;
import org.apache.chemistry.opencmis.jcr.JcrNode;
import org.apache.chemistry.opencmis.jcr.JcrPrivateWorkingCopy;
import org.apache.chemistry.opencmis.jcr.JcrTypeManager;
import org.apache.chemistry.opencmis.jcr.JcrVersion;
import org.apache.chemistry.opencmis.jcr.JcrVersionBase;
import org.apache.chemistry.opencmis.jcr.PathManager;
import org.apache.chemistry.opencmis.jcr.PropertyHelper;
import org.apache.chemistry.opencmis.jcr.query.QueryTranslator;
import org.apache.chemistry.opencmis.jcr.type.JcrDocumentTypeHandler;
import org.apache.chemistry.opencmis.jcr.type.JcrFolderTypeHandler;
import org.apache.chemistry.opencmis.jcr.type.JcrTypeHandlerManager;
import org.apache.chemistry.opencmis.jcr.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrRepository {
    private static final Logger log = LoggerFactory.getLogger(JcrRepository.class);
    protected final Repository repository;
    protected final JcrTypeManager typeManager;
    protected final PathManager pathManager;
    protected final JcrTypeHandlerManager typeHandlerManager;

    public JcrRepository(Repository repository, PathManager pathManager, JcrTypeManager typeManager, JcrTypeHandlerManager typeHandlerManager) {
        this.repository = repository;
        this.typeManager = typeManager;
        this.typeHandlerManager = typeHandlerManager;
        this.pathManager = pathManager;
    }

    public Session login(Credentials credentials, String workspaceName) {
        try {
            return this.repository.login(credentials, workspaceName);
        }
        catch (LoginException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisPermissionDeniedException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchWorkspaceException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisObjectNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public RepositoryInfo getRepositoryInfo(Session session) {
        log.debug("getRepositoryInfo");
        return this.compileRepositoryInfo(session.getWorkspace().getName());
    }

    public List<RepositoryInfo> getRepositoryInfos(Session session) {
        try {
            ArrayList<RepositoryInfo> infos = new ArrayList<RepositoryInfo>();
            for (String wspName : session.getWorkspace().getAccessibleWorkspaceNames()) {
                infos.add(this.compileRepositoryInfo(wspName));
            }
            return infos;
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public TypeDefinitionList getTypeChildren(Session session, String typeId, boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount) {
        log.debug("getTypesChildren");
        return this.typeManager.getTypeChildren(typeId, includePropertyDefinitions, maxItems, skipCount);
    }

    public TypeDefinition getTypeDefinition(Session session, String typeId) {
        log.debug("getTypeDefinition");
        TypeDefinition type = this.typeManager.getType(typeId);
        if (type == null) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
        }
        return JcrTypeManager.copyTypeDefinition(type);
    }

    public List<TypeDefinitionContainer> getTypesDescendants(Session session, String typeId, BigInteger depth, Boolean includePropertyDefinitions) {
        log.debug("getTypesDescendants");
        return this.typeManager.getTypesDescendants(typeId, depth, includePropertyDefinitions);
    }

    public String createDocument(Session session, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState) {
        log.debug("createDocument");
        if (properties == null || properties.getProperties() == null) {
            throw new CmisInvalidArgumentException("Properties must be set!");
        }
        String typeId = PropertyHelper.getTypeId(properties);
        TypeDefinition type = this.typeManager.getType(typeId);
        if (type == null) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
        }
        boolean isVersionable = JcrTypeManager.isVersionable(type);
        if (!isVersionable && versioningState != VersioningState.NONE) {
            throw new CmisConstraintException("Versioning not supported for " + typeId);
        }
        if (isVersionable && versioningState == VersioningState.NONE) {
            throw new CmisConstraintException("Versioning required for " + typeId);
        }
        String name = PropertyHelper.getStringProperty(properties, "cmis:name");
        JcrFolder parent = this.getJcrNode(session, folderId).asFolder();
        JcrDocumentTypeHandler typeHandler = this.typeHandlerManager.getDocumentTypeHandler(typeId);
        JcrNode jcrNode = typeHandler.createDocument(parent, JcrConverter.toJcrName(name), properties, contentStream, versioningState);
        return jcrNode.getId();
    }

    public String createDocumentFromSource(Session session, String sourceId, Properties properties, String folderId, VersioningState versioningState) {
        log.debug("createDocumentFromSource");
        JcrFolder parent = this.getJcrNode(session, folderId).asFolder();
        JcrDocument source = this.getJcrNode(session, sourceId).asDocument();
        boolean isVersionable = source.isVersionable();
        if (!isVersionable && versioningState != VersioningState.NONE) {
            throw new CmisConstraintException("Versioning not supported for " + sourceId);
        }
        if (isVersionable && versioningState == VersioningState.NONE) {
            throw new CmisConstraintException("Versioning required for " + sourceId);
        }
        JcrNode jcrNode = parent.addNodeFromSource(source, properties);
        return jcrNode.getId();
    }

    public String createFolder(Session session, Properties properties, String folderId) {
        log.debug("createFolder");
        if (properties == null || properties.getProperties() == null) {
            throw new CmisInvalidArgumentException("Properties must be set!");
        }
        String typeId = PropertyHelper.getTypeId(properties);
        TypeDefinition type = this.typeManager.getType(typeId);
        if (type == null) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
        }
        String name = PropertyHelper.getStringProperty(properties, "cmis:name");
        JcrFolder parent = this.getJcrNode(session, folderId).asFolder();
        JcrFolderTypeHandler typeHandler = this.typeHandlerManager.getFolderTypeHandler(typeId);
        JcrFolder jcrNode = typeHandler.createFolder(parent, JcrConverter.toJcrName(name), properties);
        return jcrNode.getId();
    }

    public ObjectData moveObject(Session session, Holder<String> objectId, String targetFolderId, ObjectInfoHandler objectInfos, boolean requiresObjectInfo) {
        log.debug("moveObject");
        if (objectId == null || objectId.getValue() == null) {
            throw new CmisInvalidArgumentException("Id is not valid!");
        }
        JcrNode jcrNode = this.getJcrNode(session, (String)objectId.getValue());
        JcrFolder parent = this.getJcrNode(session, targetFolderId).asFolder();
        jcrNode = jcrNode.move(parent);
        objectId.setValue((Object)jcrNode.getId());
        return jcrNode.compileObjectType(null, false, objectInfos, requiresObjectInfo);
    }

    public void setContentStream(Session session, Holder<String> objectId, Boolean overwriteFlag, ContentStream contentStream) {
        log.debug("setContentStream or deleteContentStream");
        if (objectId == null || objectId.getValue() == null) {
            throw new CmisInvalidArgumentException("Id is not valid!");
        }
        JcrDocument jcrDocument = this.getJcrNode(session, (String)objectId.getValue()).asDocument();
        String id = jcrDocument.setContentStream(contentStream, Boolean.TRUE.equals(overwriteFlag)).getId();
        objectId.setValue((Object)id);
    }

    public void deleteObject(Session session, String objectId, Boolean allVersions) {
        log.debug("deleteObject");
        JcrNode jcrNode = this.getJcrNode(session, objectId);
        try {
            boolean isPwc = jcrNode.isVersionable() && JcrPrivateWorkingCopy.isPwc(jcrNode.asVersion().getVersionLabel());
            jcrNode.delete(Boolean.TRUE.equals(allVersions), isPwc);
        }
        catch (RepositoryException rex) {
            log.debug(rex.getMessage(), (Throwable)rex);
            throw new CmisRuntimeException(rex.getMessage(), (Throwable)rex);
        }
    }

    public FailedToDeleteData deleteTree(Session session, String folderId) {
        log.debug("deleteTree");
        JcrFolder jcrFolder = this.getJcrNode(session, folderId).asFolder();
        return jcrFolder.deleteTree();
    }

    public ObjectData updateProperties(Session session, Holder<String> objectId, Properties properties, ObjectInfoHandler objectInfos, boolean objectInfoRequired) {
        log.debug("updateProperties");
        if (objectId == null) {
            throw new CmisInvalidArgumentException("Id is not valid!");
        }
        JcrNode jcrNode = this.getJcrNode(session, (String)objectId.getValue());
        String id = jcrNode.updateProperties(properties).getId();
        objectId.setValue((Object)id);
        return jcrNode.compileObjectType(null, false, objectInfos, objectInfoRequired);
    }

    public ObjectData getObject(Session session, String objectId, String filter, Boolean includeAllowableActions, ObjectInfoHandler objectInfos, boolean requiresObjectInfo) {
        log.debug("getObject");
        if (objectId == null) {
            throw new CmisInvalidArgumentException("Object Id must be set.");
        }
        JcrNode jcrNode = this.getJcrNode(session, objectId);
        return jcrNode.compileObjectType(JcrRepository.splitFilter(filter), includeAllowableActions, objectInfos, requiresObjectInfo);
    }

    public Properties getProperties(Session session, String objectId, String filter, Boolean includeAllowableActions, ObjectInfoHandler objectInfos, boolean requiresObjectInfo) {
        ObjectData object = this.getObject(session, objectId, filter, includeAllowableActions, objectInfos, requiresObjectInfo);
        return object.getProperties();
    }

    public AllowableActions getAllowableActions(Session session, String objectId) {
        log.debug("getAllowableActions");
        JcrNode jcrNode = this.getJcrNode(session, objectId);
        return jcrNode.getAllowableActions();
    }

    public ContentStream getContentStream(Session session, String objectId, BigInteger offset, BigInteger length) {
        log.debug("getContentStream");
        if (offset != null || length != null) {
            throw new CmisInvalidArgumentException("Offset and Length are not supported!");
        }
        JcrDocument jcrDocument = this.getJcrNode(session, objectId).asDocument();
        return jcrDocument.getContentStream();
    }

    public ObjectInFolderList getChildren(Session session, String folderId, String filter, Boolean includeAllowableActions, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ObjectInfoHandler objectInfos, boolean requiresObjectInfo) {
        int max;
        int skip;
        log.debug("getChildren");
        int n = skip = skipCount == null ? 0 : skipCount.intValue();
        if (skip < 0) {
            skip = 0;
        }
        int n2 = max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
        if (max < 0) {
            max = Integer.MAX_VALUE;
        }
        JcrFolder jcrFolder = this.getJcrNode(session, folderId).asFolder();
        if (requiresObjectInfo) {
            jcrFolder.compileObjectType(null, false, objectInfos, requiresObjectInfo);
        }
        ObjectInFolderListImpl result = new ObjectInFolderListImpl();
        result.setObjects(new ArrayList());
        result.setHasMoreItems(Boolean.valueOf(false));
        int count = 0;
        Set<String> splitFilter = JcrRepository.splitFilter(filter);
        Iterator<JcrNode> childNodes = jcrFolder.getNodes();
        while (childNodes.hasNext()) {
            JcrNode child = childNodes.next();
            ++count;
            if (skip > 0) {
                --skip;
                continue;
            }
            if (result.getObjects().size() >= max) {
                result.setHasMoreItems(Boolean.valueOf(true));
                continue;
            }
            ObjectInFolderDataImpl objectInFolder = new ObjectInFolderDataImpl();
            objectInFolder.setObject(child.compileObjectType(splitFilter, includeAllowableActions, objectInfos, requiresObjectInfo));
            if (Boolean.TRUE.equals(includePathSegment)) {
                objectInFolder.setPathSegment(child.getName());
            }
            result.getObjects().add(objectInFolder);
        }
        result.setNumItems(BigInteger.valueOf(count));
        return result;
    }

    public List<ObjectInFolderContainer> getDescendants(Session session, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, Boolean includePathSegment, ObjectInfoHandler objectInfos, boolean requiresObjectInfo, boolean foldersOnly) {
        int d;
        log.debug("getDescendants or getFolderTree");
        int n = d = depth == null ? 2 : depth.intValue();
        if (d == 0) {
            throw new CmisInvalidArgumentException("Depth must not be 0!");
        }
        if (d < -1) {
            d = -1;
        }
        JcrFolder jcrFolder = this.getJcrNode(session, folderId).asFolder();
        if (requiresObjectInfo) {
            jcrFolder.compileObjectType(null, false, objectInfos, requiresObjectInfo);
        }
        ArrayList<ObjectInFolderContainer> result = new ArrayList<ObjectInFolderContainer>();
        JcrRepository.gatherDescendants(jcrFolder, result, foldersOnly, d, JcrRepository.splitFilter(filter), includeAllowableActions, includePathSegment, objectInfos, requiresObjectInfo);
        return result;
    }

    public ObjectData getFolderParent(Session session, String folderId, String filter, ObjectInfoHandler objectInfos, boolean requiresObjectInfo) {
        List<ObjectParentData> parents = this.getObjectParents(session, folderId, filter, false, false, objectInfos, requiresObjectInfo);
        if (parents.isEmpty()) {
            throw new CmisInvalidArgumentException("The root folder has no parent!");
        }
        return parents.get(0).getObject();
    }

    public List<ObjectParentData> getObjectParents(Session session, String objectId, String filter, Boolean includeAllowableActions, Boolean includeRelativePathSegment, ObjectInfoHandler objectInfos, boolean requiresObjectInfo) {
        log.debug("getObjectParents");
        JcrNode jcrNode = this.getJcrNode(session, objectId);
        if (jcrNode.isRoot()) {
            return Collections.emptyList();
        }
        if (requiresObjectInfo) {
            jcrNode.compileObjectType(null, false, objectInfos, requiresObjectInfo);
        }
        JcrFolder parent = jcrNode.getParent();
        ObjectData object = parent.compileObjectType(JcrRepository.splitFilter(filter), includeAllowableActions, objectInfos, requiresObjectInfo);
        ObjectParentDataImpl result = new ObjectParentDataImpl();
        result.setObject(object);
        if (Boolean.TRUE.equals(includeRelativePathSegment)) {
            result.setRelativePathSegment(parent.getName());
        }
        return Collections.singletonList(result);
    }

    public ObjectData getObjectByPath(Session session, String folderPath, String filter, boolean includeAllowableActions, boolean includeACL, ObjectInfoHandler objectInfos, boolean requiresObjectInfo) {
        JcrNode jcrNode;
        log.debug("getObjectByPath");
        if (folderPath == null || !PathManager.isAbsolute(folderPath)) {
            throw new CmisInvalidArgumentException("Invalid folder path!");
        }
        JcrNode root = this.getJcrNode(session, "[root]");
        if (PathManager.isRoot(folderPath)) {
            jcrNode = root;
        } else {
            String path = PathManager.relativize("/", folderPath);
            jcrNode = root.getNode(path);
        }
        return jcrNode.compileObjectType(JcrRepository.splitFilter(filter), includeAllowableActions, objectInfos, requiresObjectInfo);
    }

    public ObjectList getCheckedOutDocs(Session session, String folderId, String filter, String orderBy, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount) {
        int max;
        int skip;
        log.debug("getCheckedOutDocs");
        int n = skip = skipCount == null ? 0 : skipCount.intValue();
        if (skip < 0) {
            skip = 0;
        }
        int n2 = max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
        if (max < 0) {
            max = Integer.MAX_VALUE;
        }
        try {
            String xPath = "/*[jcr:isCheckedOut='true' and (not(@jcr:createdBy) or @jcr:createdBy='" + session.getUserID() + "')]";
            if (folderId != null) {
                JcrFolder jcrFolder = this.getJcrNode(session, folderId).asFolder();
                String path = jcrFolder.getNode().getPath();
                if ("/".equals(path)) {
                    path = "";
                }
                xPath = '/' + Util.escape(path) + xPath;
            } else {
                xPath = '/' + xPath;
            }
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(xPath, "xpath");
            QueryResult queryResult = query.execute();
            ObjectListImpl result = new ObjectListImpl();
            result.setObjects(new ArrayList());
            result.setHasMoreItems(Boolean.valueOf(false));
            Set<String> splitFilter = JcrRepository.splitFilter(filter);
            int count = 0;
            NodeIterator nodes = queryResult.getNodes();
            while (nodes.hasNext()) {
                Node node = nodes.nextNode();
                JcrNode jcrNode = this.typeHandlerManager.create(node);
                if (!jcrNode.isVersionable()) continue;
                ++count;
                if (skip > 0) {
                    --skip;
                    continue;
                }
                if (result.getObjects().size() >= max) {
                    result.setHasMoreItems(Boolean.valueOf(true));
                    continue;
                }
                JcrPrivateWorkingCopy jcrVersion = jcrNode.asVersion().getPwc();
                ObjectData objectData = jcrVersion.compileObjectType(splitFilter, includeAllowableActions, null, false);
                result.getObjects().add(objectData);
            }
            result.setNumItems(BigInteger.valueOf(count));
            return result;
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public void checkOut(Session session, Holder<String> objectId, Holder<Boolean> contentCopied) {
        log.debug("checkout");
        if (objectId == null || objectId.getValue() == null) {
            throw new CmisInvalidArgumentException("Object Id must be set.");
        }
        JcrNode jcrNode = this.getJcrNode(session, (String)objectId.getValue());
        if (!jcrNode.isVersionable()) {
            throw new CmisUpdateConflictException("Not a version: " + jcrNode);
        }
        JcrPrivateWorkingCopy pwc = jcrNode.asVersion().checkout();
        objectId.setValue((Object)pwc.getId());
        if (contentCopied != null) {
            contentCopied.setValue((Object)true);
        }
    }

    public void cancelCheckout(Session session, String objectId) {
        log.debug("cancelCheckout");
        if (objectId == null) {
            throw new CmisInvalidArgumentException("Object Id must be set.");
        }
        JcrNode jcrNode = this.getJcrNode(session, objectId);
        if (!jcrNode.isVersionable()) {
            throw new CmisUpdateConflictException("Not a version: " + jcrNode);
        }
        jcrNode.asVersion().cancelCheckout();
    }

    public void checkIn(Session session, Holder<String> objectId, Boolean major, Properties properties, ContentStream contentStream, String checkinComment) {
        JcrNode jcrNode;
        log.debug("checkin");
        if (objectId == null || objectId.getValue() == null) {
            throw new CmisInvalidArgumentException("Object Id must be set.");
        }
        try {
            jcrNode = this.getJcrNode(session, (String)objectId.getValue());
        }
        catch (CmisObjectNotFoundException e) {
            throw new CmisUpdateConflictException(e.getCause().getMessage(), e.getCause());
        }
        if (!jcrNode.isVersionable()) {
            throw new CmisUpdateConflictException("Not a version: " + jcrNode);
        }
        JcrVersion checkedIn = jcrNode.asVersion().checkin(properties, contentStream, checkinComment);
        objectId.setValue((Object)checkedIn.getId());
    }

    public List<ObjectData> getAllVersions(Session session, String objectId, String filter, Boolean includeAllowableActions, ObjectInfoHandler objectInfos, boolean requiresObjectInfo) {
        log.debug("getAllVersions");
        if (objectId == null) {
            throw new CmisInvalidArgumentException("Object Id must be set.");
        }
        Set<String> splitFilter = JcrRepository.splitFilter(filter);
        JcrNode jcrNode = this.getJcrNode(session, objectId);
        if (jcrNode.isVersionable()) {
            ObjectData objectData;
            JcrVersionBase jcrVersion = jcrNode.asVersion();
            Iterator<JcrVersion> versions = jcrVersion.getVersions();
            if (versions.hasNext()) {
                versions.next();
            }
            ArrayList<ObjectData> allVersions = new ArrayList<ObjectData>();
            while (versions.hasNext()) {
                JcrVersion version = versions.next();
                objectData = version.compileObjectType(splitFilter, includeAllowableActions, objectInfos, requiresObjectInfo);
                allVersions.add(objectData);
            }
            if (jcrVersion.isDocumentCheckedOut()) {
                JcrPrivateWorkingCopy pwc = jcrVersion.getPwc();
                objectData = pwc.compileObjectType(splitFilter, includeAllowableActions, objectInfos, requiresObjectInfo);
                allVersions.add(objectData);
            }
            Collections.reverse(allVersions);
            return allVersions;
        }
        ObjectData objectData = jcrNode.compileObjectType(splitFilter, includeAllowableActions, objectInfos, requiresObjectInfo);
        return Collections.singletonList(objectData);
    }

    public ObjectList query(final Session session, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount) {
        int max;
        int skip;
        log.debug("query");
        if (searchAllVersions.booleanValue()) {
            throw new CmisNotSupportedException("Not supported: query for all versions");
        }
        int n = skip = skipCount == null ? 0 : skipCount.intValue();
        if (skip < 0) {
            skip = 0;
        }
        int n2 = max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
        if (max < 0) {
            max = Integer.MAX_VALUE;
        }
        QueryTranslator queryTranslator = new QueryTranslator(this.typeManager){

            protected String jcrPathFromId(String id) {
                try {
                    JcrFolder folder = JcrRepository.this.getJcrNode(session, id).asFolder();
                    String path = folder.getNode().getPath();
                    return Util.escape(path);
                }
                catch (RepositoryException e) {
                    log.debug(e.getMessage(), (Throwable)e);
                    throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
                }
            }

            protected String jcrPathFromCol(TypeDefinition fromType, String name) {
                return JcrRepository.this.typeHandlerManager.getIdentifierMap(fromType.getId()).jcrPathFromCol(name);
            }

            protected String jcrTypeName(TypeDefinition fromType) {
                return JcrRepository.this.typeHandlerManager.getIdentifierMap(fromType.getId()).jcrTypeName();
            }

            protected String jcrTypeCondition(TypeDefinition fromType) {
                return JcrRepository.this.typeHandlerManager.getIdentifierMap(fromType.getId()).jcrTypeCondition();
            }
        };
        String xPath = queryTranslator.translateToXPath(statement);
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(xPath, "xpath");
            if (skip > 0) {
                query.setOffset((long)skip);
            }
            if (max < Integer.MAX_VALUE) {
                query.setLimit((long)(max + 1));
            }
            QueryResult queryResult = query.execute();
            ObjectListImpl result = new ObjectListImpl();
            result.setObjects(new ArrayList());
            result.setHasMoreItems(Boolean.valueOf(false));
            int count = 0;
            NodeIterator nodes = queryResult.getNodes();
            while (nodes.hasNext() && result.getObjects().size() < max) {
                Node node = nodes.nextNode();
                JcrNode jcrNode = this.typeHandlerManager.create(node);
                ++count;
                if (jcrNode.isVersionable() && jcrNode.asVersion().isCheckedOut()) {
                    jcrNode = jcrNode.asVersion().getPwc();
                }
                ObjectData objectData = jcrNode.compileObjectType(null, includeAllowableActions, null, false);
                result.getObjects().add(objectData);
            }
            result.setHasMoreItems(Boolean.valueOf(nodes.hasNext()));
            result.setNumItems(BigInteger.valueOf(count));
            return result;
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    protected RepositoryInfo compileRepositoryInfo(String repositoryId) {
        RepositoryInfoImpl fRepositoryInfo = new RepositoryInfoImpl();
        fRepositoryInfo.setId(repositoryId);
        fRepositoryInfo.setName(this.getRepositoryName());
        fRepositoryInfo.setDescription(this.getRepositoryDescription());
        fRepositoryInfo.setCmisVersionSupported("1.0");
        fRepositoryInfo.setProductName("OpenCMIS JCR");
        fRepositoryInfo.setProductVersion("0.3");
        fRepositoryInfo.setVendorName("OpenCMIS");
        fRepositoryInfo.setRootFolder("[root]");
        fRepositoryInfo.setThinClientUri("");
        RepositoryCapabilitiesImpl capabilities = new RepositoryCapabilitiesImpl();
        capabilities.setCapabilityAcl(CapabilityAcl.NONE);
        capabilities.setAllVersionsSearchable(Boolean.valueOf(false));
        capabilities.setCapabilityJoin(CapabilityJoin.NONE);
        capabilities.setSupportsMultifiling(Boolean.valueOf(false));
        capabilities.setSupportsUnfiling(Boolean.valueOf(false));
        capabilities.setSupportsVersionSpecificFiling(Boolean.valueOf(false));
        capabilities.setIsPwcSearchable(Boolean.valueOf(false));
        capabilities.setIsPwcUpdatable(Boolean.valueOf(true));
        capabilities.setCapabilityQuery(CapabilityQuery.BOTHCOMBINED);
        capabilities.setCapabilityChanges(CapabilityChanges.OBJECTIDSONLY);
        capabilities.setCapabilityContentStreamUpdates(CapabilityContentStreamUpdates.ANYTIME);
        capabilities.setSupportsGetDescendants(Boolean.valueOf(true));
        capabilities.setSupportsGetFolderTree(Boolean.valueOf(true));
        capabilities.setCapabilityRendition(CapabilityRenditions.NONE);
        fRepositoryInfo.setCapabilities((RepositoryCapabilities)capabilities);
        return fRepositoryInfo;
    }

    protected String getRepositoryName() {
        return this.repository.getDescriptor("jcr.repository.name");
    }

    protected String getRepositoryDescription() {
        StringBuilder description = new StringBuilder();
        for (String key : this.repository.getDescriptorKeys()) {
            description.append(key).append('=').append(this.repository.getDescriptor(key)).append('\n');
        }
        return description.toString();
    }

    protected JcrNode getJcrNode(Session session, String id) {
        try {
            if (id == null || id.length() == 0) {
                throw new CmisInvalidArgumentException("Null or empty id");
            }
            if (id.equals("[root]")) {
                return this.typeHandlerManager.create(this.getRootNode(session));
            }
            Node node = session.getNodeByIdentifier(id);
            JcrNode jcrNode = this.typeHandlerManager.create(node);
            if (!jcrNode.isVersionable()) {
                return jcrNode;
            }
            JcrVersionBase versionNode = jcrNode.asVersion();
            if (JcrPrivateWorkingCopy.denotesPwc(versionNode.getVersionLabel())) {
                return versionNode.getPwc();
            }
            JcrVersion version = versionNode.getVersion(((JcrVersion)versionNode).getVersionName());
            return version;
        }
        catch (ItemNotFoundException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisObjectNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    protected Node getRootNode(Session session) {
        try {
            return session.getNode(this.pathManager.getJcrRootPath());
        }
        catch (PathNotFoundException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisObjectNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ItemNotFoundException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisObjectNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private static void gatherDescendants(JcrFolder jcrFolder, List<ObjectInFolderContainer> list, boolean foldersOnly, int depth, Set<String> filter, Boolean includeAllowableActions, Boolean includePathSegments, ObjectInfoHandler objectInfos, boolean requiresObjectInfo) {
        Iterator<JcrNode> childNodes = jcrFolder.getNodes();
        while (childNodes.hasNext()) {
            JcrNode child = childNodes.next();
            if (foldersOnly && !child.isFolder()) continue;
            ObjectInFolderDataImpl objectInFolder = new ObjectInFolderDataImpl();
            objectInFolder.setObject(child.compileObjectType(filter, includeAllowableActions, objectInfos, requiresObjectInfo));
            if (Boolean.TRUE.equals(includePathSegments)) {
                objectInFolder.setPathSegment(child.getName());
            }
            ObjectInFolderContainerImpl container = new ObjectInFolderContainerImpl();
            container.setObject((ObjectInFolderData)objectInFolder);
            list.add((ObjectInFolderContainer)container);
            if (depth == 1 || !child.isFolder()) continue;
            container.setChildren(new ArrayList());
            JcrRepository.gatherDescendants(child.asFolder(), container.getChildren(), foldersOnly, depth - 1, filter, includeAllowableActions, includePathSegments, objectInfos, requiresObjectInfo);
        }
    }

    private static Set<String> splitFilter(String filter) {
        if (filter == null) {
            return null;
        }
        if (filter.trim().length() == 0) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (String s : filter.split(",")) {
            if ((s = s.trim()).equals("*")) {
                return null;
            }
            if (s.length() <= 0) continue;
            result.add(s);
        }
        result.add("cmis:objectId");
        result.add("cmis:objectTypeId");
        result.add("cmis:baseTypeId");
        return result;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public JcrTypeManager getTypeManager() {
        return this.typeManager;
    }

    public PathManager getPathManager() {
        return this.pathManager;
    }

    public JcrTypeHandlerManager getTypeHandlerManager() {
        return this.typeHandlerManager;
    }
}

