/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr;

import java.util.List;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyHelper {
    private PropertyHelper() {
    }

    public static String getStringProperty(Properties properties, String name) {
        PropertyData property = (PropertyData)properties.getProperties().get(name);
        if (!(property instanceof PropertyString)) {
            return null;
        }
        return (String)((PropertyString)property).getFirstValue();
    }

    public static String getTypeId(Properties properties) {
        PropertyData typeProperty = (PropertyData)properties.getProperties().get("cmis:objectTypeId");
        if (!(typeProperty instanceof PropertyId)) {
            throw new CmisInvalidArgumentException("Type id must be set!");
        }
        String typeId = (String)((PropertyId)typeProperty).getFirstValue();
        if (typeId == null) {
            throw new CmisInvalidArgumentException("Type id must be set!");
        }
        return typeId;
    }

    public static boolean isPropertyEmpty(PropertyData<?> prop) {
        return prop == null || prop.getValues() == null || prop.getValues().isEmpty();
    }

    public static PropertyData<?> getDefaultValue(PropertyDefinition<?> propDef) {
        if (propDef == null) {
            return null;
        }
        List defaultValue = propDef.getDefaultValue();
        if (defaultValue != null && !defaultValue.isEmpty()) {
            switch (propDef.getPropertyType()) {
                case BOOLEAN: {
                    return new PropertyBooleanImpl(propDef.getId(), defaultValue);
                }
                case DATETIME: {
                    return new PropertyDateTimeImpl(propDef.getId(), defaultValue);
                }
                case DECIMAL: {
                    return new PropertyDecimalImpl(propDef.getId(), defaultValue);
                }
                case HTML: {
                    return new PropertyHtmlImpl(propDef.getId(), defaultValue);
                }
                case ID: {
                    return new PropertyIdImpl(propDef.getId(), defaultValue);
                }
                case INTEGER: {
                    return new PropertyIntegerImpl(propDef.getId(), defaultValue);
                }
                case STRING: {
                    return new PropertyStringImpl(propDef.getId(), defaultValue);
                }
                case URI: {
                    return new PropertyUriImpl(propDef.getId(), defaultValue);
                }
            }
            throw new CmisRuntimeException("Unknown datatype: " + propDef.getPropertyType());
        }
        return null;
    }
}

