/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr.impl;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FolderTypeDefinitionImpl;
import org.apache.chemistry.opencmis.jcr.JcrFolder;
import org.apache.chemistry.opencmis.jcr.JcrTypeManager;
import org.apache.chemistry.opencmis.jcr.impl.AbstractJcrTypeHandler;
import org.apache.chemistry.opencmis.jcr.impl.DefaultIdentifierMapBase;
import org.apache.chemistry.opencmis.jcr.query.IdentifierMap;
import org.apache.chemistry.opencmis.jcr.type.JcrFolderTypeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFolderTypeHandler
extends AbstractJcrTypeHandler
implements JcrFolderTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultFolderTypeHandler.class);

    public String getTypeId() {
        return BaseTypeId.CMIS_FOLDER.value();
    }

    public TypeDefinition getTypeDefinition() {
        FolderTypeDefinitionImpl folderType = new FolderTypeDefinitionImpl();
        folderType.setBaseTypeId(BaseTypeId.CMIS_FOLDER);
        folderType.setIsControllableAcl(Boolean.valueOf(false));
        folderType.setIsControllablePolicy(Boolean.valueOf(false));
        folderType.setIsCreatable(Boolean.valueOf(true));
        folderType.setDescription("Folder");
        folderType.setDisplayName("Folder");
        folderType.setIsFileable(Boolean.valueOf(true));
        folderType.setIsFulltextIndexed(Boolean.valueOf(false));
        folderType.setIsIncludedInSupertypeQuery(Boolean.valueOf(true));
        folderType.setLocalName("Folder");
        folderType.setLocalNamespace("http://opencmis.org/jcr");
        folderType.setIsQueryable(Boolean.valueOf(true));
        folderType.setQueryName("cmis:folder");
        folderType.setId("cmis:folder");
        JcrTypeManager.addBasePropertyDefinitions((AbstractTypeDefinition)folderType);
        JcrTypeManager.addFolderPropertyDefinitions(folderType);
        return folderType;
    }

    public IdentifierMap getIdentifierMap() {
        return new FolderIdentifierMap();
    }

    public JcrFolder getJcrNode(Node node) {
        return new JcrFolder(node, this.typeManager, this.pathManager, this.typeHandlerManager);
    }

    public boolean canHandle(Node node) throws RepositoryException {
        return node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}folder") || node.getDepth() == 0;
    }

    public JcrFolder createFolder(JcrFolder parentFolder, String name, Properties properties) {
        try {
            Node node = parentFolder.getNode().addNode(name, "{http://www.jcp.org/jcr/nt/1.0}folder");
            this.addMixins(node);
            this.updateProperties(node, properties);
            node.getSession().save();
            return this.getJcrNode(node);
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisStorageException(e.getMessage(), (Throwable)e);
        }
    }

    protected void updateProperties(Node node, Properties properties) {
        JcrFolder.setProperties(node, this.getTypeDefinition(), properties);
    }

    protected void addMixins(Node node) throws RepositoryException {
        node.addMixin("{http://www.jcp.org/jcr/mix/1.0}created");
        node.addMixin("{http://www.jcp.org/jcr/mix/1.0}lastModified");
    }

    private static class FolderIdentifierMap
    extends DefaultIdentifierMapBase {
        public FolderIdentifierMap() {
            super("nt:folder");
        }
    }
}

