/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.DocumentTypeDefinitionImpl;
import org.apache.chemistry.opencmis.jcr.JcrBinary;
import org.apache.chemistry.opencmis.jcr.JcrDocument;
import org.apache.chemistry.opencmis.jcr.JcrFolder;
import org.apache.chemistry.opencmis.jcr.JcrNode;
import org.apache.chemistry.opencmis.jcr.JcrTypeManager;
import org.apache.chemistry.opencmis.jcr.JcrVersion;
import org.apache.chemistry.opencmis.jcr.JcrVersionBase;
import org.apache.chemistry.opencmis.jcr.impl.AbstractJcrTypeHandler;
import org.apache.chemistry.opencmis.jcr.impl.DefaultDocumentIdentifierMap;
import org.apache.chemistry.opencmis.jcr.query.IdentifierMap;
import org.apache.chemistry.opencmis.jcr.type.JcrDocumentTypeHandler;
import org.apache.chemistry.opencmis.jcr.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDocumentTypeHandler
extends AbstractJcrTypeHandler
implements JcrDocumentTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(JcrFolder.class);

    public String getTypeId() {
        return BaseTypeId.CMIS_DOCUMENT.value();
    }

    public TypeDefinition getTypeDefinition() {
        DocumentTypeDefinitionImpl documentType = new DocumentTypeDefinitionImpl();
        documentType.setBaseTypeId(BaseTypeId.CMIS_DOCUMENT);
        documentType.setIsControllableAcl(Boolean.valueOf(false));
        documentType.setIsControllablePolicy(Boolean.valueOf(false));
        documentType.setIsCreatable(Boolean.valueOf(true));
        documentType.setDescription("Document");
        documentType.setDisplayName("Document");
        documentType.setIsFileable(Boolean.valueOf(true));
        documentType.setIsFulltextIndexed(Boolean.valueOf(false));
        documentType.setIsIncludedInSupertypeQuery(Boolean.valueOf(true));
        documentType.setLocalName("Document");
        documentType.setLocalNamespace("http://opencmis.org/jcr");
        documentType.setIsQueryable(Boolean.valueOf(true));
        documentType.setQueryName("cmis:document");
        documentType.setId("cmis:document");
        documentType.setIsVersionable(Boolean.valueOf(true));
        documentType.setContentStreamAllowed(ContentStreamAllowed.ALLOWED);
        JcrTypeManager.addBasePropertyDefinitions((AbstractTypeDefinition)documentType);
        JcrTypeManager.addDocumentPropertyDefinitions(documentType);
        return documentType;
    }

    public IdentifierMap getIdentifierMap() {
        return new DefaultDocumentIdentifierMap(true);
    }

    public JcrDocument getJcrNode(Node node) throws RepositoryException {
        VersionManager versionManager = node.getSession().getWorkspace().getVersionManager();
        Version version = versionManager.getBaseVersion(node.getPath());
        return new JcrVersion(node, version, this.typeManager, this.pathManager, this.typeHandlerManager);
    }

    public boolean canHandle(Node node) throws RepositoryException {
        return node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}file") && node.isNodeType(this.supportedVersioningType(node));
    }

    protected String supportedVersioningType(Node node) throws RepositoryException {
        if (Util.supportOption(node, "option.simple.versioning.supported")) {
            return "{http://www.jcp.org/jcr/mix/1.0}simpleVersionable";
        }
        if (Util.supportOption(node, "option.versioning.supported")) {
            return "{http://www.jcp.org/jcr/mix/1.0}versionable";
        }
        throw new RepositoryException("The repository does not support versioning!");
    }

    public JcrNode createDocument(JcrFolder parentFolder, String name, Properties properties, ContentStream contentStream, VersioningState versioningState) {
        try {
            Node fileNode = parentFolder.getNode().addNode(name, "{http://www.jcp.org/jcr/nt/1.0}file");
            this.addFileNodeMixins(fileNode, versioningState);
            Node contentNode = fileNode.addNode("{http://www.jcp.org/jcr/1.0}content", "{http://www.jcp.org/jcr/nt/1.0}resource");
            this.addContentNodeMixins(contentNode);
            this.setContentNodeProperties(contentNode, properties);
            this.updateContentNode(contentStream, contentNode);
            fileNode.getSession().save();
            return this.getJcrNode(fileNode, versioningState);
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisStorageException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw new CmisStorageException(e.getMessage(), (Throwable)e);
        }
    }

    protected JcrNode getJcrNode(Node fileNode, VersioningState versioningState) throws RepositoryException {
        JcrDocument jcrFileNode = this.getJcrNode(fileNode);
        if (versioningState == VersioningState.NONE) {
            return jcrFileNode;
        }
        JcrVersionBase jcrVersion = jcrFileNode.asVersion();
        if (versioningState == VersioningState.MINOR || versioningState == VersioningState.MAJOR) {
            return jcrVersion.checkin(null, null, "auto checkin");
        }
        return jcrVersion.getPwc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateContentNode(ContentStream contentStream, Node contentNode) throws IOException, RepositoryException {
        Binary binary = contentStream == null || contentStream.getStream() == null ? JcrBinary.EMPTY : new JcrBinary(new BufferedInputStream(contentStream.getStream()));
        try {
            contentNode.setProperty("{http://www.jcp.org/jcr/1.0}data", binary);
            if (contentStream != null && contentStream.getMimeType() != null) {
                contentNode.setProperty("{http://www.jcp.org/jcr/1.0}mimeType", contentStream.getMimeType());
            }
        }
        finally {
            binary.dispose();
        }
    }

    protected void setContentNodeProperties(Node contentNode, Properties properties) {
        JcrFolder.setProperties(contentNode, this.getTypeDefinition(), properties);
    }

    protected void addContentNodeMixins(Node contentNode) throws RepositoryException {
        contentNode.addMixin("{http://www.jcp.org/jcr/mix/1.0}created");
    }

    protected void addFileNodeMixins(Node fileNode, VersioningState versioningState) throws RepositoryException {
        if (versioningState != VersioningState.NONE) {
            fileNode.addMixin(this.supportedVersioningType(fileNode));
        }
    }
}

