/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr.query;

import java.util.GregorianCalendar;
import java.util.List;
import org.apache.chemistry.opencmis.jcr.query.Evaluator;
import org.apache.chemistry.opencmis.jcr.query.EvaluatorBase;
import org.apache.chemistry.opencmis.jcr.query.XPathBuilder;
import org.apache.chemistry.opencmis.jcr.util.ISO8601;
import org.apache.chemistry.opencmis.jcr.util.Iterables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluatorXPath
extends EvaluatorBase<XPathBuilder> {
    @Override
    public Evaluator<XPathBuilder> op() {
        return new EvaluatorXPath(){

            protected String jcrPathFromId(String id) {
                return EvaluatorXPath.this.jcrPathFromId(id);
            }

            protected String jcrPathFromCol(String name) {
                return EvaluatorXPath.this.jcrPathFromCol(name);
            }
        };
    }

    @Override
    public XPathBuilder not(final XPathBuilder op) {
        return new XPathBuilder(){

            @Override
            public String xPath() {
                if (this.eval(true) != null) {
                    return this.eval(true) != false ? "true()" : "false()";
                }
                return "not(" + op.xPath() + ")";
            }

            @Override
            public Boolean eval(Boolean folderPredicateValuation) {
                return EvaluatorXPath.not(op.eval(folderPredicateValuation));
            }

            @Override
            public Iterable<XPathBuilder> folderPredicates() {
                return op.folderPredicates();
            }
        };
    }

    @Override
    public XPathBuilder and(final XPathBuilder op1, final XPathBuilder op2) {
        return new XPathBuilder(){

            @Override
            public String xPath() {
                if (this.eval(true) != null) {
                    return this.eval(true) != false ? "true()" : "false()";
                }
                if (op1.eval(true) != null) {
                    return op2.xPath();
                }
                if (op2.eval(true) != null) {
                    return op1.xPath();
                }
                return op1.xPath() + " and " + op2.xPath();
            }

            @Override
            public Boolean eval(Boolean folderPredicateValuation) {
                return EvaluatorXPath.and(op1.eval(folderPredicateValuation), op2.eval(folderPredicateValuation));
            }

            @Override
            public Iterable<XPathBuilder> folderPredicates() {
                return Iterables.concat(op1.folderPredicates(), op2.folderPredicates());
            }
        };
    }

    @Override
    public XPathBuilder or(final XPathBuilder op1, final XPathBuilder op2) {
        return new XPathBuilder(){

            @Override
            public String xPath() {
                if (this.eval(true) != null) {
                    return this.eval(true) != false ? "true()" : "false()";
                }
                if (op1.eval(true) != null) {
                    return op2.xPath();
                }
                if (op2.eval(true) != null) {
                    return op1.xPath();
                }
                return "(" + op1.xPath() + " or " + op2.xPath() + ")";
            }

            @Override
            public Boolean eval(Boolean folderPredicateValuation) {
                return EvaluatorXPath.or(op1.eval(folderPredicateValuation), op2.eval(folderPredicateValuation));
            }

            @Override
            public Iterable<XPathBuilder> folderPredicates() {
                return Iterables.concat(op1.folderPredicates(), op2.folderPredicates());
            }
        };
    }

    @Override
    public XPathBuilder eq(XPathBuilder op1, XPathBuilder op2) {
        return new RelOpBuilder(op1, " = ", op2);
    }

    @Override
    public XPathBuilder neq(XPathBuilder op1, XPathBuilder op2) {
        return new RelOpBuilder(op1, " != ", op2);
    }

    @Override
    public XPathBuilder gt(XPathBuilder op1, XPathBuilder op2) {
        return new RelOpBuilder(op1, " > ", op2);
    }

    @Override
    public XPathBuilder gteq(XPathBuilder op1, XPathBuilder op2) {
        return new RelOpBuilder(op1, " >= ", op2);
    }

    @Override
    public XPathBuilder lt(XPathBuilder op1, XPathBuilder op2) {
        return new RelOpBuilder(op1, " < ", op2);
    }

    @Override
    public XPathBuilder lteq(XPathBuilder op1, XPathBuilder op2) {
        return new RelOpBuilder(op1, " <= ", op2);
    }

    @Override
    public XPathBuilder in(XPathBuilder op1, XPathBuilder op2) {
        return super.in(op1, op2);
    }

    @Override
    public XPathBuilder notIn(XPathBuilder op1, XPathBuilder op2) {
        return super.notIn(op1, op2);
    }

    @Override
    public XPathBuilder inAny(XPathBuilder op1, XPathBuilder op2) {
        return super.inAny(op1, op2);
    }

    @Override
    public XPathBuilder notInAny(XPathBuilder op1, XPathBuilder op2) {
        return super.notInAny(op1, op2);
    }

    @Override
    public XPathBuilder eqAny(XPathBuilder op1, XPathBuilder op2) {
        return super.eqAny(op1, op2);
    }

    @Override
    public XPathBuilder isNull(XPathBuilder op) {
        return new FunctionBuilder(op);
    }

    @Override
    public XPathBuilder notIsNull(XPathBuilder op) {
        return new FunctionBuilder("not", op);
    }

    @Override
    public XPathBuilder like(XPathBuilder op1, XPathBuilder op2) {
        return new FunctionBuilder("jcr:like", op1, op2);
    }

    @Override
    public XPathBuilder notLike(XPathBuilder op1, XPathBuilder op2) {
        return new FunctionBuilder("jcr:like", op1, op2){

            public String xPath() {
                return "not(" + super.xPath() + ")";
            }
        };
    }

    @Override
    public XPathBuilder contains(XPathBuilder op1, XPathBuilder op2) {
        return new ContainsBuilder(op2);
    }

    @Override
    public XPathBuilder inFolder(XPathBuilder op1, XPathBuilder op2) {
        return new FolderPredicateBuilder(op2.xPath(), false);
    }

    @Override
    public XPathBuilder inTree(XPathBuilder op1, XPathBuilder op2) {
        return new FolderPredicateBuilder(op2.xPath(), true);
    }

    @Override
    public XPathBuilder list(List<XPathBuilder> ops) {
        return super.list(ops);
    }

    @Override
    public XPathBuilder value(boolean value) {
        return new LiteralBuilder(value);
    }

    @Override
    public XPathBuilder value(double value) {
        return new LiteralBuilder(value);
    }

    @Override
    public XPathBuilder value(long value) {
        return new LiteralBuilder(value);
    }

    @Override
    public XPathBuilder value(String value) {
        return new LiteralBuilder(value);
    }

    @Override
    public XPathBuilder value(GregorianCalendar value) {
        return new LiteralBuilder(value);
    }

    @Override
    public XPathBuilder col(String name) {
        return new ColRefBuilder(name);
    }

    @Override
    public XPathBuilder textAnd(List<XPathBuilder> ops) {
        return new TextOpBuilder(ops, " ");
    }

    @Override
    public XPathBuilder textOr(List<XPathBuilder> ops) {
        return new TextOpBuilder(ops, " OR ");
    }

    @Override
    public XPathBuilder textMinus(String text) {
        return new TextMinusBuilder(text);
    }

    @Override
    public XPathBuilder textWord(String word) {
        return new TextWordBuilder(word);
    }

    @Override
    public XPathBuilder textPhrase(String phrase) {
        return new TextPhraseBuilder(phrase);
    }

    protected String jcrPathFromId(String id) {
        return id;
    }

    protected String jcrPathFromCol(String name) {
        return name;
    }

    private static Boolean not(Boolean b) {
        return b == null ? null : Boolean.valueOf(b == false);
    }

    private static Boolean or(Boolean b1, Boolean b2) {
        return Boolean.TRUE.equals(b1) || Boolean.TRUE.equals(b2) ? Boolean.TRUE : (Boolean.FALSE.equals(b1) && Boolean.FALSE.equals(b2) ? Boolean.FALSE : null);
    }

    private static Boolean and(Boolean b1, Boolean b2) {
        return Boolean.FALSE.equals(b1) || Boolean.FALSE.equals(b2) ? Boolean.FALSE : (Boolean.TRUE.equals(b1) && Boolean.TRUE.equals(b2) ? Boolean.TRUE : null);
    }

    private static String escape(String s) {
        if (s == null) {
            return "";
        }
        s = s.replaceAll("'", "\\'");
        s = s.replaceAll("\"", "\\\"");
        s = s.replaceAll("-", "\\-");
        s = s.replaceAll("\\\\", "\\\\\\\\");
        return s;
    }

    private static class TextPhraseBuilder
    extends PrimitiveBuilder {
        private final String phrase;

        public TextPhraseBuilder(String phrase) {
            this.phrase = phrase;
        }

        public String xPath() {
            return "\"" + EvaluatorXPath.escape(this.phrase.substring(1, this.phrase.length() - 1)) + "\"";
        }
    }

    private static class TextWordBuilder
    extends PrimitiveBuilder {
        private final String word;

        public TextWordBuilder(String word) {
            this.word = word;
        }

        public String xPath() {
            return EvaluatorXPath.escape(this.word);
        }
    }

    private static class TextMinusBuilder
    extends PrimitiveBuilder {
        private final String text;

        public TextMinusBuilder(String text) {
            this.text = text;
        }

        public String xPath() {
            return "-" + EvaluatorXPath.escape(this.text);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TextOpBuilder
    extends PrimitiveBuilder {
        private final List<XPathBuilder> ops;
        private final String relOp;

        public TextOpBuilder(List<XPathBuilder> ops, String relOp) {
            this.ops = ops;
            this.relOp = relOp;
        }

        @Override
        public String xPath() {
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (XPathBuilder op : this.ops) {
                sb.append(sep).append(op.xPath());
                sep = this.relOp;
            }
            return sb.toString();
        }
    }

    private static class ContainsBuilder
    extends PrimitiveBuilder {
        private final XPathBuilder op;

        public ContainsBuilder(XPathBuilder op) {
            this.op = op;
        }

        public String xPath() {
            return "jcr:contains(jcr:content, '" + this.op.xPath() + "')";
        }
    }

    private static class FunctionBuilder
    extends PrimitiveBuilder {
        private final String function;
        private final XPathBuilder op1;
        private final XPathBuilder op2;

        private FunctionBuilder(String function, XPathBuilder op1, XPathBuilder op2) {
            this.function = function;
            this.op1 = op1;
            this.op2 = op2;
        }

        public FunctionBuilder(String function, XPathBuilder op1) {
            this(function, op1, null);
        }

        public FunctionBuilder(XPathBuilder op1) {
            this(null, op1, null);
        }

        public String xPath() {
            return this.function == null ? this.op1.xPath() : this.function + "(" + this.op1.xPath() + (this.op2 == null ? "" : ", " + this.op2.xPath()) + ")";
        }
    }

    private class ColRefBuilder
    extends PrimitiveBuilder {
        private final String colRef;

        public ColRefBuilder(String colRef) {
            this.colRef = colRef;
        }

        public String xPath() {
            return EvaluatorXPath.this.jcrPathFromCol(this.colRef);
        }
    }

    private static class LiteralBuilder
    extends PrimitiveBuilder {
        private final String xPath;

        public LiteralBuilder(String value) {
            this.xPath = "'" + value + "'";
        }

        public LiteralBuilder(boolean value) {
            this.xPath = Boolean.toString(value);
        }

        public LiteralBuilder(long value) {
            this.xPath = Long.toString(value);
        }

        public LiteralBuilder(double value) {
            this.xPath = Double.toString(value);
        }

        public LiteralBuilder(GregorianCalendar value) {
            this.xPath = "xs:dateTime('" + ISO8601.format(value) + "')";
        }

        public String xPath() {
            return this.xPath;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class PrimitiveBuilder
    implements XPathBuilder {
        private PrimitiveBuilder() {
        }

        @Override
        public Boolean eval(Boolean folderPredicateValuation) {
            return null;
        }

        @Override
        public Iterable<XPathBuilder> folderPredicates() {
            return Iterables.empty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FolderPredicateBuilder
    implements XPathBuilder {
        private final String folderId;
        private final boolean includeDescendants;

        public FolderPredicateBuilder(String folderId, boolean includeDescendants) {
            this.folderId = this.stripQuotes(folderId);
            this.includeDescendants = includeDescendants;
        }

        @Override
        public String xPath() {
            return EvaluatorXPath.this.jcrPathFromId(this.folderId) + (this.includeDescendants ? "//" : "/");
        }

        @Override
        public Boolean eval(Boolean folderPredicateValuation) {
            return folderPredicateValuation;
        }

        @Override
        public Iterable<XPathBuilder> folderPredicates() {
            return Iterables.singleton(this);
        }

        private String stripQuotes(String string) {
            return (string.startsWith("'") || string.startsWith("\"")) && string.length() >= 2 ? string.substring(1, string.length() - 1) : string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RelOpBuilder
    implements XPathBuilder {
        private final String relOp;
        private final XPathBuilder op1;
        private final XPathBuilder op2;

        public RelOpBuilder(XPathBuilder op1, String relOp, XPathBuilder op2) {
            this.relOp = relOp;
            this.op1 = op1;
            this.op2 = op2;
        }

        @Override
        public String xPath() {
            return this.op1.xPath() + this.relOp + this.op2.xPath();
        }

        @Override
        public Boolean eval(Boolean folderPredicateValuation) {
            return null;
        }

        @Override
        public Iterable<XPathBuilder> folderPredicates() {
            return Iterables.concat(this.op1.folderPredicates(), this.op2.folderPredicates());
        }
    }
}

