/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.jcr.util;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

public final class Util {
    private Util() {
    }

    public static GregorianCalendar toCalendar(Calendar date) {
        if (date instanceof GregorianCalendar) {
            return (GregorianCalendar)date;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeZone(date.getTimeZone());
        calendar.setTimeInMillis(date.getTimeInMillis());
        return calendar;
    }

    public static String replace(String string, String target, String replacement) {
        int j;
        if ("".equals(target)) {
            throw new IllegalArgumentException("target string must not be empty");
        }
        if ("".equals(replacement) || target.equals(replacement)) {
            return string;
        }
        StringBuilder result = new StringBuilder();
        int d = target.length();
        int k = 0;
        do {
            if ((j = string.indexOf(target, k)) < 0) {
                result.append(string.substring(k));
            } else {
                result.append(string.substring(k, j)).append(replacement);
            }
            k = j + d;
        } while (j >= 0);
        return result.toString();
    }

    public static String escape(String path) {
        return Util.replace(path, " ", "_x0020_");
    }

    public static boolean supportOption(Node node, String option) throws RepositoryException {
        return Boolean.valueOf(node.getSession().getRepository().getDescriptor(option));
    }
}

