/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.cmis;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.imageio.spi.ServiceRegistry;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.RepositoryFactory;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractServiceFactory;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.jcr.JcrRepository;
import org.apache.chemistry.opencmis.jcr.JcrTypeManager;
import org.apache.chemistry.opencmis.jcr.PathManager;
import org.apache.chemistry.opencmis.jcr.impl.DefaultDocumentTypeHandler;
import org.apache.chemistry.opencmis.jcr.impl.DefaultFolderTypeHandler;
import org.apache.chemistry.opencmis.jcr.impl.DefaultUnversionedDocumentTypeHandler;
import org.apache.chemistry.opencmis.jcr.type.JcrTypeHandler;
import org.apache.chemistry.opencmis.jcr.type.JcrTypeHandlerManager;
import org.apache.chemistry.opencmis.server.support.CmisServiceWrapper;
import org.modeshape.cmis.JcrService;
import org.modeshape.cmis.RepositoryConfig;
import org.modeshape.common.logging.Logger;
import org.modeshape.web.jcr.NoSuchRepositoryException;
import org.modeshape.web.jcr.RepositoryManager;

public class JcrServiceFactory
extends AbstractServiceFactory {
    private static final Logger log = Logger.getLogger(JcrServiceFactory.class);
    public static final String MOUNT_PATH_CONFIG = "mount-path";
    public static final String PREFIX_JCR_CONFIG = "jcr.";
    public static final BigInteger DEFAULT_MAX_ITEMS_TYPES = BigInteger.valueOf(50L);
    public static final BigInteger DEFAULT_DEPTH_TYPES = BigInteger.valueOf(-1L);
    public static final BigInteger DEFAULT_MAX_ITEMS_OBJECTS = BigInteger.valueOf(200L);
    public static final BigInteger DEFAULT_DEPTH_OBJECTS = BigInteger.valueOf(10L);
    protected JcrTypeManager typeManager;
    protected Map<String, Map<String, String>> jcrConfig;
    protected String mountPath;
    protected Map<String, JcrRepository> jcrRepositories;

    public void init(Map<String, String> parameters) {
        this.typeManager = this.createTypeManager();
        this.readConfiguration(parameters);
        PathManager pathManager = new PathManager(this.mountPath);
        JcrTypeHandlerManager typeHandlerManager = this.createTypeHandlerManager(pathManager, this.typeManager);
        this.jcrRepositories = this.loadRepositories(pathManager, typeHandlerManager);
    }

    public void init() {
        this.typeManager = this.createTypeManager();
        PathManager pathManager = new PathManager("/");
        JcrTypeHandlerManager typeHandlerManager = this.createTypeHandlerManager(pathManager, this.typeManager);
        this.jcrRepositories = this.loadRepositories(pathManager, typeHandlerManager);
    }

    public void destroy() {
        this.jcrRepositories.clear();
        this.typeManager = null;
    }

    public CmisService getService(CallContext context) {
        CmisServiceWrapper serviceWrapper = new CmisServiceWrapper((CmisService)this.createJcrService(this.jcrRepositories, context), DEFAULT_MAX_ITEMS_TYPES, DEFAULT_DEPTH_TYPES, DEFAULT_MAX_ITEMS_OBJECTS, DEFAULT_DEPTH_OBJECTS);
        ((JcrService)serviceWrapper.getWrappedService()).setCallContext(context);
        return serviceWrapper;
    }

    private Map<String, JcrRepository> loadRepositories(PathManager pathManger, JcrTypeHandlerManager typeHandlerManager) {
        HashMap<String, JcrRepository> list = new HashMap<String, JcrRepository>();
        Set names = RepositoryManager.getJcrRepositoryNames();
        for (String repositoryId : names) {
            try {
                Repository repository = RepositoryManager.getRepository((String)repositoryId);
                list.put(repositoryId, new JcrRepository(repository, pathManger, this.typeManager, typeHandlerManager));
                log.debug("--- loaded repository " + repositoryId, new Object[0]);
            }
            catch (NoSuchRepositoryException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    protected Repository acquireJcrRepository(Map<String, String> jcrConfig) {
        try {
            Iterator<RepositoryFactory> factories = ServiceRegistry.lookupProviders(RepositoryFactory.class);
            while (factories.hasNext()) {
                RepositoryFactory factory = factories.next();
                log.debug("Trying to acquire JCR repository from factory " + factory, new Object[0]);
                Repository repository = factory.getRepository(jcrConfig);
                if (repository != null) {
                    log.debug("Successfully acquired JCR repository from factory " + factory, new Object[0]);
                    return repository;
                }
                log.debug("Could not acquire JCR repository from factory " + factory, new Object[0]);
            }
            throw new CmisConnectionException("No JCR repository factory for configured parameters");
        }
        catch (RepositoryException e) {
            log.debug(e.getMessage(), new Object[]{e});
            throw new CmisConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    protected JcrService createJcrService(Map<String, JcrRepository> jcrRepositories, CallContext context) {
        return new JcrService(jcrRepositories);
    }

    protected JcrTypeManager createTypeManager() {
        return new JcrTypeManager();
    }

    protected JcrTypeHandlerManager createTypeHandlerManager(PathManager pathManager, JcrTypeManager typeManager) {
        JcrTypeHandlerManager typeHandlerManager = new JcrTypeHandlerManager(pathManager, typeManager);
        typeHandlerManager.addHandler((JcrTypeHandler)new DefaultFolderTypeHandler());
        typeHandlerManager.addHandler((JcrTypeHandler)new DefaultDocumentTypeHandler());
        typeHandlerManager.addHandler((JcrTypeHandler)new DefaultUnversionedDocumentTypeHandler());
        return typeHandlerManager;
    }

    private void readConfiguration(Map<String, String> parameters) {
        this.mountPath = parameters.get(MOUNT_PATH_CONFIG);
        this.jcrConfig = RepositoryConfig.load(parameters);
    }

    public JcrTypeManager getTypeManager() {
        return this.typeManager;
    }
}

