/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.Overflow;
import com.smartgwt.client.types.SelectionStyle;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.grid.events.CellClickHandler;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.client.widgets.tab.Tab;
import com.smartgwt.client.widgets.tab.TabSet;
import com.smartgwt.client.widgets.tree.Tree;
import com.smartgwt.client.widgets.tree.TreeGrid;
import com.smartgwt.client.widgets.tree.TreeNode;
import com.smartgwt.client.widgets.tree.events.FolderClickHandler;
import java.util.Collection;
import org.modeshape.web.client.Console;
import org.modeshape.web.client.JcrTreeNode;
import org.modeshape.web.client.Navigator;
import org.modeshape.web.client.TreeToolbar;
import org.modeshape.web.shared.JcrNode;

public class Navigator
extends Label {
    private Tree jcrTree = new Tree();
    private TreeGrid jcrTreeGrid = new TreeGrid();
    private TreeNode ROOT = new TreeNode();
    private Console console;

    public Navigator(Console console) {
        this.console = console;
        this.setAlign(Alignment.CENTER);
        this.setOverflow(Overflow.HIDDEN);
        this.setWidth("20%");
        this.setShowResizeBar(Boolean.valueOf(true));
        Tab treeTab = new Tab();
        this.jcrTreeGrid.setWidth100();
        this.jcrTreeGrid.setHeight100();
        this.jcrTreeGrid.setCanDragResize(Boolean.valueOf(true));
        this.jcrTreeGrid.setAnimateFolders(Boolean.valueOf(true));
        this.jcrTreeGrid.setAnimateFolderSpeed(450);
        this.jcrTreeGrid.setCustomIconProperty("treeGridIcon");
        this.jcrTreeGrid.setTreeFieldTitle("Workspace: default");
        this.jcrTreeGrid.setCanReorderRecords(Boolean.valueOf(true));
        this.jcrTreeGrid.setCanAcceptDroppedRecords(Boolean.valueOf(true));
        this.jcrTreeGrid.setCanDragRecordsOut(Boolean.valueOf(true));
        this.jcrTreeGrid.setShowConnectors(Boolean.valueOf(true));
        this.jcrTreeGrid.setSelectionType(SelectionStyle.SINGLE);
        this.jcrTreeGrid.addCellClickHandler((CellClickHandler)new NodeLoader(this, null));
        this.jcrTreeGrid.addFolderClickHandler((FolderClickHandler)new FolderClickHandlerImpl(this, null));
        VLayout vlayout = new VLayout();
        vlayout.addMember((Canvas)new TreeToolbar(console));
        vlayout.addMember((Canvas)this.jcrTreeGrid);
        treeTab.setPane((Canvas)vlayout);
        treeTab.setTitle("Repository");
        treeTab.setIcon("icons/view_tree_modernist.png");
        TabSet tabset = new TabSet();
        tabset.setTabs(new Tab[]{treeTab});
        tabset.setWidth100();
        tabset.setHeight100();
        this.addChild((Canvas)tabset);
        this.jcrTreeGrid.draw();
    }

    public String getSelectedPath() {
        return ((JcrTreeNode)this.jcrTreeGrid.getSelectedRecord()).getPath();
    }

    public void showRoot() {
        this.console.jcrService.getRootNode((AsyncCallback)new RootAccessorHandler(this, null));
    }

    public void openFolder(String path) {
        JcrTreeNode n = (JcrTreeNode)this.jcrTree.find("path", (Object)path);
        SC.say((String)("Node is null " + (n == null)));
        this.jcrTree.openFolder((TreeNode)n);
    }

    public void openFolder(TreeNode node) {
        this.jcrTree.openFolder(node);
    }

    public void remove(TreeNode node) {
        this.jcrTree.remove(node);
    }

    public void deselectAllRecords() {
        this.jcrTreeGrid.deselectAllRecords();
    }

    public boolean hasChildren(TreeNode node) {
        return this.jcrTree.hasChildren(node);
    }

    public void refresh() {
        this.jcrTreeGrid.setData(this.jcrTree);
    }

    public void selectNode() {
        String path;
        JcrTreeNode node = (JcrTreeNode)this.jcrTreeGrid.getSelectedRecord();
        if (node == null) {
            node = (JcrTreeNode)this.ROOT;
        }
        if ((path = node.getAttribute("path")) != null && path.trim().length() != 0) {
            this.console.jcrService.childNodes(path, (AsyncCallback)new ChildrenHandler(this, null));
        }
        this.console.nodePanel.display(node);
    }

    public JcrTreeNode getSelectedNode() {
        JcrTreeNode node = (JcrTreeNode)this.jcrTreeGrid.getSelectedRecord();
        if (node == null) {
            node = (JcrTreeNode)this.ROOT;
        }
        return node;
    }

    protected JcrTreeNode convert(JcrNode node) {
        JcrTreeNode item = new JcrTreeNode(node.getName(), node.getPath(), node.getPrimaryType());
        item.setProperties(node.getProperties());
        Collection children = node.children();
        JcrTreeNode[] childs = new JcrTreeNode[children.size()];
        int i = 0;
        for (JcrNode child : children) {
            childs[i++] = this.convert(child);
        }
        item.setChildren((TreeNode[])childs);
        item.setAcessControlList(node.getAccessList());
        item.setMixins(node.getMixins());
        item.setPropertyDefs(node.getPropertyDefs());
        return item;
    }

    static /* synthetic */ TreeNode access$402(Navigator x0, TreeNode x1) {
        x0.ROOT = x1;
        return x0.ROOT;
    }

    static /* synthetic */ Tree access$500(Navigator x0) {
        return x0.jcrTree;
    }

    static /* synthetic */ TreeNode access$400(Navigator x0) {
        return x0.ROOT;
    }

    static /* synthetic */ TreeGrid access$600(Navigator x0) {
        return x0.jcrTreeGrid;
    }
}

