/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Button;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.ComboBoxItem;
import com.smartgwt.client.widgets.form.fields.FormItem;
import com.smartgwt.client.widgets.form.fields.events.ChangedEvent;
import com.smartgwt.client.widgets.form.fields.events.ChangedHandler;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;
import org.modeshape.web.client.AddMixinDialog;
import org.modeshape.web.client.AddPrincipalDialog;
import org.modeshape.web.client.AddPropertyDialog;
import org.modeshape.web.client.Console;
import org.modeshape.web.client.ExportDialog;
import org.modeshape.web.client.ImportDialog;
import org.modeshape.web.client.JcrServiceAsync;
import org.modeshape.web.client.NewNodeDialog;
import org.modeshape.web.client.RemoveMixinDialog;
import org.modeshape.web.client.RenameNodeDialog;
import org.modeshape.web.client.View;
import org.modeshape.web.client.ViewPort;
import org.modeshape.web.client.grid.AccessList;
import org.modeshape.web.client.grid.Children;
import org.modeshape.web.client.grid.Properties;
import org.modeshape.web.client.grid.TabGrid;
import org.modeshape.web.client.grid.TabsetGrid;
import org.modeshape.web.shared.Acl;
import org.modeshape.web.shared.JcrNode;
import org.modeshape.web.shared.JcrPermission;
import org.modeshape.web.shared.Policy;

public class Contents
extends View {
    private Console console;
    private JcrServiceAsync jcrService;
    private String repository;
    private JcrNode node;
    private String path;
    private ComboBoxItem workspaces = new ComboBoxItem();
    private PathLabel pathLabel = new PathLabel();
    private Children children = new Children(this);
    private Properties properties = new Properties(this);
    private AccessList accessList = new AccessList(this);
    private TabsetGrid mainGrid = new TabsetGrid(new String[]{"Children", "Properties", "Access list"}, new TabGrid[]{this.children, this.properties, this.accessList});
    private NewNodeDialog newNodeDialog = new NewNodeDialog(this);
    private RenameNodeDialog renameNodeDialog = new RenameNodeDialog(this);
    private AddMixinDialog addMixinDialog = new AddMixinDialog(this);
    private RemoveMixinDialog removeMixinDialog = new RemoveMixinDialog(this);
    private AddPropertyDialog setPropertyDialog = new AddPropertyDialog(this);
    private AddPrincipalDialog addAccessListDialog = new AddPrincipalDialog(this);
    private ExportDialog exportDialog = new ExportDialog(this);
    private ImportDialog importDialog = new ImportDialog(this);
    private Button saveButton;

    public Contents(final Console console, JcrServiceAsync jcrService, ViewPort viewPort) {
        super(viewPort, null);
        this.console = console;
        this.jcrService = jcrService;
        Canvas text = new Canvas();
        text.setContents("ModeShape is a distributed, hierarchical, transactional, and consistent data store with support for queries, full-text search, events, versioning, references, and flexible and dynamic schemas. It is very fast, highly available, extremely scalable, and it is 100% open source and written in Java. Clients use the JSR-283 standard Java API for content repositories (aka, JCR) or ModeShape's REST API, and can query content through JDBC and SQL.");
        text.setWidth100();
        text.setAutoHeight();
        text.setStyleName("caption");
        this.addMember(text);
        this.addMember((Canvas)new Spacer(20));
        DynamicForm form = new DynamicForm();
        form.setFields(new FormItem[]{this.workspaces});
        this.workspaces.setTitle("Workspace");
        this.workspaces.addChangedHandler(new ChangedHandler(){

            public void onChanged(ChangedEvent event) {
                Contents.this.select(Contents.this.repository(), (String)event.getValue(), Contents.this.path(), true);
            }
        });
        VLayout wsPanel = new VLayout();
        wsPanel.addMember((Canvas)form);
        wsPanel.setDefaultLayoutAlign(VerticalAlignment.CENTER);
        wsPanel.setLayoutAlign(VerticalAlignment.CENTER);
        HLayout panel = new HLayout();
        panel.addMember((Canvas)wsPanel);
        panel.setStyleName("viewport");
        panel.setHeight(45);
        panel.setLayoutAlign(VerticalAlignment.CENTER);
        panel.setDefaultLayoutAlign(VerticalAlignment.CENTER);
        HLayout buttonPanel = new HLayout();
        buttonPanel.setWidth100();
        this.saveButton = new Button();
        this.saveButton.disable();
        this.saveButton.setTitle("Save");
        this.saveButton.setIcon("icons/save.png");
        this.saveButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                console.save();
                Contents.this.saveButton.disable();
            }
        });
        panel.addMember((Canvas)buttonPanel);
        this.addMember((Canvas)panel);
        panel.addMember((Canvas)this.saveButton);
        HLayout spacer = new HLayout();
        spacer.setWidth(5);
        panel.addMember((Canvas)spacer);
        VLayout strut = new VLayout();
        strut.setHeight(20);
        this.addMember((Canvas)strut);
        this.addMember((Canvas)this.pathLabel);
        this.addMember((Canvas)this.mainGrid);
    }

    public void show(String repository, final boolean changeHistory) {
        this.repository = repository;
        this.jcrService.getWorkspaces(repository, new AsyncCallback<String[]>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(String[] result) {
                Contents.this.workspaces.setValueMap(result);
                if (result.length > 0) {
                    Contents.this.workspaces.setValue(result[0]);
                }
                Contents.this.select(Contents.this.path(), changeHistory);
            }
        });
    }

    public void select(String repository, final String workspace, final String path, final boolean changeHistory) {
        this.repository = repository;
        this.jcrService.getWorkspaces(repository, new AsyncCallback<String[]>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(String[] result) {
                Contents.this.workspaces.setValueMap(result);
                Contents.this.workspaces.setValue(workspace);
                Contents.this.select(path, changeHistory);
            }
        });
    }

    public void select(final String path, final boolean changeHistory) {
        this.console.showLoadingIcon();
        this.path = path;
        this.jcrService.node(this.repository(), this.workspace(), path, new AsyncCallback<JcrNode>(){

            public void onFailure(Throwable caught) {
                Contents.this.console.hideLoadingIcon();
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(JcrNode result) {
                Contents.this.console.hideLoadingIcon();
                Contents.this.node = result;
                Contents.this.path = result.getPath();
                Contents.this.pathLabel.display(result.getPath());
                Contents.this.console.updateWorkspace(Contents.this.workspace(), changeHistory);
                Contents.this.console.updatePath(path, changeHistory);
                Contents.this.children.show(Contents.this.node);
                Contents.this.properties.show(Contents.this.node);
                Contents.this.accessList.show(Contents.this.node);
                Contents.this.viewPort().display(Contents.this);
            }
        });
    }

    public void export() {
        this.exportDialog.showModal();
    }

    public void importXML() {
        this.importDialog.showModal();
    }

    public void export(String name, boolean skipBinary, boolean noRecurse) {
        this.jcrService.export(this.repository, this.workspace(), this.path(), name, true, true, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                SC.say((String)"Complete");
            }
        });
    }

    public void importXML(String name, int option) {
        this.jcrService.importXML(this.repository, this.workspace(), this.path(), name, option, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                SC.say((String)"Complete");
            }
        });
    }

    public void removeNode() {
        final String path = this.parent(this.path());
        this.jcrService.removeNode(this.repository(), this.workspace(), this.path(), new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.saveButton.enable();
                Contents.this.select(path, true);
            }
        });
    }

    public void addNode() {
        this.newNodeDialog.showModal();
    }

    public void renameNode() {
        this.renameNodeDialog.showModal();
    }

    public void updateMixinTypes() {
        this.jcrService.getMixinTypes(this.repository(), this.workspace(), false, new AsyncCallback<String[]>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(String[] result) {
                Contents.this.addMixinDialog.updateMixinTypes(result);
                Contents.this.removeMixinDialog.updateMixinTypes(result);
                Contents.this.saveButton.enable();
            }
        });
    }

    public void addMixin() {
        this.addMixinDialog.showModal();
    }

    public void addMixin(String name) {
        this.jcrService.addMixin(this.repository(), this.workspace(), this.path(), name, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.show();
                Contents.this.saveButton.enable();
            }
        });
    }

    public void removeMixin() {
        this.removeMixinDialog.showModal();
    }

    public void removeMixin(String name) {
        this.jcrService.removeMixin(this.repository(), this.workspace(), this.path(), name, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.show();
                Contents.this.saveButton.enable();
            }
        });
    }

    protected void updatePropertyDefs() {
        this.setPropertyDialog.updatePropertyDefs(this.node.getPropertyDefs());
    }

    public void setProperty() {
        this.setPropertyDialog.showModal();
    }

    protected void setNodeProperty(String name, String value) {
        this.jcrService.setProperty(this.repository(), this.workspace(), this.path(), name, value, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.show();
                Contents.this.saveButton.enable();
            }
        });
    }

    protected void addNode(String name, String primaryType) {
        this.jcrService.addNode(this.repository(), this.workspace(), this.path(), name, primaryType, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.show();
                Contents.this.saveButton.enable();
            }
        });
    }

    protected void renameNode(String name) {
        this.jcrService.renameNode(this.repository(), this.workspace(), this.path(), name, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.show();
                Contents.this.saveButton.enable();
            }
        });
    }

    protected void updatePrimaryTypes() {
        this.jcrService.getPrimaryTypes(this.repository(), this.workspace(), true, new AsyncCallback<String[]>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(String[] result) {
                Contents.this.newNodeDialog.updatePrimaryTypes(result);
                Contents.this.saveButton.enable();
            }
        });
    }

    public void addAccessList() {
        this.addAccessListDialog.showModal();
    }

    public void addAccessList(String name) {
        Acl acl = this.node.getAcl();
        if (acl == null) {
            acl = new Acl();
            this.node.setAcl(acl);
        }
        Policy policy = new Policy();
        policy.setPrincipal(name);
        policy.add(JcrPermission.ALL);
        acl.addPolicy(policy);
        this.accessList.show(this.node);
        this.saveButton.enable();
    }

    public void updateAccessList(String principal, JcrPermission permission, boolean enabled) {
        this.jcrService.updateAccessList(this.repository, this.workspace(), this.path(), principal, permission, enabled, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.show();
                Contents.this.saveButton.enable();
            }
        });
    }

    public void removeAccessList(String name) {
        this.node.getAccessList().remove(name);
        this.accessList.show(this.node);
    }

    public void applyAccessList() {
        this.jcrService.updateAccessList(this.repository(), this.workspace(), this.path(), this.node.getAccessList(), new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.show();
                Contents.this.saveButton.enable();
            }
        });
    }

    public void setNode(JcrNode node) {
        this.node = node;
        this.pathLabel.display(node.getPath());
    }

    public String repository() {
        return this.repository;
    }

    public String workspace() {
        return this.workspaces.getValueAsString();
    }

    public JcrNode node() {
        return this.node;
    }

    public String path() {
        return this.path == null ? "/" : this.path;
    }

    private String parent(String path) {
        if (path == null) {
            return "/";
        }
        if ((path = path.substring(0, path.lastIndexOf(47))).length() == 0) {
            return "/";
        }
        return path;
    }

    private class Spacer
    extends VLayout {
        public Spacer(int size) {
            this.setHeight(size);
        }
    }

    private class PathLabel
    extends HLayout {
        private Label[] segments = new Label[50];
        private Label[] separators = new Label[50];

        public PathLabel() {
            this.setHeight(30);
            Label path = new Label();
            path.setAutoWidth();
            path.setContents("<b>Node:</b>");
            path.setStyleName("text");
            this.addMember((Canvas)path);
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i] = new Label();
                this.segments[i].setAutoWidth();
                this.segments[i].setStyleName("segment");
                this.segments[i].addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        Label label = (Label)event.getSource();
                        Contents.this.select(label.getDataPath(), true);
                    }
                });
                this.separators[i] = new Label();
                this.separators[i].setContents("/");
                this.separators[i].setVisible(false);
                this.separators[i].setAutoWidth();
                this.separators[i].setStyleName("segment-separator");
                this.separators[i].setMargin(Integer.valueOf(3));
                this.addMember((Canvas)this.segments[i]);
                this.addMember((Canvas)this.separators[i]);
            }
        }

        public void display(String url) {
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i].setContents("");
                this.separators[i].setVisible(false);
            }
            String[] tokens = url.split("/");
            if (tokens.length == 0) {
                tokens = new String[]{"/"};
            }
            for (int i = 0; i < tokens.length; ++i) {
                this.segments[i].setContents(tokens[i]);
                String path = "";
                for (int j = 0; j <= i; ++j) {
                    path = path + "/" + this.segments[j].getContents();
                }
                this.segments[i].setTooltip(path);
                this.segments[i].setDataPath(path);
                this.segments[i].draw();
                if (i >= tokens.length - 1) continue;
                this.separators[i].setVisible(true);
            }
        }
    }
}

