/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Img;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.FormItem;
import com.smartgwt.client.widgets.form.fields.TextItem;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;
import com.smartgwt.client.widgets.toolbar.ToolStrip;
import com.smartgwt.client.widgets.toolbar.ToolStripButton;
import java.util.Collection;
import org.modeshape.web.client.Console;
import org.modeshape.web.client.LoginDialog;
import org.modeshape.web.shared.RepositoryName;

public class ToolBar
extends HLayout {
    private Label userName = new Label();

    public ToolBar(final Console console) {
        this.setHeight(50);
        this.setWidth100();
        Img logo = new Img();
        logo.setSrc("icons/logo.png");
        logo.setHeight(30);
        logo.setWidth(190);
        logo.setValign(VerticalAlignment.CENTER);
        ToolStrip strip = new ToolStrip();
        strip.setHeight(50);
        strip.setWidth100();
        strip.addSpacer(120);
        strip.addMember((Canvas)logo);
        strip.addSpacer(10);
        strip.addSeparator();
        strip.addFill();
        VLayout p = new VLayout();
        p.setAlign(VerticalAlignment.CENTER);
        DynamicForm form = new DynamicForm();
        p.addMember((Canvas)form);
        p.setWidth(300);
        final TextItem search = new TextItem();
        search.setTitle("Search");
        search.setWidth(300);
        search.setValue("");
        search.setTop(30);
        form.setItems(new FormItem[]{search});
        strip.setAlign(VerticalAlignment.CENTER);
        strip.addMember((Canvas)p);
        ToolStripButton go = new ToolStripButton();
        go.setTitle("Go");
        go.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                console.jcrService.findRepositories(search.getValueAsString(), new AsyncCallback<Collection<RepositoryName>>(){

                    public void onFailure(Throwable caught) {
                        SC.say((String)caught.getMessage());
                    }

                    public void onSuccess(Collection<RepositoryName> result) {
                        console.showRepositories(result);
                    }
                });
            }
        });
        strip.addButton(go);
        this.userName.setContents("okulikov");
        this.userName.setIcon("icons/bullet_blue.png");
        strip.addSpacer(140);
        strip.addSeparator();
        strip.addMember((Canvas)this.userName);
        strip.addSeparator();
        ToolStripButton loging = new ToolStripButton();
        loging.setTitle("Log in");
        loging.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                new LoginDialog(console);
            }
        });
        ToolStripButton logout = new ToolStripButton();
        logout.setTitle("Log out");
        logout.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                console.jcrService.login(null, null, new AsyncCallback<Object>(){

                    public void onFailure(Throwable caught) {
                        SC.say((String)caught.getMessage());
                    }

                    public void onSuccess(Object result) {
                        console.updateUserName(null);
                    }
                });
            }
        });
        strip.addButton(loging);
        strip.addButton(logout);
        this.addMember((Canvas)strip);
        this.setBackgroundColor("#d3d3d3");
    }

    public void setUserName(String userName) {
        if (userName != null && userName.length() > 0) {
            this.userName.setContents(userName);
        } else {
            this.userName.setContents("anonymous");
        }
    }
}

