/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.ListGridFieldType;
import com.smartgwt.client.widgets.Button;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.widgets.grid.ListGridRecord;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;
import java.util.Collection;
import org.modeshape.web.client.Console;
import org.modeshape.web.client.View;
import org.modeshape.web.client.ViewPort;
import org.modeshape.web.client.grid.Descriptors;
import org.modeshape.web.shared.JcrRepositoryDescriptor;
import org.modeshape.web.shared.Param;

public class RepositoryInfo
extends View {
    private Descriptors descriptors;
    private final NodeTypesPanel nodeTypes;
    private VLayout[] pages;

    public RepositoryInfo(Console console, ViewPort viewPort, View parent) {
        super(viewPort, parent);
        Canvas text = new Canvas();
        text.setContents("<p>Repository descriptors are used to test support for repository features that have a behavioral (as opposed to a data-model) aspect.</br>The full set of valid keys (both standard and implementation-specific) for this repository</p>");
        text.setWidth100();
        text.setAutoHeight();
        text.setStyleName("caption");
        this.descriptors = new Descriptors(console);
        this.nodeTypes = new NodeTypesPanel();
        HLayout vstrut = new HLayout();
        vstrut.setHeight(15);
        HLayout bottomStrut = new HLayout();
        bottomStrut.setHeight(15);
        this.addMember(text);
        this.addMember((Canvas)vstrut);
        this.addMember((Canvas)this.descriptors);
    }

    public void show(JcrRepositoryDescriptor descriptor) {
        this.descriptors.show(descriptor);
    }

    public void showRepositoryInfo() {
    }

    public final void display() {
        this.nodeTypes.display();
    }

    private void showPage(int k) {
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i].setVisible(false);
        }
        this.pages[k].setVisible(true);
        this.pages[k].show();
    }

    public class RepositoryInfoCallbackHandler
    implements AsyncCallback<JcrRepositoryDescriptor> {
        public void onFailure(Throwable caught) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void onSuccess(JcrRepositoryDescriptor descriptor) {
            Collection<Param> params = descriptor.info();
            ListGridRecord[] data = new ListGridRecord[params.size()];
            int i = 0;
            for (Param p : params) {
                ListGridRecord record = new ListGridRecord();
                record.setAttribute("icon", "blue");
                record.setAttribute("name", p.getName());
                record.setAttribute("value", p.getValue());
                data[i++] = record;
            }
        }
    }

    private class NodeTypesPanel
    extends VLayout {
        private ListGrid grid = new ListGrid();

        public NodeTypesPanel() {
            this.grid.setWidth(500);
            this.grid.setHeight(224);
            this.grid.setAlternateRecordStyles(Boolean.valueOf(true));
            this.grid.setShowAllRecords(Boolean.valueOf(true));
            this.grid.setCanEdit(Boolean.valueOf(false));
            ListGridField iconField = new ListGridField("icon", " ");
            iconField.setType(ListGridFieldType.IMAGE);
            iconField.setImageURLPrefix("icons/bullet_");
            iconField.setImageURLSuffix(".png");
            iconField.setWidth(20);
            ListGridField nameField = new ListGridField("name", "Name");
            nameField.setCanEdit(Boolean.valueOf(false));
            nameField.setShowHover(Boolean.valueOf(true));
            ListGridField isPrimaryField = new ListGridField("isPrimary", "Primary");
            isPrimaryField.setCanEdit(Boolean.valueOf(false));
            isPrimaryField.setShowHover(Boolean.valueOf(true));
            ListGridField isMixinField = new ListGridField("isMixin", "Mixin");
            isMixinField.setCanEdit(Boolean.valueOf(false));
            isMixinField.setShowHover(Boolean.valueOf(true));
            ListGridField isAbstractField = new ListGridField("isAbstract", "Abstract");
            isAbstractField.setCanEdit(Boolean.valueOf(false));
            isAbstractField.setShowHover(Boolean.valueOf(true));
            this.grid.setFields(new ListGridField[]{iconField, nameField, isPrimaryField, isMixinField, isAbstractField});
            this.grid.setCanResizeFields(Boolean.valueOf(true));
            this.grid.setWidth100();
            this.grid.setHeight100();
            Label header = new Label();
            header.setContents("Node types");
            header.setHeight(25);
            header.setStyleName("header-label");
            header.setIcon("icons/sprocket.png");
            this.addMember((Canvas)header);
            this.addMember((Canvas)this.grid);
        }

        public void display() {
        }
    }

    public class SwitchPanel
    extends HLayout {
        public SwitchPanel() {
            this.setHeight(30);
            this.setAlign(Alignment.RIGHT);
            Button repoButton = new Button();
            repoButton.setTitle("Repository descriptors");
            repoButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    RepositoryInfo.this.showPage(0);
                }
            });
            repoButton.setHeight(25);
            Button nodeTypeButton = new Button();
            nodeTypeButton.setTitle("Node types");
            nodeTypeButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    RepositoryInfo.this.showPage(1);
                }
            });
            nodeTypeButton.setHeight(25);
            HLayout strut = new HLayout();
            strut.setWidth(5);
            this.addMember((Canvas)repoButton);
            this.addMember((Canvas)strut);
            this.addMember((Canvas)nodeTypeButton);
        }
    }
}

